/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.operations;

import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSStatus;
import org.eclipse.team.internal.ccvs.ui.CVSUIMessages;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.team.internal.ccvs.ui.console.CVSOutputConsole;
import org.eclipse.team.internal.ui.dialogs.MultipleYesNoPrompter;
import org.eclipse.team.ui.TeamOperation;
import org.eclipse.ui.IWorkbenchPart;
import org.osgi.framework.Bundle;

public abstract class CVSOperation
extends TeamOperation
implements IShellProvider {
    private int statusCount;
    private boolean involvesMultipleResources = false;
    private List<IStatus> errors = new ArrayList<IStatus>();
    protected static final IStatus OK = Status.OK_STATUS;
    private Shell shell;
    private MultipleYesNoPrompter prompter;

    protected CVSOperation(IWorkbenchPart part) {
        super(part);
    }

    protected String getJobName() {
        return this.getTaskName();
    }

    protected URL getOperationIcon() {
        return Platform.find((Bundle)CVSUIPlugin.getPlugin().getBundle(), (IPath)new Path("$nl$/icons/full/eview16/cvs_persp.gif"));
    }

    public final void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        this.startOperation();
        try {
            try {
                monitor = Policy.monitorFor(monitor);
                monitor.beginTask(null, 100);
                monitor.setTaskName(this.getTaskName());
                this.execute(Policy.subMonitorFor(monitor, 100));
                this.endOperation();
            }
            catch (CVSException e) {
                throw new InvocationTargetException(e);
            }
        }
        finally {
            monitor.done();
        }
    }

    protected void startOperation() {
        this.statusCount = 0;
        this.resetErrors();
    }

    protected void endOperation() throws CVSException {
        this.handleErrors(this.errors.toArray(new IStatus[this.errors.size()]));
    }

    protected abstract void execute(IProgressMonitor var1) throws CVSException, InterruptedException;

    protected void addError(IStatus status) {
        if (status.isOK()) {
            return;
        }
        if (this.isLastError(status)) {
            return;
        }
        this.errors.add(status);
    }

    protected void collectStatus(IStatus status) {
        if (this.isLastError(status)) {
            return;
        }
        ++this.statusCount;
        if (!status.isOK()) {
            this.addError(status);
        }
    }

    protected void resetErrors() {
        this.errors.clear();
        this.statusCount = 0;
    }

    protected IStatus[] getErrors() {
        return this.errors.toArray(new IStatus[this.errors.size()]);
    }

    protected IStatus getLastError() {
        Assert.isTrue((this.errors.size() > 0 ? 1 : 0) != 0);
        IStatus status = this.errors.get(this.errors.size() - 1);
        return status;
    }

    private boolean isLastError(IStatus status) {
        return this.errors.size() > 0 && this.getLastError() == status;
    }

    protected void asException(IStatus[] errors) throws CVSException {
        if (errors.length == 0) {
            return;
        }
        if (errors.length == 1 && this.statusCount == 1) {
            throw new CVSException(errors[0]);
        }
        MultiStatus result = new MultiStatus("org.eclipse.team.cvs.ui", 0, this.getErrorMessage(errors, this.statusCount), null);
        int i = 0;
        while (i < errors.length) {
            IStatus s = errors[i];
            if (s.isMultiStatus()) {
                result.add((IStatus)new CVSStatus(s.getSeverity(), s.getMessage(), s.getException()));
                result.addAll(s);
            } else {
                result.add(s);
            }
            ++i;
        }
        throw new CVSException((IStatus)result);
    }

    protected final void handleErrors(IStatus[] errors) throws CVSException {
        ArrayList<IStatus> reportableErrors = new ArrayList<IStatus>();
        int i = 0;
        while (i < errors.length) {
            IStatus status = errors[i];
            if (this.isReportableError(status)) {
                reportableErrors.add(status);
            } else if (status.isMultiStatus()) {
                IStatus[] children = status.getChildren();
                int j = 0;
                while (j < children.length) {
                    IStatus child = children[j];
                    if (this.isReportableError(child)) {
                        reportableErrors.add(status);
                        break;
                    }
                    ++j;
                }
            }
            ++i;
        }
        if (!reportableErrors.isEmpty()) {
            this.asException(reportableErrors.toArray(new IStatus[reportableErrors.size()]));
        }
    }

    protected boolean isReportableError(IStatus status) {
        return status.getCode() == -10 || CVSStatus.isInternalError((IStatus)status) || status.getCode() == -6;
    }

    protected String getErrorMessage(IStatus[] failures, int totalOperations) {
        return NLS.bind((String)CVSUIMessages.CVSOperation_0, (Object[])new String[]{String.valueOf(failures.length), String.valueOf(totalOperations)});
    }

    protected boolean promptToOverwrite(String title, String message, IResource resource) {
        if (this.prompter == null) {
            this.prompter = new MultipleYesNoPrompter((IShellProvider)this, title, this.involvesMultipleResources(), false);
        } else {
            this.prompter.setTitle(title);
        }
        try {
            return this.prompter.shouldInclude(message);
        }
        catch (InterruptedException interruptedException) {
            throw new OperationCanceledException();
        }
    }

    protected boolean involvesMultipleResources() {
        return this.involvesMultipleResources;
    }

    public void setInvolvesMultipleResources(boolean b) {
        this.involvesMultipleResources = b;
    }

    protected abstract String getTaskName();

    protected boolean errorsOccurred() {
        for (IStatus status : this.errors) {
            if (this.isReportableError(status)) {
                return true;
            }
            if (!status.isMultiStatus()) continue;
            IStatus[] children = status.getChildren();
            int j = 0;
            while (j < children.length) {
                IStatus child = children[j];
                if (this.isReportableError(child)) {
                    return true;
                }
                ++j;
            }
        }
        return false;
    }

    public Shell getShell() {
        if (this.shell != null && !this.shell.isDisposed()) {
            return this.shell;
        }
        return super.getShell();
    }

    public void setShell(Shell shell) {
        this.shell = shell;
    }

    protected boolean canRunAsJob() {
        return true;
    }

    protected boolean isSameFamilyAs(TeamOperation operation) {
        return operation instanceof CVSOperation;
    }

    protected IAction getShowConsoleAction() {
        return new Action(CVSUIMessages.CVSOperation_1){

            public void run() {
                CVSOutputConsole console = CVSUIPlugin.getPlugin().getConsole();
                if (console != null) {
                    console.show(true);
                }
            }

            public String getToolTipText() {
                return CVSUIMessages.CVSOperation_2;
            }
        };
    }
}

