/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.repo;

import com.ibm.icu.util.StringTokenizer;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.connection.CVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.util.KnownRepositories;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionDelegate;
import org.eclipse.ui.actions.ActionFactory;

public class PasteConnectionStringAction
extends ActionDelegate
implements IViewActionDelegate {
    private IAction action;

    public void run(IAction action) {
        Clipboard clipboard = new Clipboard(PlatformUI.getWorkbench().getDisplay());
        try {
            try {
                Object contents = clipboard.getContents((Transfer)TextTransfer.getInstance());
                if (contents != null && contents instanceof String) {
                    StringTokenizer st = new StringTokenizer((String)contents, System.getProperty("line.separator", "\n"));
                    while (st.hasMoreTokens()) {
                        String connectionString = st.nextToken().trim();
                        CVSRepositoryLocation location = CVSRepositoryLocation.fromString((String)connectionString);
                        if (location == null) continue;
                        KnownRepositories.getInstance().addRepository((ICVSRepositoryLocation)location, true);
                    }
                }
            }
            catch (Exception exception) {
                clipboard.dispose();
            }
        }
        finally {
            clipboard.dispose();
        }
    }

    public void init(IAction action) {
        super.init(action);
        this.action = action;
    }

    public void init(IViewPart view) {
        IActionBars actionBars = view.getViewSite().getActionBars();
        actionBars.setGlobalActionHandler(ActionFactory.PASTE.getId(), this.action);
        actionBars.updateActionBars();
    }
}

