/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.subscriber;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.ResourceMappingContext;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.mapping.provider.SynchronizationScopeManager;
import org.eclipse.team.core.subscribers.Subscriber;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.core.synchronize.SyncInfoSet;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.ICVSResource;
import org.eclipse.team.internal.ccvs.core.client.Command;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.ui.CVSUIMessages;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.team.internal.ccvs.ui.mappings.ChangeSetComparator;
import org.eclipse.team.internal.ccvs.ui.operations.AddOperation;
import org.eclipse.team.internal.ccvs.ui.operations.CommitOperation;
import org.eclipse.team.internal.ccvs.ui.operations.RepositoryProviderOperation;
import org.eclipse.team.internal.ccvs.ui.operations.SingleProjectScopeManager;
import org.eclipse.team.internal.ccvs.ui.operations.SingleProjectSubscriberContext;
import org.eclipse.team.internal.ccvs.ui.repo.RepositoryManager;
import org.eclipse.team.internal.ccvs.ui.subscriber.CVSSubscriberOperation;
import org.eclipse.team.internal.ccvs.ui.subscriber.ToolTipMessageDialog;
import org.eclipse.team.internal.core.subscribers.ChangeSet;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;

public class WorkspaceCommitOperation
extends CVSSubscriberOperation {
    private String comment;
    private SyncInfoSet syncSet;
    private boolean override;

    public WorkspaceCommitOperation(ISynchronizePageConfiguration configuration, IDiffElement[] elements, boolean override) {
        super(configuration, elements);
        this.override = override;
    }

    @Override
    protected String getErrorTitle() {
        return CVSUIMessages.CommitAction_commitFailed;
    }

    protected String getJobName() {
        SyncInfoSet syncSet = this.getSyncInfoSet();
        return NLS.bind((String)CVSUIMessages.CommitAction_jobName, (Object[])new String[]{Integer.valueOf(syncSet.size()).toString()});
    }

    public boolean shouldRun() {
        SyncInfoSet set = this.getSyncInfoSet();
        return !set.isEmpty();
    }

    protected SyncInfoSet getSyncInfoSet() {
        if (this.syncSet == null) {
            this.syncSet = super.getSyncInfoSet();
            if (!this.promptForConflictHandling(this.syncSet)) {
                this.syncSet.clear();
                return this.syncSet;
            }
            try {
                if (!this.promptForUnaddedHandling(this.syncSet)) {
                    this.syncSet.clear();
                    return this.syncSet;
                }
            }
            catch (CVSException e) {
                Utils.handle((Throwable)e);
                this.syncSet.clear();
            }
        }
        return this.syncSet;
    }

    protected boolean promptForConflictHandling(SyncInfoSet syncSet) {
        block4: {
            block5: {
                if (!syncSet.hasConflicts() && !syncSet.hasIncomingChanges()) break block4;
                if (!this.override) break block5;
                switch (this.promptForConflicts(syncSet)) {
                    case 0: {
                        break block4;
                    }
                    case 1: {
                        return false;
                    }
                    default: {
                        return false;
                    }
                }
            }
            syncSet.removeConflictingNodes();
            syncSet.removeIncomingNodes();
        }
        return true;
    }

    @Override
    public void runWithProjectRule(IProject project, SyncInfoSet syncSet, IProgressMonitor monitor) throws TeamException {
        SyncInfo[] changed = syncSet.getSyncInfos();
        if (changed.length == 0) {
            return;
        }
        ArrayList<IResource> commits = new ArrayList<IResource>();
        ArrayList<IResource> additions = new ArrayList<IResource>();
        ArrayList<SyncInfo> makeOutgoing = new ArrayList<SyncInfo>();
        ArrayList<SyncInfo> makeInSync = new ArrayList<SyncInfo>();
        int i = 0;
        while (i < changed.length) {
            block20: {
                int kind;
                SyncInfo changedNode;
                block19: {
                    changedNode = changed[i];
                    kind = changedNode.getKind();
                    IResource resource = changedNode.getLocal();
                    SyncInfo parent = this.getParent(changedNode);
                    if (parent != null && this.isOutOfSync(parent)) {
                        makeInSync.add(parent);
                    }
                    if (resource.getType() != 1) break block19;
                    commits.add(resource);
                    switch (kind & 0xC) {
                        case 8: {
                            makeOutgoing.add(changedNode);
                            break;
                        }
                        case 4: {
                            switch (kind & 3) {
                                case 1: {
                                    if (!this.isAdded(resource)) {
                                        additions.add(resource);
                                        break;
                                    }
                                    break block20;
                                }
                                case 2: {
                                    break;
                                }
                            }
                            break block20;
                        }
                        case 12: {
                            makeOutgoing.add(changedNode);
                        }
                    }
                    break block20;
                }
                if ((kind & 0xC) == 4 && (kind & 3) == 1) {
                    additions.add(changedNode.getLocal());
                } else if (this.isOutOfSync(changedNode)) {
                    makeInSync.add(changedNode);
                }
            }
            ++i;
        }
        monitor.beginTask(null, 200);
        if (makeInSync.size() > 0) {
            this.makeInSync(makeInSync.toArray(new SyncInfo[makeInSync.size()]), Policy.subMonitorFor(monitor, 25));
        }
        if (makeOutgoing.size() > 0) {
            this.makeOutgoing(makeOutgoing.toArray(new SyncInfo[makeInSync.size()]), Policy.subMonitorFor(monitor, 25));
        }
        if (additions.size() != 0) {
            this.add(project, additions.toArray(new IResource[0]), Policy.subMonitorFor(monitor, 50));
        }
        this.commit(project, commits.toArray(new IResource[commits.size()]), Policy.subMonitorFor(monitor, 100));
    }

    private void commit(final IProject project, IResource[] commits, IProgressMonitor monitor) throws TeamException {
        try {
            CommitOperation commitOperation = new CommitOperation(this.getPart(), RepositoryProviderOperation.asResourceMappers(commits), new Command.LocalOption[0], this.comment){

                @Override
                protected ResourceMappingContext getResourceMappingContext() {
                    return new SingleProjectSubscriberContext((Subscriber)CVSProviderPlugin.getPlugin().getCVSWorkspaceSubscriber(), false, project);
                }

                @Override
                protected SynchronizationScopeManager createScopeManager(boolean consultModels) {
                    return new SingleProjectScopeManager(this.getJobName(), this.getSelectedMappings(), this.getResourceMappingContext(), consultModels, project);
                }
            };
            commitOperation.run(monitor);
        }
        catch (InvocationTargetException e) {
            throw TeamException.asTeamException((InvocationTargetException)e);
        }
        catch (InterruptedException interruptedException) {
            throw new OperationCanceledException();
        }
    }

    private void add(final IProject project, IResource[] additions, IProgressMonitor monitor) throws TeamException {
        try {
            new AddOperation(this.getPart(), RepositoryProviderOperation.asResourceMappers(additions)){

                @Override
                protected ResourceMappingContext getResourceMappingContext() {
                    return new SingleProjectSubscriberContext((Subscriber)CVSProviderPlugin.getPlugin().getCVSWorkspaceSubscriber(), false, project);
                }

                @Override
                protected SynchronizationScopeManager createScopeManager(boolean consultModels) {
                    return new SingleProjectScopeManager(this.getJobName(), this.getSelectedMappings(), this.getResourceMappingContext(), consultModels, project);
                }
            }.run(monitor);
        }
        catch (InvocationTargetException e1) {
            throw TeamException.asTeamException((InvocationTargetException)e1);
        }
        catch (InterruptedException interruptedException) {
            throw new OperationCanceledException();
        }
    }

    protected int promptForConflicts(SyncInfoSet syncSet) {
        String[] buttons = new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.CANCEL_LABEL};
        String question = CVSUIMessages.CommitSyncAction_questionRelease;
        String title = CVSUIMessages.CommitSyncAction_titleRelease;
        String[] tips = new String[]{CVSUIMessages.CommitSyncAction_releaseAll, CVSUIMessages.CommitSyncAction_releasePart, CVSUIMessages.CommitSyncAction_cancelRelease};
        Shell shell = this.getShell();
        ToolTipMessageDialog dialog = new ToolTipMessageDialog(shell, title, null, question, 3, buttons, tips, 0);
        shell.getDisplay().syncExec(() -> {
            int n = dialog.open();
        });
        return dialog.getReturnCode();
    }

    protected String promptForComment(RepositoryManager manager, IResource[] resourcesToCommit) {
        String proposedComment = this.getProposedComment(resourcesToCommit);
        return manager.promptForComment(this.getShell(), resourcesToCommit, proposedComment);
    }

    private String getProposedComment(IResource[] resourcesToCommit) {
        StringBuffer comment = new StringBuffer();
        ChangeSet[] sets = CVSUIPlugin.getPlugin().getChangeSetManager().getSets();
        Arrays.sort(sets, new ChangeSetComparator());
        int numMatchedSets = 0;
        int i = 0;
        while (i < sets.length) {
            ChangeSet set = sets[i];
            if (this.containsOne(set, resourcesToCommit)) {
                if (numMatchedSets > 0) {
                    comment.append(System.getProperty("line.separator"));
                }
                comment.append(set.getComment());
                ++numMatchedSets;
            }
            ++i;
        }
        return comment.toString();
    }

    private boolean containsOne(ChangeSet set, IResource[] resourcesToCommit) {
        int j = 0;
        while (j < resourcesToCommit.length) {
            IResource resource = resourcesToCommit[j];
            if (set.contains(resource)) {
                return true;
            }
            ++j;
        }
        return false;
    }

    protected IResource[] promptForResourcesToBeAdded(RepositoryManager manager, IResource[] unadded) {
        return manager.promptForResourcesToBeAdded(this.getShell(), unadded);
    }

    private boolean promptForUnaddedHandling(SyncInfoSet syncSet) throws CVSException {
        if (syncSet.isEmpty()) {
            return false;
        }
        IResource[] unadded = this.getUnaddedResources(syncSet);
        RepositoryManager manager = CVSUIPlugin.getPlugin().getRepositoryManager();
        IResource[] toBeAdded = this.promptForResourcesToBeAdded(manager, unadded);
        if (toBeAdded == null) {
            return false;
        }
        this.comment = this.promptForComment(manager, syncSet.getResources());
        if (this.comment == null) {
            return false;
        }
        if (unadded != null && unadded.length > 0) {
            ArrayList<IResource> resourcesToRemove = new ArrayList<IResource>(unadded.length);
            int i = 0;
            while (i < unadded.length) {
                IResource unaddedResource = unadded[i];
                boolean included = false;
                int j = 0;
                while (j < toBeAdded.length) {
                    IResource resourceToAdd = toBeAdded[j];
                    if (unaddedResource.equals((Object)resourceToAdd)) {
                        included = true;
                        break;
                    }
                    ++j;
                }
                if (!included) {
                    resourcesToRemove.add(unaddedResource);
                }
                ++i;
            }
            syncSet.removeAll(resourcesToRemove.toArray(new IResource[resourcesToRemove.size()]));
        }
        return true;
    }

    private IResource[] getUnaddedResources(SyncInfoSet syncSet) throws CVSException {
        IResource[] resources = syncSet.getResources();
        ArrayList<IResource> result = new ArrayList<IResource>();
        int i = 0;
        while (i < resources.length) {
            IResource resource = resources[i];
            if (!this.isAdded(resource)) {
                result.add(resource);
            }
            ++i;
        }
        return result.toArray(new IResource[result.size()]);
    }

    private boolean isAdded(IResource resource) throws CVSException {
        ICVSResource cvsResource = CVSWorkspaceRoot.getCVSResourceFor((IResource)resource);
        if (cvsResource.isFolder()) {
            return ((ICVSFolder)cvsResource).isCVSFolder();
        }
        return cvsResource.isManaged();
    }
}

