/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.ui.themes;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Display;
import org.eclipse.tm4e.core.theme.RGB;
import org.eclipse.tm4e.ui.utils.PreferenceUtils;

public class ColorManager {
    private static final ColorManager INSTANCE = new ColorManager();
    private final Map<RGB, Color> fColorTable = new HashMap<RGB, Color>(10);

    public static ColorManager getInstance() {
        return INSTANCE;
    }

    private ColorManager() {
    }

    public Color getColor(RGB rgb) {
        Color color = this.fColorTable.get(rgb);
        if (color == null) {
            color = new Color((Device)Display.getCurrent(), rgb.red, rgb.green, rgb.blue);
            this.fColorTable.put(rgb, color);
        }
        return color;
    }

    public void dispose() {
        Iterator<Color> e = this.fColorTable.values().iterator();
        while (e.hasNext()) {
            e.next().dispose();
        }
    }

    public Color getPreferenceEditorColor(String tokenId) {
        return this.getColor(this.stringToRGB(PreferenceUtils.getEditorsPreferenceStore().get(tokenId, "")));
    }

    public boolean isColorUserDefined(String tokenId) {
        String systemDefaultToken = this.getSystemDefaultToken(tokenId);
        return systemDefaultToken != "" ? !PreferenceUtils.getEditorsPreferenceStore().getBoolean(systemDefaultToken, true) : true;
    }

    public Color getPriorityColor(Color themeColor, String tokenId) {
        Color prefColor = this.getPreferenceEditorColor(tokenId);
        if (this.isColorUserDefined(tokenId)) {
            return prefColor;
        }
        return themeColor != null ? themeColor : null;
    }

    private String getSystemDefaultToken(String tokenId) {
        switch (tokenId) {
            case "AbstractTextEditor.Color.Foreground": {
                return "AbstractTextEditor.Color.Foreground.SystemDefault";
            }
            case "AbstractTextEditor.Color.Background": {
                return "AbstractTextEditor.Color.Background.SystemDefault";
            }
            case "AbstractTextEditor.Color.SelectionBackground": {
                return "AbstractTextEditor.Color.SelectionBackground.SystemDefault";
            }
            case "AbstractTextEditor.Color.SelectionForeground": {
                return "AbstractTextEditor.Color.SelectionForeground.SystemDefault";
            }
        }
        return "";
    }

    private RGB stringToRGB(String value) {
        String[] rgbValues = value.split(",");
        return rgbValues.length == 3 ? new RGB(Integer.parseInt(rgbValues[0]), Integer.parseInt(rgbValues[1]), Integer.parseInt(rgbValues[2])) : new RGB(255, 255, 255);
    }
}

