/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.os.linux.core.inputoutput;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.eclipse.tracecompass.analysis.os.linux.core.inputoutput.Disk;
import org.eclipse.tracecompass.analysis.os.linux.core.inputoutput.InputOutputAnalysisModule;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;

public final class InputOutputInformationProvider {
    private InputOutputInformationProvider() {
    }

    public static Collection<Disk> getDisks(InputOutputAnalysisModule module) {
        module.schedule();
        if (!module.waitForInitialization()) {
            return Collections.emptySet();
        }
        ITmfStateSystem ss = module.getStateSystem();
        if (ss == null) {
            throw new IllegalStateException("The state system should not be null at this point");
        }
        HashSet<Disk> disks = new HashSet<Disk>();
        for (Integer diskQuark : ss.getQuarks(new String[]{"Disks", "*"})) {
            String devName = ss.getAttributeName(diskQuark.intValue());
            disks.add(new Disk(Integer.parseInt(devName), ss, diskQuark));
        }
        return disks;
    }
}

