/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.addon.querybasedfeatures.runtime;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.BasicSettingDelegate;
import org.eclipse.viatra.addon.querybasedfeatures.runtime.QueryBasedFeature;
import org.eclipse.viatra.addon.querybasedfeatures.runtime.QueryBasedFeatureHelper;
import org.eclipse.viatra.addon.querybasedfeatures.runtime.QueryBasedFeatureKind;
import org.eclipse.viatra.addon.querybasedfeatures.runtime.QueryBasedFeatureSettingDelegateFactory;
import org.eclipse.viatra.query.runtime.api.AdvancedViatraQueryEngine;
import org.eclipse.viatra.query.runtime.api.IPatternMatch;
import org.eclipse.viatra.query.runtime.api.IQuerySpecification;
import org.eclipse.viatra.query.runtime.api.ViatraQueryEngine;
import org.eclipse.viatra.query.runtime.api.ViatraQueryMatcher;
import org.eclipse.viatra.query.runtime.exception.ViatraQueryException;
import org.eclipse.viatra.query.runtime.matchers.psystem.annotations.PAnnotation;
import org.eclipse.viatra.query.runtime.matchers.util.Preconditions;
import org.eclipse.viatra.query.runtime.util.ViatraQueryLoggingUtil;

public class QueryBasedFeatureSettingDelegate
extends BasicSettingDelegate.Stateless {
    private final Map<AdvancedViatraQueryEngine, WeakReference<QueryBasedFeature>> queryBasedFeatures = new WeakHashMap<AdvancedViatraQueryEngine, WeakReference<QueryBasedFeature>>();
    private final IQuerySpecification<? extends ViatraQueryMatcher<? extends IPatternMatch>> querySpecification;
    private final QueryBasedFeatureSettingDelegateFactory delegateFactory;
    private final boolean dynamicEMFMode;
    private boolean isResourceScope;
    private QueryBasedFeatureParameters parameters;

    public QueryBasedFeatureSettingDelegate(EStructuralFeature eStructuralFeature, QueryBasedFeatureSettingDelegateFactory factory, IQuerySpecification<?> querySpecification, boolean dynamicEMFMode) {
        this(eStructuralFeature, factory, querySpecification, false, dynamicEMFMode);
    }

    public QueryBasedFeatureSettingDelegate(EStructuralFeature eStructuralFeature, QueryBasedFeatureSettingDelegateFactory factory, IQuerySpecification<?> querySpecification, boolean isResourceScope, boolean dynamicEMFMode) {
        super(eStructuralFeature);
        this.delegateFactory = factory;
        this.querySpecification = querySpecification;
        this.dynamicEMFMode = dynamicEMFMode;
        this.isResourceScope = isResourceScope;
        this.parameters = new QueryBasedFeatureParameters(querySpecification);
        List qbfAnnotations = querySpecification.getAnnotationsByName("QueryBasedFeature");
        if (!qbfAnnotations.isEmpty()) {
            if (qbfAnnotations.size() == 1) {
                PAnnotation annotation = (PAnnotation)qbfAnnotations.iterator().next();
                this.processQBFAnnotation(annotation);
            } else {
                for (PAnnotation annotation : qbfAnnotations) {
                    annotation.getFirstValue("feature", String.class).filter(featureParam -> eStructuralFeature.getName().equals(featureParam)).ifPresent(featureParam -> this.processQBFAnnotation(annotation));
                }
            }
        }
    }

    private void processQBFAnnotation(PAnnotation annotation) {
        this.parameters.sourceVar = annotation.getFirstValue("source", String.class).orElse(this.parameters.defaultSourceVar);
        this.parameters.targetVar = annotation.getFirstValue("target", String.class).orElse(this.parameters.defaultTargetVar);
        this.parameters.keepCache = annotation.getFirstValue("keepCache", Boolean.class).orElse(this.parameters.defaultKeepCache);
        this.parameters.kind = annotation.getFirstValue("kind", String.class).map(QueryBasedFeatureKind::parseKindString).orElse(this.parameters.defaultKind);
    }

    protected Object get(InternalEObject owner, boolean resolve, boolean coreType) {
        Resource notifierForSource = null;
        if (this.isResourceScope) {
            notifierForSource = owner.eResource();
        }
        if (notifierForSource == null) {
            notifierForSource = QueryBasedFeatureHelper.prepareNotifierForSource((EObject)owner);
        }
        QueryBasedFeature queryBasedFeature = this.initializeSettingDelegateInternal((Notifier)notifierForSource);
        return queryBasedFeature.getValue(owner);
    }

    public void initializeSettingDelegate(Notifier rootNotifier) {
        Preconditions.checkArgument((rootNotifier != null ? 1 : 0) != 0, (String)"Notifier cannot be null");
        this.initializeSettingDelegateInternal(rootNotifier);
    }

    private QueryBasedFeature initializeSettingDelegateInternal(Notifier notifierForSource) {
        QueryBasedFeature queryBasedFeature;
        AdvancedViatraQueryEngine engine = null;
        try {
            engine = this.delegateFactory.getEngineForNotifier(notifierForSource, this.dynamicEMFMode);
        }
        catch (ViatraQueryException e) {
            ViatraQueryLoggingUtil.getLogger(((Object)((Object)this)).getClass()).error((Object)"Engine preparation failed", (Throwable)e);
            throw new IllegalStateException("Engine preparation failed", e);
        }
        WeakReference<QueryBasedFeature> weakReference = this.queryBasedFeatures.get(engine);
        QueryBasedFeature queryBasedFeature2 = queryBasedFeature = weakReference == null ? null : (QueryBasedFeature)weakReference.get();
        if (queryBasedFeature == null && (queryBasedFeature = QueryBasedFeatureHelper.createQueryBasedFeature(this.eStructuralFeature, this.parameters.kind, this.parameters.keepCache)) != null) {
            this.queryBasedFeatures.put(engine, new WeakReference<QueryBasedFeature>(queryBasedFeature));
        }
        if (queryBasedFeature != null && !queryBasedFeature.isInitialized()) {
            this.initializeQueryBasedFeature(engine, queryBasedFeature);
        }
        return queryBasedFeature;
    }

    private void initializeQueryBasedFeature(AdvancedViatraQueryEngine engine, QueryBasedFeature queryBasedFeature) {
        try {
            List delayedFeatures = this.delegateFactory.getDelayedFeatures().get((Object)engine);
            if (!delayedFeatures.contains(queryBasedFeature)) {
                delayedFeatures.add(queryBasedFeature);
                ViatraQueryMatcher matcher = this.querySpecification.getMatcher((ViatraQueryEngine)engine);
                if (!queryBasedFeature.isInitialized()) {
                    queryBasedFeature.setMatcher((ViatraQueryMatcher<IPatternMatch>)matcher);
                    queryBasedFeature.setSourceParamName(this.parameters.sourceVar);
                    queryBasedFeature.setTargetParamName(this.parameters.targetVar);
                    Iterator iterator = delayedFeatures.iterator();
                    if (iterator.hasNext() && ((QueryBasedFeature)iterator.next()).equals(queryBasedFeature)) {
                        this.initializeDelayedFeature(queryBasedFeature, delayedFeatures);
                        ArrayList delayedFeatureList = new ArrayList(delayedFeatures);
                        for (QueryBasedFeature delayedFeature : delayedFeatureList) {
                            this.initializeDelayedFeature(delayedFeature, delayedFeatures);
                        }
                    }
                }
            }
        }
        catch (ViatraQueryException e) {
            ViatraQueryLoggingUtil.getLogger(((Object)((Object)this)).getClass()).error((Object)"Handler initialization failed", (Throwable)e);
        }
    }

    private void initializeDelayedFeature(QueryBasedFeature queryBasedFeature, List<QueryBasedFeature> delayedFeatures) {
        queryBasedFeature.initialize(queryBasedFeature.getMatcher(), queryBasedFeature.getSourceParamName(), queryBasedFeature.getTargetParamName());
        queryBasedFeature.startMonitoring();
        delayedFeatures.remove(queryBasedFeature);
    }

    protected boolean isSet(InternalEObject owner) {
        return false;
    }

    private class QueryBasedFeatureParameters {
        private String sourceVar;
        private String targetVar;
        private QueryBasedFeatureKind kind;
        private boolean keepCache;
        private final String defaultSourceVar;
        private final String defaultTargetVar;
        private final QueryBasedFeatureKind defaultKind;
        private final boolean defaultKeepCache;

        public QueryBasedFeatureParameters(IQuerySpecification<? extends ViatraQueryMatcher<? extends IPatternMatch>> querySpecification) {
            List parameterNames = querySpecification.getParameterNames();
            this.defaultSourceVar = this.sourceVar = (String)parameterNames.get(0);
            this.defaultTargetVar = this.targetVar = (String)parameterNames.get(1);
            this.keepCache = true;
            this.defaultKeepCache = true;
            this.defaultKind = QueryBasedFeatureSettingDelegate.this.eStructuralFeature.isMany() ? (this.kind = QueryBasedFeatureKind.MANY_REFERENCE) : (this.kind = QueryBasedFeatureKind.SINGLE_REFERENCE);
        }
    }
}

