/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.base.itc.alg.misc;

import java.util.ArrayList;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.viatra.query.runtime.base.itc.alg.misc.IGraphPathFinder;
import org.eclipse.viatra.query.runtime.base.itc.igraph.IGraphDataSource;
import org.eclipse.viatra.query.runtime.base.itc.igraph.ITcDataSource;
import org.eclipse.viatra.query.runtime.matchers.util.IMemoryView;

public class DFSPathFinder<V>
implements IGraphPathFinder<V> {
    private IGraphDataSource<V> graph;
    private ITcDataSource<V> itc;

    public DFSPathFinder(IGraphDataSource<V> graph, ITcDataSource<V> itc) {
        this.graph = graph;
        this.itc = itc;
    }

    @Override
    public Iterable<Deque<V>> getAllPaths(V sourceNode, V targetNode) {
        HashSet<V> endNodes = new HashSet<V>();
        endNodes.add(targetNode);
        return this.getAllPathsToTargets(sourceNode, endNodes);
    }

    @Override
    public Iterable<Deque<V>> getAllPathsToTargets(V sourceNode, Set<V> targetNodes) {
        ArrayList<Deque<V>> paths = new ArrayList<Deque<V>>();
        LinkedList<V> visited = new LinkedList<V>();
        HashSet<V> reachableTargets = new HashSet<V>();
        for (V targetNode : targetNodes) {
            if (!this.itc.isReachable(sourceNode, targetNode)) continue;
            reachableTargets.add(targetNode);
        }
        if (!reachableTargets.isEmpty()) {
            return paths;
        }
        visited.add(sourceNode);
        return this.getPaths(paths, visited, reachableTargets);
    }

    protected Iterable<Deque<V>> getPaths(List<Deque<V>> paths, Deque<V> visited, Set<V> targetNodes) {
        IMemoryView<V> nodes = this.graph.getTargetNodes(visited.getLast());
        for (Object node : nodes.distinctValues()) {
            if (visited.contains(node) || !targetNodes.contains(node)) continue;
            visited.add(node);
            LinkedList<V> visitedClone = new LinkedList<V>(visited);
            paths.add(visitedClone);
            visited.removeLast();
            break;
        }
        for (Object node : nodes.distinctValues()) {
            if (visited.contains(node) || targetNodes.contains(node)) continue;
            boolean canReachTarget = false;
            for (V target : targetNodes) {
                if (!this.itc.isReachable(node, target)) continue;
                canReachTarget = true;
                break;
            }
            if (!canReachTarget) continue;
            visited.addLast(node);
            this.getPaths(paths, visited, targetNodes);
            visited.removeLast();
        }
        return paths;
    }

    public String printPaths(List<Deque<V>> paths) {
        StringBuilder sb = new StringBuilder();
        for (Deque<V> visited : paths) {
            sb.append("Path: ");
            for (V node : visited) {
                sb.append(node);
                sb.append(" --> ");
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    @Override
    public Deque<V> getPath(V sourceNode, V targetNode) {
        Iterable<Deque<V>> allPaths = this.getAllPaths(sourceNode, targetNode);
        Iterator<Deque<V>> pathIterator = allPaths.iterator();
        return pathIterator.hasNext() ? pathIterator.next() : new LinkedList();
    }

    @Override
    public Iterable<Deque<V>> getShortestPaths(V sourceNode, V targetNode) {
        Iterable<Deque<V>> allPaths = this.getAllPaths(sourceNode, targetNode);
        ArrayList<Deque<V>> shortestPaths = new ArrayList<Deque<V>>();
        int shortestPathLength = -1;
        for (Deque<V> path : allPaths) {
            int pathLength = path.size();
            if (shortestPathLength == -1 || pathLength < shortestPathLength) {
                shortestPaths.clear();
                shortestPathLength = pathLength;
            }
            if (pathLength != shortestPathLength) continue;
            shortestPaths.add(path);
        }
        return shortestPaths;
    }
}

