/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.transformation.evm.api.event.adapter;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.viatra.query.runtime.matchers.util.Preconditions;
import org.eclipse.viatra.transformation.evm.api.event.Event;
import org.eclipse.viatra.transformation.evm.api.event.EventHandler;
import org.eclipse.viatra.transformation.evm.api.event.EventRealm;
import org.eclipse.viatra.transformation.evm.api.event.EventSource;
import org.eclipse.viatra.transformation.evm.api.event.EventSourceSpecification;

public abstract class EventSourceAdapter<EventAtom>
implements EventSource<EventAtom> {
    private static final String HANDLER_NULL_MSG = "Handler cannot be null!";
    private final EventSourceSpecification<EventAtom> specification;
    private final EventRealm realm;
    private final Set<EventHandler<EventAtom>> handlers;

    public EventSourceAdapter(EventSourceSpecification<EventAtom> specification, EventRealm realm) {
        Preconditions.checkArgument((realm != null ? 1 : 0) != 0, (String)"Cannot create event source for null realm!");
        Preconditions.checkArgument((specification != null ? 1 : 0) != 0, (String)"Cannot create event source for null source specification!");
        this.specification = specification;
        this.realm = realm;
        this.handlers = new HashSet<EventHandler<EventAtom>>();
    }

    @Override
    public EventSourceSpecification<EventAtom> getSourceSpecification() {
        return this.specification;
    }

    @Override
    public EventRealm getRealm() {
        return this.realm;
    }

    public boolean addHandler(EventHandler<EventAtom> handler) {
        Preconditions.checkArgument((handler != null ? 1 : 0) != 0, (String)HANDLER_NULL_MSG);
        boolean empty = this.handlers.isEmpty();
        this.beforeHandlerAdded(handler, empty);
        boolean added = this.handlers.add(handler);
        if (this.handlers.add(handler)) {
            this.afterHandlerAdded(handler, empty);
        }
        return added;
    }

    public boolean removeHandler(EventHandler<EventAtom> handler) {
        Preconditions.checkArgument((handler != null ? 1 : 0) != 0, (String)HANDLER_NULL_MSG);
        this.beforeHandlerRemoved(handler, this.handlers.size() == 1);
        boolean removed = this.handlers.remove(handler);
        if (removed) {
            this.afterHandlerRemoved(handler, this.handlers.isEmpty());
        }
        return removed;
    }

    public void notifyHandlers(Event<EventAtom> event) {
        for (EventHandler<EventAtom> handler : this.handlers) {
            handler.handleEvent(event);
        }
    }

    protected void beforeHandlerAdded(EventHandler<EventAtom> handler, boolean handlersEmpty) {
    }

    protected void afterHandlerAdded(EventHandler<EventAtom> handler, boolean firstHandler) {
    }

    protected void beforeHandlerRemoved(EventHandler<EventAtom> handler, boolean lastHandler) {
    }

    protected void afterHandlerRemoved(EventHandler<EventAtom> handler, boolean handlersEmpty) {
    }

    protected abstract void prepareSource();

    @Override
    public void dispose() {
        for (EventHandler<EventAtom> handler : this.handlers) {
            handler.dispose();
        }
        this.handlers.clear();
    }
}

