/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.core.gef.policy.selection;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.wb.core.gef.command.EditCommand;
import org.eclipse.wb.core.gef.policy.selection.TopResizeFigure;
import org.eclipse.wb.core.model.IAbstractComponentInfo;
import org.eclipse.wb.core.model.IObjectInfo;
import org.eclipse.wb.core.model.ITopBoundsSupport;
import org.eclipse.wb.draw2d.Figure;
import org.eclipse.wb.draw2d.FigureUtils;
import org.eclipse.wb.draw2d.geometry.Rectangle;
import org.eclipse.wb.draw2d.geometry.Translatable;
import org.eclipse.wb.gef.core.Command;
import org.eclipse.wb.gef.core.requests.ChangeBoundsRequest;
import org.eclipse.wb.gef.core.requests.Request;
import org.eclipse.wb.gef.core.tools.Tool;
import org.eclipse.wb.gef.graphical.handles.Handle;
import org.eclipse.wb.gef.graphical.handles.MoveHandle;
import org.eclipse.wb.gef.graphical.handles.ResizeHandle;
import org.eclipse.wb.gef.graphical.policies.SelectionEditPolicy;
import org.eclipse.wb.gef.graphical.tools.ResizeTracker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TopSelectionEditPolicy
extends SelectionEditPolicy {
    private static final String REQ_RESIZE = "resize";
    private final IAbstractComponentInfo m_component;
    private TopResizeFigure m_resizeFeedback;

    public TopSelectionEditPolicy(IAbstractComponentInfo component) {
        this.m_component = component;
    }

    protected List<Handle> createSelectionHandles() {
        ArrayList handles = Lists.newArrayList();
        handles.add(new MoveHandle(this.getHost()));
        handles.add(this.createResizeHandle(16));
        handles.add(this.createResizeHandle(20));
        handles.add(this.createResizeHandle(4));
        return handles;
    }

    private Handle createResizeHandle(int direction) {
        ResizeHandle handle = new ResizeHandle(this.getHost(), direction);
        handle.setDragTrackerTool((Tool)new ResizeTracker(direction, (Object)REQ_RESIZE));
        return handle;
    }

    public boolean understandsRequest(Request request) {
        return super.understandsRequest(request) || request.getType() == REQ_RESIZE;
    }

    public Command getCommand(Request request) {
        return this.getResizeCommand((ChangeBoundsRequest)request);
    }

    public void showSourceFeedback(Request request) {
        this.showResizeFeedback((ChangeBoundsRequest)request);
    }

    public void eraseSourceFeedback(Request request) {
        this.eraseResizeFeedback((ChangeBoundsRequest)request);
    }

    private Command getResizeCommand(ChangeBoundsRequest request) {
        Rectangle oldBounds = this.getHost().getFigure().getBounds();
        final Rectangle newBounds = request.getTransformedRectangle(oldBounds);
        TopSelectionEditPolicy.sanitizeBounds(newBounds);
        return new EditCommand((IObjectInfo)this.m_component){

            protected void executeEdit() throws Exception {
                ITopBoundsSupport topBoundsSupport = TopSelectionEditPolicy.this.m_component.getTopBoundsSupport();
                topBoundsSupport.setSize(newBounds.width, newBounds.height);
            }
        };
    }

    protected void showResizeFeedback(ChangeBoundsRequest request) {
        if (this.m_resizeFeedback == null) {
            this.m_resizeFeedback = new TopResizeFigure();
            this.addFeedback((Figure)this.m_resizeFeedback);
        }
        Figure hostFigure = this.getHostFigure();
        Rectangle bounds = request.getTransformedRectangle(hostFigure.getBounds());
        TopSelectionEditPolicy.sanitizeBounds(bounds);
        FigureUtils.translateFigureToAbsolute((Figure)hostFigure, (Translatable)bounds);
        String sizeText = "[" + Integer.toString(bounds.width) + " x " + Integer.toString(bounds.height) + "]";
        this.m_resizeFeedback.setSizeText(sizeText);
        this.m_resizeFeedback.setBounds(bounds);
    }

    private void eraseResizeFeedback(ChangeBoundsRequest request) {
        if (this.m_resizeFeedback != null) {
            this.removeFeedback((Figure)this.m_resizeFeedback);
            this.m_resizeFeedback = null;
        }
    }

    private static void sanitizeBounds(Rectangle bounds) {
        bounds.width = Math.max(bounds.width, 10);
        bounds.height = Math.max(bounds.height, 10);
    }
}

