/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model;

import java.util.Map;
import org.eclipse.wb.core.model.IWrapper;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.model.JavaInfoUtils;
import org.eclipse.wb.internal.core.model.creation.CreationSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractWrapper
implements IWrapper {
    protected final JavaInfo m_wrapperInfo;
    protected JavaInfo m_wrappedInfo = null;

    public AbstractWrapper(JavaInfo host) {
        this.m_wrapperInfo = host;
    }

    @Override
    public JavaInfo getWrapperInfo() {
        return this.m_wrapperInfo;
    }

    @Override
    public JavaInfo getWrappedInfo() throws Exception {
        if (this.m_wrappedInfo == null) {
            this.m_wrappedInfo = JavaInfoUtils.createJavaInfo(this.m_wrapperInfo.getEditor(), this.getWrappedType(), this.newWrappedCreationSupport());
            this.inheritParameters(this.m_wrappedInfo);
        }
        return this.m_wrappedInfo;
    }

    public abstract Class<?> getWrappedType();

    protected abstract CreationSupport newWrappedCreationSupport() throws Exception;

    protected void inheritParameters(JavaInfo javaInfo) {
        Map<String, String> parameters = JavaInfoUtils.getParameters(this.m_wrapperInfo);
        for (Map.Entry<String, String> entry : parameters.entrySet()) {
            String keyName = entry.getKey();
            if (!keyName.startsWith("wrapped.")) continue;
            JavaInfoUtils.setParameter(javaInfo, keyName.substring(8), entry.getValue());
        }
    }
}

