/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.creation;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.association.Association;
import org.eclipse.wb.core.model.association.ConstructorParentAssociation;
import org.eclipse.wb.internal.core.model.JavaInfoUtils;
import org.eclipse.wb.internal.core.model.clipboard.IClipboardCreationSupport;
import org.eclipse.wb.internal.core.model.creation.CreationSupport;
import org.eclipse.wb.internal.core.model.creation.CreationSupportUtils;
import org.eclipse.wb.internal.core.model.creation.ILiveCreationSupport;
import org.eclipse.wb.internal.core.model.description.ComponentDescription;
import org.eclipse.wb.internal.core.model.description.ConstructorDescription;
import org.eclipse.wb.internal.core.model.description.CreationDescription;
import org.eclipse.wb.internal.core.model.description.CreationInvocationDescription;
import org.eclipse.wb.internal.core.model.description.GenericPropertyDescription;
import org.eclipse.wb.internal.core.model.description.ParameterDescription;
import org.eclipse.wb.internal.core.model.description.helpers.ComponentDescriptionHelper;
import org.eclipse.wb.internal.core.model.property.ComplexProperty;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.property.accessor.ConstructorAccessor;
import org.eclipse.wb.internal.core.model.property.accessor.ExpressionAccessor;
import org.eclipse.wb.internal.core.model.property.category.PropertyCategory;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.core.utils.ast.AstNodeUtils;
import org.eclipse.wb.internal.core.utils.ast.DomGenerics;
import org.eclipse.wb.internal.core.utils.ast.NodeTarget;
import org.eclipse.wb.internal.core.utils.exception.DesignerException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ConstructorCreationSupport
extends CreationSupport
implements ILiveCreationSupport {
    private ClassInstanceCreation m_creation;
    private IMethodBinding m_binding;
    private ConstructorDescription m_description;
    private CreationSupportUtils m_utils;
    private boolean m_addInvocations;
    private String m_creationId;
    private String m_creationSource;
    private final Set<String> m_validParentSources = Sets.newTreeSet();
    private final Set<String> m_invalidParentSources = Sets.newTreeSet();
    private ComplexProperty m_complexProperty;

    public ConstructorCreationSupport(ClassInstanceCreation creation) {
        this.setCreation(creation);
    }

    public ConstructorCreationSupport() {
        this(null, true);
    }

    public ConstructorCreationSupport(String creationId, boolean addInvocations) {
        this.m_creationId = creationId;
        this.m_addInvocations = addInvocations;
    }

    public static ConstructorCreationSupport forSource(String source) {
        ConstructorCreationSupport creation = new ConstructorCreationSupport();
        creation.m_creationSource = source;
        creation.m_addInvocations = false;
        return creation;
    }

    private void setCreation(ClassInstanceCreation creation) {
        this.m_creation = creation;
        this.m_binding = AstNodeUtils.getCreationBinding(this.m_creation);
        this.initializeConstructorDescription();
    }

    private void initializeConstructorDescription() {
        if (this.m_javaInfo != null && this.m_creation != null) {
            ComponentDescription componentDescription = this.m_javaInfo.getDescription();
            this.m_description = componentDescription.getConstructor(this.m_binding);
            if (this.m_description == null) {
                String source = this.m_javaInfo.getEditor().getSource((ASTNode)this.m_creation);
                throw new DesignerException(208, new String[]{source});
            }
            ComponentDescriptionHelper.ensureInitialized(this.m_javaInfo.getEditor().getJavaProject(), this.m_description);
        }
    }

    public String toString() {
        return "new: " + this.getComponentClass().getName() + (this.m_creationId != null ? " " + this.m_creationId : "");
    }

    @Override
    public void setJavaInfo(JavaInfo javaInfo) throws Exception {
        super.setJavaInfo(javaInfo);
        this.initializeConstructorDescription();
        CreationDescription creationDescription = this.m_javaInfo.getDescription().getCreation(this.m_creationId);
        for (Map.Entry<String, String> entry : creationDescription.getParameters().entrySet()) {
            JavaInfoUtils.setParameter(javaInfo, entry.getKey(), entry.getValue());
        }
        Map<String, CreationDescription.TypeParameterDescription> typeParameters = creationDescription.getTypeParameters();
        for (Map.Entry<String, CreationDescription.TypeParameterDescription> parameter : typeParameters.entrySet()) {
            this.m_javaInfo.putTemplateArgument(parameter.getKey(), parameter.getValue().getTypeName());
        }
        this.m_utils = new CreationSupportUtils(this.m_javaInfo);
    }

    @Override
    public boolean isJavaInfo(ASTNode node) {
        return node == this.m_creation;
    }

    @Override
    public ASTNode getNode() {
        return this.m_creation;
    }

    @Override
    public CreationSupport getLiveComponentCreation() {
        return new ConstructorCreationSupport(this.m_creationId, this.m_addInvocations);
    }

    public ClassInstanceCreation getCreation() {
        return this.m_creation;
    }

    public IMethodBinding getBinding() {
        return this.m_binding;
    }

    public ConstructorDescription getDescription() {
        return this.m_description;
    }

    @Override
    public boolean canUseParent(JavaInfo parent) throws Exception {
        Class<?> parentType = parent.getDescription().getComponentClass();
        if (this.m_description == null) {
            return this.canUseParent_noDescription(parent, parentType);
        }
        for (ParameterDescription parameter : this.m_description.getParameters()) {
            Class<?> requiredType;
            if (!parameter.isParent() || (requiredType = parameter.getType()).isAssignableFrom(parentType)) continue;
            return false;
        }
        return true;
    }

    private boolean canUseParent_noDescription(JavaInfo parent, Class<?> parentType) throws Exception {
        String source = this.add_getSource(null);
        if (!source.contains("%parent%")) {
            return true;
        }
        if (this.m_validParentSources.contains(source = StringUtils.replace((String)source, (String)"%parent%", (String)("(" + parentType.getName() + ") null")))) {
            return true;
        }
        if (this.m_invalidParentSources.contains(source)) {
            return false;
        }
        int position = parent.getCreationSupport().getNode().getStartPosition();
        ClassInstanceCreation creation = (ClassInstanceCreation)this.m_javaInfo.getEditor().getParser().parseExpression(position, source);
        IMethodBinding creationBinding = AstNodeUtils.getCreationBinding(creation);
        ITypeBinding[] parameterTypes = creationBinding.getParameterTypes();
        int i = 0;
        while (i < parameterTypes.length) {
            ITypeBinding parameterType = parameterTypes[i];
            Expression argument = DomGenerics.arguments(creation).get(i);
            if (!AstNodeUtils.isSuccessorOf(argument, parameterType)) {
                this.m_invalidParentSources.add(source);
                return false;
            }
            ++i;
        }
        this.m_validParentSources.add(source);
        return true;
    }

    @Override
    public boolean canReorder() {
        return true;
    }

    @Override
    public boolean canReparent() {
        return true;
    }

    @Override
    public void addProperties(List<Property> properties) throws Exception {
        if (this.m_complexProperty == null) {
            this.m_complexProperty = new ComplexProperty("Constructor", "(Constructor properties)");
            this.m_complexProperty.setCategory(PropertyCategory.system((int)3));
            this.m_complexProperty.setModified(true);
            ArrayList subPropertiesList = Lists.newArrayList();
            for (ParameterDescription parameter : this.m_description.getParameters()) {
                Property property = this.m_utils.createProperty(parameter);
                if (property == null) continue;
                subPropertiesList.add(property);
            }
            if (!subPropertiesList.isEmpty()) {
                this.m_complexProperty.setProperties((List)subPropertiesList);
            }
        }
        if (this.m_complexProperty.getProperties().length != 0) {
            properties.add((Property)this.m_complexProperty);
        }
    }

    @Override
    public void addAccessors(GenericPropertyDescription propertyDescription, List<ExpressionAccessor> accessors) throws Exception {
        List<ParameterDescription> parameters = this.m_description.getParameters();
        for (ParameterDescription parameter : parameters) {
            if (!propertyDescription.getId().equals(parameter.getProperty())) continue;
            accessors.add(new ConstructorAccessor(parameter.getIndex(), parameter.getDefaultSource()));
        }
    }

    @Override
    public String add_getSource(NodeTarget target) throws Exception {
        if (this.m_creationSource != null) {
            return this.m_creationSource;
        }
        CreationDescription creationDescription = this.m_javaInfo.getDescription().getCreation(this.m_creationId);
        return creationDescription.getSource();
    }

    @Override
    public void add_setSourceExpression(Expression expression) throws Exception {
        ClassInstanceCreation creation = (ClassInstanceCreation)expression;
        this.setCreation(creation);
        this.m_javaInfo.bindToExpression((Expression)creation);
        if (this.m_addInvocations) {
            CreationDescription creationDescription = this.m_javaInfo.getDescription().getCreation(this.m_creationId);
            for (CreationInvocationDescription invocation : creationDescription.getInvocations()) {
                this.m_javaInfo.addMethodInvocation(invocation.getSignature(), invocation.getArguments());
            }
        }
    }

    @Override
    public Association getAssociation() throws Exception {
        if (this.add_getSource(null).indexOf("%parent%") != -1) {
            return new ConstructorParentAssociation();
        }
        return null;
    }

    @Override
    public boolean canDelete() {
        return true;
    }

    @Override
    public void delete() throws Exception {
        boolean removeFromParent = !this.m_javaInfo.isRoot();
        JavaInfoUtils.deleteJavaInfo(this.m_javaInfo, removeFromParent);
    }

    @Override
    public IClipboardCreationSupport getClipboard() throws Exception {
        final String source = this.getClipboardSource();
        return new IClipboardCreationSupport(){
            private static final long serialVersionUID = 0L;

            public CreationSupport create(JavaInfo rootObject) throws Exception {
                return ConstructorCreationSupport.forSource(source);
            }
        };
    }

    private String getClipboardSource() throws Exception {
        AstEditor editor = this.m_javaInfo.getEditor();
        String typeArgumentsSource = editor.getTypeArgumentsSource(this.m_creation);
        String argumentsSource = this.m_utils.getClipboardArguments(this.m_description.getParameters());
        String methodStubs = this.getClipboardSourceMethodStubs(editor);
        return "new " + this.m_javaInfo.getDescription().getComponentClass().getName() + typeArgumentsSource + "(" + argumentsSource + ")" + methodStubs;
    }

    private String getClipboardSourceMethodStubs(AstEditor editor) throws Exception {
        AnonymousClassDeclaration anonymousDeclaration = this.m_creation.getAnonymousClassDeclaration();
        if (anonymousDeclaration != null) {
            StringBuilder sb = new StringBuilder();
            sb.append(" {\n");
            List<MethodDeclaration> methodDeclarations = DomGenerics.methodDeclarations(anonymousDeclaration);
            for (MethodDeclaration methodDeclaration : methodDeclarations) {
                String stubSource = editor.getMethodStubSource(methodDeclaration);
                sb.append(stubSource);
                sb.append("\n");
            }
            sb.append("}");
            return sb.toString();
        }
        return "";
    }
}

