/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.creation.factory;

import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.model.clipboard.IClipboardCreationSupport;
import org.eclipse.wb.internal.core.model.creation.CreationSupport;
import org.eclipse.wb.internal.core.model.creation.factory.AbstractExplicitFactoryCreationSupport;
import org.eclipse.wb.internal.core.model.description.factory.FactoryMethodDescription;
import org.eclipse.wb.internal.core.model.description.helpers.FactoryDescriptionHelper;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.core.utils.ast.NodeTarget;
import org.eclipse.wb.internal.core.utils.state.EditorState;

public final class StaticFactoryCreationSupport
extends AbstractExplicitFactoryCreationSupport {
    public StaticFactoryCreationSupport(FactoryMethodDescription description) {
        super(description);
    }

    public StaticFactoryCreationSupport(FactoryMethodDescription description, MethodInvocation invocation) {
        super(description, invocation);
    }

    public String toString() {
        return "static factory: " + this.m_description.getDeclaringClass().getName() + " " + this.m_description.getSignature();
    }

    public CreationSupport getLiveComponentCreation() {
        FactoryMethodDescription factoryMethodDescription = this.getDescription();
        return new StaticFactoryCreationSupport(factoryMethodDescription);
    }

    protected String add_getSource_invocationExpression(NodeTarget target) throws Exception {
        if (this.isLocalFactoryMethod()) {
            return "";
        }
        return String.valueOf(this.m_description.getDeclaringClass().getName()) + ".";
    }

    private boolean isLocalFactoryMethod() {
        String editorTypeName = this.m_javaInfo.getEditor().getModelUnit().findPrimaryType().getFullyQualifiedName();
        String factoryTypeName = this.m_description.getDeclaringClass().getName();
        return editorTypeName.equals(factoryTypeName);
    }

    public IClipboardCreationSupport getClipboard() throws Exception {
        final String factoryClassName = this.m_description.getDeclaringClass().getName();
        final String methodSignature = this.m_description.getSignature();
        final String argumentsSource = this.getClipboardArguments();
        return new IClipboardCreationSupport(){
            private static final long serialVersionUID = 0L;

            public CreationSupport create(JavaInfo rootObject) throws Exception {
                AstEditor editor = rootObject.getEditor();
                Class<?> factoryClass = EditorState.get(editor).getEditorLoader().loadClass(factoryClassName);
                FactoryMethodDescription description = FactoryDescriptionHelper.getDescription(editor, factoryClass, methodSignature, true);
                StaticFactoryCreationSupport creationSupport = new StaticFactoryCreationSupport(description);
                creationSupport.m_addArguments = argumentsSource;
                return creationSupport;
            }
        };
    }
}

