/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.debug.core.model;

import org.eclipse.wst.jsdt.chromium.Script;
import org.eclipse.wst.jsdt.chromium.util.BasicUtil;

public class VmResourceId {
    private final String name;
    private final Object id;

    public static VmResourceId forScript(Script script) {
        return new VmResourceId(script.getName(), script.getId());
    }

    public VmResourceId(String name, Object id) {
        this.name = name;
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public Object getId() {
        return this.id;
    }

    public int hashCode() {
        return BasicUtil.hashCode((Object)this.getName()) + 31 * BasicUtil.hashCode((Object)this.getId());
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof VmResourceId)) {
            return false;
        }
        VmResourceId other = (VmResourceId)obj;
        return BasicUtil.eq((Object)this.name, (Object)other.name) && BasicUtil.eq((Object)this.id, (Object)other.id);
    }

    public String toString() {
        return "<" + this.name + " : " + this.id + ">";
    }

    public String getVisibleName() {
        String name = this.getName();
        if (name != null) {
            return name;
        }
        return "<unnamed # " + this.getId() + ">";
    }
}

