/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.lib;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.Inline;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.internal.BooleanFunctionDelegate;
import org.eclipse.xtext.xbase.lib.internal.FunctionDelegate;
import org.eclipse.xtext.xbase.lib.internal.KeyComparator;

@GwtCompatible
public class IteratorExtensions {
    @Pure
    public static <T> Iterable<T> toIterable(final Iterator<T> iterator) {
        if (iterator == null) {
            throw new NullPointerException("iterator");
        }
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return iterator;
            }
        };
    }

    @Pure
    @Inline(value="$3.$4concat($1, $2)", imported={Iterators.class})
    public static <T> Iterator<T> operator_plus(Iterator<? extends T> a, Iterator<? extends T> b) {
        return Iterators.concat(a, b);
    }

    public static <T> T findFirst(Iterator<T> iterator, Functions.Function1<? super T, Boolean> predicate) {
        if (predicate == null) {
            throw new NullPointerException("predicate");
        }
        while (iterator.hasNext()) {
            T t = iterator.next();
            if (!predicate.apply(t).booleanValue()) continue;
            return t;
        }
        return null;
    }

    public static <T> T findLast(Iterator<T> iterator, Functions.Function1<? super T, Boolean> predicate) {
        if (predicate == null) {
            throw new NullPointerException("predicate");
        }
        T result = null;
        while (iterator.hasNext()) {
            T t = iterator.next();
            if (!predicate.apply(t).booleanValue()) continue;
            result = t;
        }
        return result;
    }

    public static <T> T head(Iterator<T> iterator) {
        if (iterator.hasNext()) {
            return iterator.next();
        }
        return null;
    }

    public static <T> Iterator<T> tail(Iterator<T> iterator) {
        return IteratorExtensions.drop(iterator, 1);
    }

    public static <T> T last(Iterator<T> iterator) {
        T result = null;
        while (iterator.hasNext()) {
            result = iterator.next();
        }
        return result;
    }

    @Pure
    public static <T> Iterator<T> take(final Iterator<T> iterator, final int count) {
        if (iterator == null) {
            throw new NullPointerException("iterator");
        }
        if (count < 0) {
            throw new IllegalArgumentException("Cannot take a negative number of elements. Argument 'count' was: " + count);
        }
        if (count == 0) {
            return ImmutableSet.of().iterator();
        }
        return new AbstractIterator<T>(){
            private int remaining;
            {
                this.remaining = count;
            }

            protected T computeNext() {
                if (this.remaining <= 0) {
                    return this.endOfData();
                }
                if (!iterator.hasNext()) {
                    return this.endOfData();
                }
                --this.remaining;
                return iterator.next();
            }
        };
    }

    public static <T> Iterator<T> drop(final Iterator<T> iterator, final int count) {
        if (iterator == null) {
            throw new NullPointerException("iterator");
        }
        if (count == 0) {
            return iterator;
        }
        if (count < 0) {
            throw new IllegalArgumentException("Cannot drop a negative number of elements. Argument 'count' was: " + count);
        }
        return new AbstractIterator<T>(){
            {
                for (int i = count; i > 0 && iterator.hasNext(); --i) {
                    iterator.next();
                }
            }

            protected T computeNext() {
                if (!iterator.hasNext()) {
                    return this.endOfData();
                }
                return iterator.next();
            }
        };
    }

    public static <T> boolean exists(Iterator<T> iterator, Functions.Function1<? super T, Boolean> predicate) {
        if (predicate == null) {
            throw new NullPointerException("predicate");
        }
        while (iterator.hasNext()) {
            if (!predicate.apply(iterator.next()).booleanValue()) continue;
            return true;
        }
        return false;
    }

    public static <T> boolean forall(Iterator<T> iterator, Functions.Function1<? super T, Boolean> predicate) {
        if (predicate == null) {
            throw new NullPointerException("predicate");
        }
        while (iterator.hasNext()) {
            if (predicate.apply(iterator.next()).booleanValue()) continue;
            return false;
        }
        return true;
    }

    @Pure
    public static <T> Iterator<T> filter(Iterator<T> unfiltered, Functions.Function1<? super T, Boolean> predicate) {
        return Iterators.filter(unfiltered, new BooleanFunctionDelegate<T>(predicate));
    }

    @Pure
    public static <T> Iterator<T> reject(Iterator<T> unfiltered, Functions.Function1<? super T, Boolean> predicate) {
        return Iterators.filter(unfiltered, (Predicate)Predicates.not(new BooleanFunctionDelegate<T>(predicate)));
    }

    @Pure
    @Inline(value="$3.$4filter($1, $2)", imported={Iterators.class})
    @GwtIncompatible(value="Class.isInstance")
    public static <T> Iterator<T> filter(Iterator<?> unfiltered, Class<T> type) {
        return Iterators.filter(unfiltered, type);
    }

    @Pure
    public static <T> Iterator<T> filterNull(Iterator<T> unfiltered) {
        return Iterators.filter(unfiltered, (Predicate)Predicates.notNull());
    }

    @Pure
    public static <T, R> Iterator<R> map(Iterator<T> original, Functions.Function1<? super T, ? extends R> transformation) {
        return Iterators.transform(original, new FunctionDelegate<T, R>(transformation));
    }

    @Pure
    public static <T, R> Iterator<R> flatMap(Iterator<T> original, Functions.Function1<? super T, ? extends Iterator<R>> transformation) {
        return IteratorExtensions.flatten(IteratorExtensions.map(original, transformation));
    }

    @Inline(value="$2.$3concat($1)", imported={Iterators.class})
    public static <T> Iterator<T> flatten(Iterator<? extends Iterator<? extends T>> inputs) {
        return Iterators.concat(inputs);
    }

    public static <T> void forEach(Iterator<T> iterator, Procedures.Procedure1<? super T> procedure) {
        if (procedure == null) {
            throw new NullPointerException("procedure");
        }
        while (iterator.hasNext()) {
            procedure.apply(iterator.next());
        }
    }

    public static <T> void forEach(Iterator<T> iterator, Procedures.Procedure2<? super T, ? super Integer> procedure) {
        if (procedure == null) {
            throw new NullPointerException("procedure");
        }
        int i = 0;
        while (iterator.hasNext()) {
            procedure.apply(iterator.next(), i);
            if (i == Integer.MAX_VALUE) continue;
            ++i;
        }
    }

    public static String join(Iterator<?> iterator) {
        return IteratorExtensions.join(iterator, "");
    }

    public static String join(Iterator<?> iterator, CharSequence separator) {
        return Joiner.on((String)separator.toString()).useForNull("null").join(IteratorExtensions.toIterable(iterator));
    }

    public static <T> String join(Iterator<T> iterator, CharSequence separator, Functions.Function1<? super T, ? extends CharSequence> function) {
        if (separator == null) {
            throw new NullPointerException("separator");
        }
        if (function == null) {
            throw new NullPointerException("function");
        }
        StringBuilder result = new StringBuilder();
        while (iterator.hasNext()) {
            T next = iterator.next();
            CharSequence elementToString = function.apply(next);
            result.append(elementToString);
            if (!iterator.hasNext()) continue;
            result.append(separator);
        }
        return result.toString();
    }

    public static <T> String join(Iterator<T> iterator, CharSequence before, CharSequence separator, CharSequence after, Functions.Function1<? super T, ? extends CharSequence> function) {
        if (function == null) {
            throw new NullPointerException("function");
        }
        StringBuilder result = new StringBuilder();
        boolean notEmpty = iterator.hasNext();
        if (notEmpty && before != null) {
            result.append(before);
        }
        while (iterator.hasNext()) {
            T next = iterator.next();
            CharSequence elementToString = function.apply(next);
            result.append(elementToString);
            if (!iterator.hasNext() || separator == null) continue;
            result.append(separator);
        }
        if (notEmpty && after != null) {
            result.append(after);
        }
        return result.toString();
    }

    public static boolean elementsEqual(Iterator<?> iterator, Iterator<?> other) {
        return Iterators.elementsEqual(iterator, other);
    }

    public static boolean elementsEqual(Iterator<?> iterator, Iterable<?> iterable) {
        return Iterators.elementsEqual(iterator, iterable.iterator());
    }

    public static boolean isNullOrEmpty(Iterator<?> iterator) {
        return iterator == null || IteratorExtensions.isEmpty(iterator);
    }

    public static boolean isEmpty(Iterator<?> iterator) {
        return !iterator.hasNext();
    }

    public static int size(Iterator<?> iterator) {
        return Iterators.size(iterator);
    }

    public static <T> T reduce(Iterator<? extends T> iterator, Functions.Function2<? super T, ? super T, ? extends T> function) {
        if (function == null) {
            throw new NullPointerException("function");
        }
        if (iterator.hasNext()) {
            T result = iterator.next();
            while (iterator.hasNext()) {
                result = function.apply(result, iterator.next());
            }
            return result;
        }
        return null;
    }

    public static <T, R> R fold(Iterator<T> iterator, R seed, Functions.Function2<? super R, ? super T, ? extends R> function) {
        R result = seed;
        while (iterator.hasNext()) {
            result = function.apply(result, iterator.next());
        }
        return result;
    }

    public static <T> List<T> toList(Iterator<? extends T> iterator) {
        return Lists.newArrayList(iterator);
    }

    public static <T> Set<T> toSet(Iterator<? extends T> iterator) {
        return Sets.newLinkedHashSet(IteratorExtensions.toIterable(iterator));
    }

    public static <K, V> Map<K, V> toInvertedMap(Iterator<? extends K> keys, Functions.Function1<? super K, V> computeValues) {
        LinkedHashMap result = Maps.newLinkedHashMap();
        while (keys.hasNext()) {
            K k = keys.next();
            result.put(k, computeValues.apply(k));
        }
        return result;
    }

    public static <K, V> Map<K, V> toMap(Iterator<? extends V> values, Functions.Function1<? super V, K> computeKeys) {
        if (computeKeys == null) {
            throw new NullPointerException("computeKeys");
        }
        LinkedHashMap result = Maps.newLinkedHashMap();
        while (values.hasNext()) {
            V v = values.next();
            result.put(computeKeys.apply(v), v);
        }
        return result;
    }

    public static <T, K, V> Map<K, V> toMap(Iterator<? extends T> inputs, Functions.Function1<? super T, K> computeKeys, Functions.Function1<? super T, V> computeValues) {
        if (computeKeys == null) {
            throw new NullPointerException("computeKeys");
        }
        if (computeValues == null) {
            throw new NullPointerException("computeValues");
        }
        LinkedHashMap result = Maps.newLinkedHashMap();
        while (inputs.hasNext()) {
            T t = inputs.next();
            result.put(computeKeys.apply(t), computeValues.apply(t));
        }
        return result;
    }

    public static <K, V> Map<K, List<V>> groupBy(Iterator<? extends V> values, Functions.Function1<? super V, ? extends K> computeKeys) {
        if (computeKeys == null) {
            throw new NullPointerException("computeKeys");
        }
        LinkedHashMap result = Maps.newLinkedHashMap();
        while (values.hasNext()) {
            V v = values.next();
            K key = computeKeys.apply(v);
            ArrayList<V> grouped = (ArrayList<V>)result.get(key);
            if (grouped == null) {
                grouped = new ArrayList<V>();
                result.put(key, grouped);
            }
            grouped.add(v);
        }
        return result;
    }

    public static <T> Iterator<T> takeWhile(final Iterator<? extends T> iterator, final Functions.Function1<? super T, Boolean> predicate) {
        if (iterator == null) {
            throw new NullPointerException("iterator");
        }
        if (predicate == null) {
            throw new NullPointerException("predicate");
        }
        return new AbstractIterator<T>(){

            protected T computeNext() {
                if (!iterator.hasNext()) {
                    return this.endOfData();
                }
                Object next = iterator.next();
                if (((Boolean)predicate.apply(next)).booleanValue()) {
                    return next;
                }
                return this.endOfData();
            }
        };
    }

    public static <T> Iterator<T> dropWhile(final Iterator<? extends T> iterator, final Functions.Function1<? super T, Boolean> predicate) {
        if (iterator == null) {
            throw new NullPointerException("iterator");
        }
        if (predicate == null) {
            throw new NullPointerException("predicate");
        }
        return new AbstractIterator<T>(){
            private boolean headFound = false;

            protected T computeNext() {
                while (!this.headFound) {
                    if (!iterator.hasNext()) {
                        return this.endOfData();
                    }
                    Object next = iterator.next();
                    if (((Boolean)predicate.apply(next)).booleanValue()) continue;
                    this.headFound = true;
                    return next;
                }
                if (iterator.hasNext()) {
                    return iterator.next();
                }
                return this.endOfData();
            }
        };
    }

    public static <A> Iterator<Pair<Integer, A>> indexed(final Iterator<? extends A> iterator) {
        if (iterator == null) {
            throw new NullPointerException("iterator");
        }
        return new AbstractIterator<Pair<Integer, A>>(){
            int i = 0;

            protected Pair<Integer, A> computeNext() {
                if (iterator.hasNext()) {
                    Pair next = new Pair(this.i, iterator.next());
                    if (this.i != Integer.MAX_VALUE) {
                        ++this.i;
                    }
                    return next;
                }
                return (Pair)this.endOfData();
            }
        };
    }

    public static <T extends Comparable<? super T>> T min(Iterator<T> iterator) {
        return (T)((Comparable)IteratorExtensions.min(iterator, Ordering.natural()));
    }

    public static <T, C extends Comparable<? super C>> T minBy(Iterator<T> iterator, Functions.Function1<? super T, C> compareBy) {
        if (compareBy == null) {
            throw new NullPointerException("compareBy");
        }
        return IteratorExtensions.min(iterator, new KeyComparator<T, C>(compareBy));
    }

    public static <T> T min(Iterator<T> iterator, Comparator<? super T> comparator) {
        if (comparator == null) {
            throw new NullPointerException("comparator");
        }
        T min = iterator.next();
        while (iterator.hasNext()) {
            T element = iterator.next();
            min = comparator.compare(min, element) <= 0 ? min : element;
        }
        return min;
    }

    public static <T extends Comparable<? super T>> T max(Iterator<T> iterator) {
        return (T)((Comparable)IteratorExtensions.max(iterator, Ordering.natural()));
    }

    public static <T, C extends Comparable<? super C>> T maxBy(Iterator<T> iterator, Functions.Function1<? super T, C> compareBy) {
        if (compareBy == null) {
            throw new NullPointerException("compareBy");
        }
        return IteratorExtensions.max(iterator, new KeyComparator<T, C>(compareBy));
    }

    public static <T> T max(Iterator<T> iterator, Comparator<? super T> comparator) {
        if (comparator == null) {
            throw new NullPointerException("comparator");
        }
        T max = iterator.next();
        while (iterator.hasNext()) {
            T element = iterator.next();
            max = comparator.compare(max, element) >= 0 ? max : element;
        }
        return max;
    }
}

