/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.pde;

import java.lang.reflect.Array;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.xwt.ILogger;
import org.eclipse.xwt.IMetaclassFactory;
import org.eclipse.xwt.IStyle;
import org.eclipse.xwt.XWT;
import org.eclipse.xwt.input.ICommand;
import org.eclipse.xwt.javabean.metadata.properties.DynamicProperty;
import org.eclipse.xwt.metadata.IMetaclass;
import org.eclipse.xwt.metadata.IProperty;
import org.eclipse.xwt.metadata.ISetPostAction;
import org.eclipse.xwt.pde.PDEPlugin;

public class ExtensionService {
    public static final String METACLASS_REGISTER_ID = "org.eclipse.xwt.pde.metaclasses";
    public static final String CONVERTER_REGISTER_ID = "org.eclipse.xwt.pde.converters";
    public static final String LOGGER_REGISTER_ID = "org.eclipse.xwt.pde.logger";
    public static final String COMMANDS_REGISTER_ID = "org.eclipse.xwt.pde.commands";
    public static final String METACLASS_FACTORY_ID = "org.eclipse.xwt.pde.metaclassFactories";
    public static final String STYLES_REGISTER_ID = "org.eclipse.xwt.pde.styles";
    static final String METACLASS = "metaclass";
    static final String TYPE = "type";
    static final String CLASS = "class";
    static final String PROPERTY = "property";
    static final String EVENT = "event";
    static final String NAME = "name";
    static final String AMOUNT = "amount";
    static final String SINGLE = "single";
    static final String ARRAY = "array";
    static final String SETPOSTACTION = "SetPostAction";
    static final String OVERWRITE = "overwrite";
    static final String COMMAND = "command";
    static final String STYLE = "style";
    static final String TRUE = "true";
    static final String CONVERTERS = "converters";
    static final String CONVERTER = "converter";
    static final String METACLASSFACTORY = "metaclassFactory";
    static final String DYNAMIC_PROPERTY = "DynamicProperty";
    static final String TABLEITEM_PROPERTY = "TableItemProperty";
    static final String DATACONTEXT_PROPERTY = "DataContextProperty";
    static final String EXISTING_PROPERTY = "ExistingProperty";
    static final String TableItem = "org.eclipse.swt.widgets.TableItem";
    static final String Cells = "Cells";

    public static void initialize() {
        IConfigurationElement[] stylesConfigurationElements;
        IConfigurationElement[] commandsConfigurationElements;
        IExtensionPoint ep;
        IExtension[] extensions;
        IConfigurationElement[] converterConfigurationElements;
        IConfigurationElement[] iConfigurationElementArray = converterConfigurationElements = Platform.getExtensionRegistry().getConfigurationElementsFor(CONVERTER_REGISTER_ID);
        int n = converterConfigurationElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] metaclassConfigurationElements;
            IConfigurationElement converterConfigurationElement = iConfigurationElementArray[n2];
            if (CONVERTER.equals(converterConfigurationElement.getName())) {
                try {
                    IConverter newInstance = (IConverter)converterConfigurationElement.createExecutableExtension(CLASS);
                    XWT.registerConvertor((IConverter)newInstance);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    PDEPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.xwt.pde", "Converter registration error", (Throwable)e));
                }
            }
            IConfigurationElement[] iConfigurationElementArray2 = metaclassConfigurationElements = Platform.getExtensionRegistry().getConfigurationElementsFor(METACLASS_REGISTER_ID);
            int n3 = metaclassConfigurationElements.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement configurationElement = iConfigurationElementArray2[n4];
                if (METACLASS.equals(configurationElement.getName())) {
                    String componentName = configurationElement.getAttribute(TYPE);
                    try {
                        Class<?> newClass = Class.forName(componentName);
                        IMetaclass newMetaclass = XWT.registerMetaclass(newClass);
                        IConfigurationElement[] children = configurationElement.getChildren();
                        if (children != null) {
                            IConfigurationElement[] iConfigurationElementArray3 = children;
                            int n5 = children.length;
                            int n6 = 0;
                            while (n6 < n5) {
                                IConfigurationElement configurationElementChildern = iConfigurationElementArray3[n6];
                                if (PROPERTY.equals(configurationElementChildern.getName())) {
                                    IConfigurationElement[] propertyChildren;
                                    String propertyName = configurationElementChildern.getAttribute(NAME);
                                    String className = configurationElementChildern.getAttribute(CLASS);
                                    String typeName = configurationElementChildern.getAttribute(TYPE);
                                    String propertyAmount = configurationElementChildern.getAttribute(AMOUNT);
                                    String overwrite = configurationElementChildern.getAttribute(OVERWRITE);
                                    IProperty property = newMetaclass.findProperty(propertyName);
                                    if (property == null || overwrite.equals(TRUE)) {
                                        if (className != null) {
                                            property = (IProperty)configurationElementChildern.createExecutableExtension(CLASS);
                                            newMetaclass.addProperty(property);
                                        } else if (typeName != null) {
                                            if (SINGLE.equals(propertyAmount)) {
                                                property = new DynamicProperty(newClass, Class.forName(typeName), propertyName);
                                            } else {
                                                Object newInstance = Array.newInstance(Class.forName(typeName), 1);
                                                property = new DynamicProperty(newClass, newInstance.getClass(), propertyName);
                                            }
                                        }
                                        if (property != null) {
                                            newMetaclass.addProperty(property);
                                        }
                                    }
                                    if ((propertyChildren = configurationElementChildern.getChildren()) != null) {
                                        IConfigurationElement[] iConfigurationElementArray4 = propertyChildren;
                                        int n7 = propertyChildren.length;
                                        int n8 = 0;
                                        while (n8 < n7) {
                                            IConfigurationElement propertyConfigurationElement = iConfigurationElementArray4[n8];
                                            if (SETPOSTACTION.equals(propertyConfigurationElement)) {
                                                String setPostActionName = propertyConfigurationElement.getAttribute(SETPOSTACTION);
                                                property.addSetPostAction((ISetPostAction)Class.forName(setPostActionName).newInstance());
                                            }
                                            ++n8;
                                        }
                                    }
                                } else {
                                    EVENT.equals(configurationElementChildern.getName());
                                }
                                ++n6;
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        PDEPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.xwt.pde", "Type registration error", (Throwable)e));
                    }
                }
                ++n4;
            }
            ++n2;
        }
        IExtensionRegistry regs = Platform.getExtensionRegistry();
        if (regs != null && (extensions = (ep = regs.getExtensionPoint(LOGGER_REGISTER_ID)).getExtensions()).length > 0) {
            IExtension extension = extensions[0];
            IConfigurationElement ce = extension.getConfigurationElements()[0];
            try {
                Object object = ce.createExecutableExtension(CLASS);
                if (object != null) {
                    XWT.setLogger((ILogger)((ILogger)object));
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        IConfigurationElement[] iConfigurationElementArray5 = commandsConfigurationElements = Platform.getExtensionRegistry().getConfigurationElementsFor(COMMANDS_REGISTER_ID);
        int n9 = commandsConfigurationElements.length;
        int extension = 0;
        while (extension < n9) {
            IConfigurationElement commandConfigurationElement = iConfigurationElementArray5[extension];
            if (COMMAND.equals(commandConfigurationElement.getName())) {
                String commandName = commandConfigurationElement.getAttribute(NAME);
                try {
                    ICommand newInstance = (ICommand)commandConfigurationElement.createExecutableExtension(CLASS);
                    XWT.registerCommand((String)commandName, (ICommand)newInstance);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    PDEPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.xwt.pde", "Converter registration error", (Throwable)e));
                }
            }
            ++extension;
        }
        IConfigurationElement[] iConfigurationElementArray6 = stylesConfigurationElements = Platform.getExtensionRegistry().getConfigurationElementsFor(STYLES_REGISTER_ID);
        int n10 = stylesConfigurationElements.length;
        n9 = 0;
        while (n9 < n10) {
            IConfigurationElement styleConfigurationElement = iConfigurationElementArray6[n9];
            if (STYLE.equals(styleConfigurationElement.getName())) {
                try {
                    IStyle newInstance = (IStyle)styleConfigurationElement.createExecutableExtension(CLASS);
                    XWT.addDefaultStyle((IStyle)newInstance);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    PDEPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.xwt.pde", "Converter registration error", (Throwable)e));
                }
            }
            ++n9;
        }
    }

    public static IMetaclassFactory getMetaclassFactory(Class<?> type) {
        IConfigurationElement[] metaclassFactoryElements;
        IConfigurationElement[] iConfigurationElementArray = metaclassFactoryElements = Platform.getExtensionRegistry().getConfigurationElementsFor(METACLASS_FACTORY_ID);
        int n = metaclassFactoryElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement metaclassFactoryElement = iConfigurationElementArray[n2];
            if (METACLASSFACTORY.equals(metaclassFactoryElement.getName())) {
                String metaclassFactoryName = metaclassFactoryElement.getAttribute(NAME);
                try {
                    IMetaclassFactory newInstance = (IMetaclassFactory)metaclassFactoryElement.createExecutableExtension(METACLASS);
                    if (newInstance != null) {
                        return newInstance;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    PDEPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.xwt.pde", "get metaclassFactory here", (Throwable)e));
                }
            }
            ++n2;
        }
        return null;
    }
}

