/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.common.data;

import com.google.gerrit.common.data.CommentDetail;
import com.google.gerrit.prettify.client.ClientSideFormatter;
import com.google.gerrit.prettify.common.EditList;
import com.google.gerrit.prettify.common.PrettyFormatter;
import com.google.gerrit.prettify.common.SparseFileContent;
import com.google.gerrit.prettify.common.SparseHtmlFile;
import com.google.gerrit.reviewdb.AccountDiffPreference;
import com.google.gerrit.reviewdb.Change;
import com.google.gerrit.reviewdb.Patch;
import java.util.List;
import org.eclipse.jgit.diff.Edit;

public class PatchScript {
    protected Change.Key changeId;
    protected Patch.ChangeType changeType;
    protected String oldName;
    protected String newName;
    protected List<String> header;
    protected AccountDiffPreference diffPrefs;
    protected SparseFileContent a;
    protected SparseFileContent b;
    protected List<Edit> edits;
    protected DisplayMethod displayMethodA;
    protected DisplayMethod displayMethodB;
    protected CommentDetail comments;
    protected List<Patch> history;
    protected boolean hugeFile;
    protected boolean intralineDifference;

    public PatchScript(Change.Key ck, Patch.ChangeType ct, String on, String nn, List<String> h, AccountDiffPreference dp, SparseFileContent ca, SparseFileContent cb, List<Edit> e, DisplayMethod ma, DisplayMethod mb, CommentDetail cd, List<Patch> hist, boolean hf, boolean id) {
        this.changeId = ck;
        this.changeType = ct;
        this.oldName = on;
        this.newName = nn;
        this.header = h;
        this.diffPrefs = dp;
        this.a = ca;
        this.b = cb;
        this.edits = e;
        this.displayMethodA = ma;
        this.displayMethodB = mb;
        this.comments = cd;
        this.history = hist;
        this.hugeFile = hf;
        this.intralineDifference = id;
    }

    protected PatchScript() {
    }

    public Change.Key getChangeId() {
        return this.changeId;
    }

    public DisplayMethod getDisplayMethodA() {
        return this.displayMethodA;
    }

    public DisplayMethod getDisplayMethodB() {
        return this.displayMethodB;
    }

    public List<String> getPatchHeader() {
        return this.header;
    }

    public Patch.ChangeType getChangeType() {
        return this.changeType;
    }

    public String getOldName() {
        return this.oldName;
    }

    public String getNewName() {
        return this.newName;
    }

    public CommentDetail getCommentDetail() {
        return this.comments;
    }

    public List<Patch> getHistory() {
        return this.history;
    }

    public AccountDiffPreference getDiffPrefs() {
        return this.diffPrefs;
    }

    public void setDiffPrefs(AccountDiffPreference dp) {
        this.diffPrefs = dp;
    }

    public boolean isHugeFile() {
        return this.hugeFile;
    }

    public boolean isIgnoreWhitespace() {
        return this.diffPrefs.getIgnoreWhitespace() != AccountDiffPreference.Whitespace.IGNORE_NONE;
    }

    public boolean hasIntralineDifference() {
        return this.intralineDifference;
    }

    public SparseFileContent getA() {
        return this.a;
    }

    public SparseFileContent getB() {
        return this.b;
    }

    public SparseHtmlFile getSparseHtmlFileA() {
        AccountDiffPreference dp = new AccountDiffPreference(this.diffPrefs);
        dp.setShowWhitespaceErrors(false);
        PrettyFormatter f = ClientSideFormatter.FACTORY.get();
        f.setDiffPrefs(dp);
        f.setFileName(this.a.getPath());
        f.setEditFilter(PrettyFormatter.A);
        f.setEditList(this.edits);
        f.format(this.a);
        return f;
    }

    public SparseHtmlFile getSparseHtmlFileB() {
        AccountDiffPreference dp = new AccountDiffPreference(this.diffPrefs);
        PrettyFormatter f = ClientSideFormatter.FACTORY.get();
        f.setDiffPrefs(dp);
        f.setFileName(this.b.getPath());
        f.setEditFilter(PrettyFormatter.B);
        f.setEditList(this.edits);
        if (dp.isSyntaxHighlighting() && this.a.isWholeFile() && !this.b.isWholeFile()) {
            f.format(this.b.apply(this.a, this.edits));
        } else {
            f.format(this.b);
        }
        return f;
    }

    public List<Edit> getEdits() {
        return this.edits;
    }

    public Iterable<EditList.Hunk> getHunks() {
        int ctx = this.diffPrefs.getContext();
        if (ctx == -1) {
            ctx = Math.max(this.a.size(), this.b.size());
        }
        return new EditList(this.edits, ctx, this.a.size(), this.b.size()).getHunks();
    }

    public static enum DisplayMethod {
        NONE,
        DIFF,
        IMG;

    }
}

