/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwtjsonrpc.client.impl;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.http.client.Request;
import com.google.gwt.http.client.RequestBuilder;
import com.google.gwt.http.client.RequestCallback;
import com.google.gwt.http.client.RequestException;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwtjsonrpc.client.ServerUnavailableException;
import com.google.gwtjsonrpc.client.event.RpcCompleteEvent;
import com.google.gwtjsonrpc.client.event.RpcStartEvent;
import com.google.gwtjsonrpc.client.impl.AbstractJsonProxy;
import com.google.gwtjsonrpc.client.impl.ResultDeserializer;

public abstract class JsonCall<T>
implements RequestCallback {
    protected static final JavaScriptObject jsonParser = JsonCall.selectJsonParser();
    protected final AbstractJsonProxy proxy;
    protected final String methodName;
    protected final String requestParams;
    protected final ResultDeserializer<T> resultDeserializer;
    protected final AsyncCallback<T> callback;
    protected int attempts;

    private static native JavaScriptObject selectJsonParser();

    protected JsonCall(AbstractJsonProxy abstractJsonProxy, String methodName, String requestParams, ResultDeserializer<T> resultDeserializer, AsyncCallback<T> callback) {
        this.proxy = abstractJsonProxy;
        this.methodName = methodName;
        this.requestParams = requestParams;
        this.resultDeserializer = resultDeserializer;
        this.callback = callback;
    }

    public AbstractJsonProxy getProxy() {
        return this.proxy;
    }

    public String getMethodName() {
        return this.methodName;
    }

    protected abstract void send();

    protected void send(RequestBuilder rb) {
        try {
            ++this.attempts;
            rb.send();
        }
        catch (RequestException e) {
            this.callback.onFailure((Throwable)e);
            return;
        }
        if (this.attempts == 1) {
            RpcStartEvent.fire(this);
        }
    }

    public void onError(Request request, Throwable exception) {
        RpcCompleteEvent.fire(this);
        if (exception.getClass() == RuntimeException.class && exception.getMessage().contains("XmlHttpRequest.status")) {
            this.callback.onFailure((Throwable)new ServerUnavailableException());
        } else {
            this.callback.onFailure(exception);
        }
    }
}

