/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.subsystem.sftp.fs;

import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Path;
import java.util.Iterator;
import org.apache.sshd.client.subsystem.sftp.SftpClient;
import org.apache.sshd.client.subsystem.sftp.fs.SftpFileSystem;
import org.apache.sshd.client.subsystem.sftp.fs.SftpPath;
import org.apache.sshd.client.subsystem.sftp.fs.SftpPathIterator;

public class SftpDirectoryStream
implements DirectoryStream<Path> {
    private final SftpClient sftp;
    private final Iterable<SftpClient.DirEntry> iter;
    private final SftpPath p;

    public SftpDirectoryStream(SftpPath path) throws IOException {
        SftpFileSystem fs = (SftpFileSystem)path.getFileSystem();
        this.p = path;
        this.sftp = fs.getClient();
        this.iter = this.sftp.readDir(path.toString());
    }

    public final SftpClient getClient() {
        return this.sftp;
    }

    @Override
    public Iterator<Path> iterator() {
        return new SftpPathIterator(this.p, this.iter);
    }

    @Override
    public void close() throws IOException {
        this.sftp.close();
    }
}

