/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.item.crosstab.core.re;

import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.engine.api.script.IReportContext;
import org.eclipse.birt.report.engine.content.ICellContent;
import org.eclipse.birt.report.engine.extension.IOnCreateEvent;
import org.eclipse.birt.report.engine.extension.IOnRenderEvent;
import org.eclipse.birt.report.engine.extension.ReportEventHandlerBase;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabCellHandle;
import org.eclipse.birt.report.item.crosstab.core.script.internal.handler.CrosstabCreationHandler;
import org.eclipse.birt.report.item.crosstab.core.script.internal.handler.CrosstabHandlerCache;
import org.eclipse.birt.report.item.crosstab.core.script.internal.handler.CrosstabRenderingHandler;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;

public class CrosstabCellReportEventHandler
extends ReportEventHandlerBase {
    private CrosstabHandlerCache handlerCache;

    CrosstabCellReportEventHandler(CrosstabHandlerCache handlerCache) {
        this.handlerCache = handlerCache;
    }

    public void onCreate(IOnCreateEvent event) throws BirtException {
        DesignElementHandle modelHandle = event.getHandle();
        if (!(modelHandle instanceof ExtendedItemHandle)) {
            return;
        }
        String script = this.handlerCache.getOnCreateScript(modelHandle);
        if (script == null || script.length() == 0) {
            return;
        }
        CrosstabCreationHandler handler = this.handlerCache.getCreateHandler(modelHandle, event.getContext().getApplicationClassLoader());
        handler.handleCell((CrosstabCellHandle)((ExtendedItemHandle)modelHandle).getReportItem(), (ICellContent)event.getContent(), (IReportContext)event.getContext());
    }

    public void onRender(IOnRenderEvent event) throws BirtException {
        DesignElementHandle modelHandle = event.getHandle();
        if (!(modelHandle instanceof ExtendedItemHandle)) {
            return;
        }
        String script = this.handlerCache.getOnRenderScript(modelHandle);
        if (script == null || script.length() == 0) {
            return;
        }
        CrosstabRenderingHandler handler = this.handlerCache.getRenderHandler(modelHandle, event.getContext().getApplicationClassLoader());
        handler.handleCell((CrosstabCellHandle)((ExtendedItemHandle)modelHandle).getReportItem(), (ICellContent)event.getContent(), (IReportContext)event.getContext());
    }
}

