/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.codan.core.cxx.internal.model.cfg;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import org.eclipse.cdt.codan.core.cxx.Activator;
import org.eclipse.cdt.codan.core.cxx.internal.model.cfg.CxxControlFlowGraph;
import org.eclipse.cdt.codan.core.cxx.internal.model.cfg.CxxDecisionNode;
import org.eclipse.cdt.codan.core.cxx.internal.model.cfg.CxxExitNode;
import org.eclipse.cdt.codan.core.cxx.internal.model.cfg.CxxNodeFactory;
import org.eclipse.cdt.codan.core.cxx.internal.model.cfg.CxxPlainNode;
import org.eclipse.cdt.codan.core.cxx.internal.model.cfg.CxxStartNode;
import org.eclipse.cdt.codan.core.cxx.internal.model.cfg.Messages;
import org.eclipse.cdt.codan.core.model.cfg.IBasicBlock;
import org.eclipse.cdt.codan.core.model.cfg.IBranchNode;
import org.eclipse.cdt.codan.core.model.cfg.ICfgData;
import org.eclipse.cdt.codan.core.model.cfg.IConnectorNode;
import org.eclipse.cdt.codan.core.model.cfg.IDecisionNode;
import org.eclipse.cdt.codan.core.model.cfg.IExitNode;
import org.eclipse.cdt.codan.core.model.cfg.IJumpNode;
import org.eclipse.cdt.codan.core.model.cfg.IPlainNode;
import org.eclipse.cdt.codan.core.model.cfg.ISingleOutgoing;
import org.eclipse.cdt.codan.core.model.cfg.IStartNode;
import org.eclipse.cdt.codan.internal.core.cfg.AbstractBasicBlock;
import org.eclipse.cdt.codan.internal.core.cfg.ConnectorNode;
import org.eclipse.cdt.codan.internal.core.cfg.JumpNode;
import org.eclipse.cdt.core.dom.ast.IASTBreakStatement;
import org.eclipse.cdt.core.dom.ast.IASTCaseStatement;
import org.eclipse.cdt.core.dom.ast.IASTCompoundStatement;
import org.eclipse.cdt.core.dom.ast.IASTContinueStatement;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarationStatement;
import org.eclipse.cdt.core.dom.ast.IASTDefaultStatement;
import org.eclipse.cdt.core.dom.ast.IASTDoStatement;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTExpressionStatement;
import org.eclipse.cdt.core.dom.ast.IASTForStatement;
import org.eclipse.cdt.core.dom.ast.IASTFunctionCallExpression;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTGotoStatement;
import org.eclipse.cdt.core.dom.ast.IASTIdExpression;
import org.eclipse.cdt.core.dom.ast.IASTIfStatement;
import org.eclipse.cdt.core.dom.ast.IASTLabelStatement;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTNullStatement;
import org.eclipse.cdt.core.dom.ast.IASTProblemStatement;
import org.eclipse.cdt.core.dom.ast.IASTReturnStatement;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.cdt.core.dom.ast.IASTSwitchStatement;
import org.eclipse.cdt.core.dom.ast.IASTUnaryExpression;
import org.eclipse.cdt.core.dom.ast.IASTWhileStatement;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IFunction;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTCatchHandler;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTRangeBasedForStatement;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTryBlockStatement;
import org.eclipse.cdt.internal.core.dom.parser.ValueFactory;
import org.eclipse.osgi.util.NLS;

public class ControlFlowGraphBuilder {
    CxxStartNode start;
    Collection<IExitNode> exits;
    Collection<IBasicBlock> dead;
    CxxExitNode returnExit;
    CxxNodeFactory factory = new CxxNodeFactory();
    IConnectorNode outerBreak;
    IConnectorNode outerContinue;
    Map<String, IBranchNode> labels = new LinkedHashMap<String, IBranchNode>();

    public CxxControlFlowGraph build(IASTFunctionDefinition def) {
        IASTStatement body = def.getBody();
        this.start = new CxxStartNode();
        this.exits = new ArrayList<IExitNode>();
        this.dead = new LinkedHashSet<IBasicBlock>();
        IBasicBlock last = this.createSubGraph((IBasicBlock)this.start, body);
        for (IBranchNode label : this.labels.values()) {
            IConnectorNode conn = (IConnectorNode)label.getOutgoing();
            if (conn.getIncomingSize() <= 1 && label.getIncoming() == null) {
                this.dead.add((IBasicBlock)label);
                continue;
            }
            this.dead.remove(label);
            this.dead.remove(conn);
        }
        if (!(last instanceof IExitNode || last instanceof IJumpNode || this.deadConnector(last))) {
            this.returnExit = this.factory.createExitNode(null);
            this.returnExit.setStartNode((IStartNode)this.start);
            this.addOutgoing(last, (IBasicBlock)this.returnExit);
            this.exits.add(this.returnExit);
            for (IBasicBlock ds : this.dead) {
                IBasicBlock dl = this.findLast(ds);
                if (dl == null || dl instanceof IExitNode || dl.getOutgoingSize() != 0 || dl == this.returnExit) continue;
                ((AbstractBasicBlock)dl).addOutgoing((IBasicBlock)this.returnExit);
            }
        }
        CxxControlFlowGraph graph = new CxxControlFlowGraph((IStartNode)this.start, this.exits);
        graph.setUnconnectedNodes(this.dead);
        return graph;
    }

    private boolean deadConnector(IBasicBlock conn) {
        if (conn instanceof IJumpNode || conn instanceof IConnectorNode) {
            IJumpNode jm;
            if (conn.getIncomingSize() == 0) {
                return true;
            }
            if (conn instanceof IJumpNode && (jm = (IJumpNode)conn).isBackwardArc()) {
                return false;
            }
            IBasicBlock[] conns = conn.getIncomingNodes();
            int i = 0;
            while (i < conns.length) {
                IBasicBlock bb = conns[i];
                if (!this.deadConnector(bb)) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    private IBasicBlock findLast(IBasicBlock node) {
        if (node instanceof IJumpNode) {
            return null;
        }
        if (node.getOutgoingSize() == 0) {
            return node;
        }
        if (node instanceof ISingleOutgoing) {
            return this.findLast(((ISingleOutgoing)node).getOutgoing());
        }
        if (node instanceof IDecisionNode) {
            return this.findLast(((IDecisionNode)node).getMergeNode().getOutgoing());
        }
        return node;
    }

    private IBasicBlock createSubGraph(IBasicBlock prev, IASTStatement body) {
        if (body instanceof IASTCompoundStatement) {
            IASTCompoundStatement comp = (IASTCompoundStatement)body;
            IASTStatement[] iASTStatementArray = comp.getStatements();
            int n = iASTStatementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IASTStatement statement = iASTStatementArray[n2];
                prev = this.createSubGraph(prev, statement);
                ++n2;
            }
        } else {
            if (body instanceof IASTExpressionStatement || body instanceof IASTDeclarationStatement || body instanceof IASTNullStatement) {
                if (this.isThrowStatement((IASTNode)body) || this.isExitStatement((IASTNode)body)) {
                    CxxExitNode node = this.createExitNode(prev, (IASTNode)body);
                    return node;
                }
                CxxPlainNode node = this.factory.createPlainNode((IASTNode)body);
                this.addOutgoing(prev, (IBasicBlock)node);
                return node;
            }
            if (body instanceof IASTIfStatement) {
                return this.createIf(prev, (IASTIfStatement)body);
            }
            if (body instanceof IASTWhileStatement) {
                return this.createWhile(prev, (IASTWhileStatement)body);
            }
            if (body instanceof IASTForStatement) {
                return this.createFor(prev, (IASTForStatement)body);
            }
            if (body instanceof ICPPASTRangeBasedForStatement) {
                return this.createRangeBasedFor(prev, (ICPPASTRangeBasedForStatement)body);
            }
            if (body instanceof IASTDoStatement) {
                return this.createDoWhile(prev, (IASTDoStatement)body);
            }
            if (body instanceof IASTReturnStatement) {
                CxxExitNode node = this.createExitNode(prev, (IASTNode)body);
                return node;
            }
            if (body instanceof IASTBreakStatement) {
                if (this.outerBreak != null) {
                    return this.addJump(prev, this.outerBreak);
                }
                return prev;
            }
            if (body instanceof IASTContinueStatement) {
                if (this.outerContinue != null) {
                    return this.addJump(prev, this.outerContinue);
                }
                return prev;
            }
            if (body instanceof IASTSwitchStatement) {
                return this.createSwitch(prev, (IASTSwitchStatement)body);
            }
            if (body instanceof IASTLabelStatement) {
                IConnectorNode conn;
                IASTLabelStatement ast = (IASTLabelStatement)body;
                String labelName = ast.getName().toString();
                IBranchNode labNode = this.labels.get(labelName);
                if (labNode != null) {
                    conn = (IConnectorNode)labNode.getOutgoing();
                    this.addOutgoing(prev, (IBasicBlock)labNode);
                } else {
                    conn = this.createLabelNodes(prev, labelName);
                }
                return this.createSubGraph((IBasicBlock)conn, ast.getNestedStatement());
            }
            if (body instanceof IASTGotoStatement) {
                IASTGotoStatement ast = (IASTGotoStatement)body;
                String labelName = ast.getName().toString();
                IBranchNode labNode = this.labels.get(labelName);
                IConnectorNode conn = labNode != null ? (IConnectorNode)labNode.getOutgoing() : this.createLabelNodes(null, labelName);
                IJumpNode gotoNode = this.factory.createJumpNode();
                boolean backward = labNode != null;
                ((JumpNode)gotoNode).setJump(conn, backward);
                ((ConnectorNode)conn).addIncoming((IBasicBlock)gotoNode);
                this.addOutgoing(prev, (IBasicBlock)gotoNode);
                return gotoNode;
            }
            if (body instanceof IASTProblemStatement) {
                CxxPlainNode node = this.factory.createPlainNode((IASTNode)body);
                this.addOutgoing(prev, (IBasicBlock)node);
                return node;
            }
            if (body != null) {
                if (body instanceof ICPPASTTryBlockStatement) {
                    return this.createTry(prev, (ICPPASTTryBlockStatement)body);
                }
                Activator.log(NLS.bind((String)Messages.ControlFlowGraphBuilder_unsupported_statement_type, (Object)body.getClass().getSimpleName()));
            }
        }
        return prev;
    }

    private IBasicBlock createTry(IBasicBlock prev, ICPPASTTryBlockStatement body) {
        CxxDecisionNode ifNode = this.factory.createDecisionNode((IASTNode)body);
        this.addOutgoing(prev, (IBasicBlock)ifNode);
        IConnectorNode mergeNode = this.factory.createConnectorNode();
        ifNode.setMergeNode(mergeNode);
        IBranchNode tryBodyNode = this.factory.createBranchNode("try");
        this.addOutgoing((IBasicBlock)ifNode, (IBasicBlock)tryBodyNode);
        IBasicBlock tryBody = this.createSubGraph((IBasicBlock)tryBodyNode, body.getTryBody());
        this.addJump(tryBody, mergeNode);
        ICPPASTCatchHandler[] catchHandlers = body.getCatchHandlers();
        int i = 0;
        while (i < catchHandlers.length) {
            ICPPASTCatchHandler handler = catchHandlers[i];
            IASTDeclaration declaration = handler.getDeclaration();
            IBranchNode handlerNode = declaration != null ? this.factory.createBranchNode((IASTNode)declaration) : this.factory.createBranchNode("...");
            this.addOutgoing((IBasicBlock)ifNode, (IBasicBlock)handlerNode);
            IBasicBlock els = this.createSubGraph((IBasicBlock)handlerNode, handler.getCatchBody());
            this.addJump(els, mergeNode);
            ++i;
        }
        return mergeNode;
    }

    private boolean isThrowStatement(IASTNode body) {
        if (!(body instanceof IASTExpressionStatement)) {
            return false;
        }
        IASTExpression expression = ((IASTExpressionStatement)body).getExpression();
        if (!(expression instanceof IASTUnaryExpression)) {
            return false;
        }
        return ((IASTUnaryExpression)expression).getOperator() == 12;
    }

    private boolean isExitStatement(IASTNode body) {
        IASTName name;
        IBinding binding;
        if (!(body instanceof IASTExpressionStatement)) {
            return false;
        }
        IASTExpression expression = ((IASTExpressionStatement)body).getExpression();
        if (!(expression instanceof IASTFunctionCallExpression)) {
            return false;
        }
        IASTExpression functionNameExpression = ((IASTFunctionCallExpression)expression).getFunctionNameExpression();
        if (functionNameExpression instanceof IASTIdExpression && (binding = (name = ((IASTIdExpression)functionNameExpression).getName()).resolveBinding()) instanceof IFunction && ((IFunction)binding).isNoReturn()) {
            return true;
        }
        return functionNameExpression.getRawSignature().equals("exit");
    }

    protected CxxExitNode createExitNode(IBasicBlock prev, IASTNode body) {
        CxxExitNode node = this.factory.createExitNode(body);
        node.setStartNode((IStartNode)this.start);
        this.addOutgoing(prev, (IBasicBlock)node);
        this.exits.add(node);
        return node;
    }

    protected IConnectorNode createLabelNodes(IBasicBlock prev, String labelName) {
        IBranchNode branch = this.factory.createBranchNode(labelName);
        if (prev != null && !(prev instanceof IJumpNode) && !(prev instanceof IExitNode)) {
            this.addOutgoing(prev, (IBasicBlock)branch);
        }
        this.labels.put(labelName, branch);
        IConnectorNode conn = this.factory.createConnectorNode();
        this.addOutgoing((IBasicBlock)branch, (IBasicBlock)conn);
        return conn;
    }

    protected IBasicBlock createIf(IBasicBlock prev, IASTIfStatement body) {
        CxxDecisionNode ifNode = this.factory.createDecisionNode((IASTNode)body.getConditionExpression());
        this.addOutgoing(prev, (IBasicBlock)ifNode);
        IConnectorNode mergeNode = this.factory.createConnectorNode();
        ifNode.setMergeNode(mergeNode);
        IBranchNode thenNode = this.factory.createBranchNode("then");
        this.addOutgoing((IBasicBlock)ifNode, (IBasicBlock)thenNode);
        IBasicBlock then = this.createSubGraph((IBasicBlock)thenNode, body.getThenClause());
        this.addJump(then, mergeNode);
        IBranchNode elseNode = this.factory.createBranchNode("else");
        this.addOutgoing((IBasicBlock)ifNode, (IBasicBlock)elseNode);
        IBasicBlock els = this.createSubGraph((IBasicBlock)elseNode, body.getElseClause());
        this.addJump(els, mergeNode);
        this.fixConnector(mergeNode);
        return mergeNode;
    }

    protected void fixConnector(IConnectorNode mergeNode) {
        if (mergeNode.getIncomingSize() == 0) {
            this.dead.add((IBasicBlock)mergeNode);
        }
    }

    private IBasicBlock createSwitch(IBasicBlock prev, IASTSwitchStatement body) {
        CxxDecisionNode node = this.factory.createDecisionNode((IASTNode)body.getControllerExpression());
        this.addOutgoing(prev, (IBasicBlock)node);
        IConnectorNode mergeNode = this.factory.createConnectorNode();
        node.setMergeNode(mergeNode);
        this.createSwitchBody((IDecisionNode)node, mergeNode, body.getBody());
        this.fixConnector(mergeNode);
        return mergeNode;
    }

    private void createSwitchBody(IDecisionNode switchNode, IConnectorNode mergeNode, IASTStatement body) {
        if (!(body instanceof IASTCompoundStatement)) {
            return;
        }
        IASTCompoundStatement comp = (IASTCompoundStatement)body;
        IDecisionNode prev = switchNode;
        IConnectorNode savedBreak = this.outerBreak;
        this.outerBreak = mergeNode;
        boolean encounteredDefault = false;
        try {
            IASTStatement[] iASTStatementArray = comp.getStatements();
            int n = iASTStatementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IASTStatement statement = iASTStatementArray[n2];
                if (statement instanceof IASTCaseStatement || statement instanceof IASTDefaultStatement) {
                    IBranchNode lbl = null;
                    if (statement instanceof IASTCaseStatement) {
                        lbl = this.factory.createBranchNode((IASTNode)statement);
                    } else if (statement instanceof IASTDefaultStatement) {
                        lbl = this.factory.createBranchNode("default");
                        encounteredDefault = true;
                    }
                    if (!(prev instanceof IExitNode) && prev != switchNode) {
                        IConnectorNode here = this.factory.createConnectorNode();
                        this.addJump((IBasicBlock)prev, here);
                        this.addOutgoing((IBasicBlock)lbl, (IBasicBlock)here);
                        prev = here;
                    } else {
                        prev = lbl;
                    }
                    this.addOutgoing((IBasicBlock)switchNode, (IBasicBlock)lbl);
                } else {
                    prev = this.createSubGraph((IBasicBlock)prev, statement);
                }
                ++n2;
            }
        }
        finally {
            this.outerBreak = savedBreak;
        }
        if (!encounteredDefault) {
            if (!(prev instanceof IExitNode) && prev != switchNode) {
                this.addJump((IBasicBlock)prev, mergeNode);
            }
            IBranchNode defaultBranch = this.factory.createBranchNode("default");
            this.addOutgoing((IBasicBlock)switchNode, (IBasicBlock)defaultBranch);
            prev = defaultBranch;
        }
        this.addJump((IBasicBlock)prev, mergeNode);
    }

    private IBasicBlock createFor(IBasicBlock prev, IASTForStatement forNode) {
        CxxPlainNode init = this.factory.createPlainNode((IASTNode)forNode.getInitializerStatement());
        this.addOutgoing((IBasicBlock)prev, (IBasicBlock)init);
        prev = init;
        IConnectorNode beforeCheck = this.factory.createConnectorNode();
        this.addOutgoing((IBasicBlock)prev, (IBasicBlock)beforeCheck);
        CxxDecisionNode decision = this.factory.createDecisionNode((IASTNode)forNode.getConditionExpression());
        this.addOutgoing((IBasicBlock)beforeCheck, (IBasicBlock)decision);
        IConnectorNode nBreak = this.factory.createConnectorNode();
        decision.setMergeNode(nBreak);
        IBranchNode loopStart = this.factory.createBranchNode("then");
        this.addOutgoing((IBasicBlock)decision, (IBasicBlock)loopStart);
        IConnectorNode nContinue = this.factory.createConnectorNode();
        IConnectorNode savedContinue = this.outerContinue;
        IConnectorNode savedBreak = this.outerBreak;
        this.outerContinue = nContinue;
        this.outerBreak = nBreak;
        CxxDecisionNode endBody = decision;
        try {
            endBody = this.createSubGraph((IBasicBlock)loopStart, forNode.getBody());
        }
        finally {
            this.outerContinue = savedContinue;
            this.outerBreak = savedBreak;
        }
        CxxPlainNode inc = this.factory.createPlainNode((IASTNode)forNode.getIterationExpression());
        this.addOutgoing((IBasicBlock)endBody, (IBasicBlock)nContinue);
        this.addOutgoing((IBasicBlock)nContinue, (IBasicBlock)inc);
        this.addJump((IBasicBlock)inc, beforeCheck, true);
        IBranchNode loopEnd = this.factory.createBranchNode("else");
        this.addOutgoing((IBasicBlock)decision, (IBasicBlock)loopEnd);
        this.addJump((IBasicBlock)loopEnd, nBreak);
        this.fixConnector(nBreak);
        return nBreak;
    }

    private IBasicBlock createRangeBasedFor(IBasicBlock prev, ICPPASTRangeBasedForStatement forNode) {
        CxxPlainNode init = this.factory.createPlainNode((IASTNode)forNode.getDeclaration());
        this.addOutgoing((IBasicBlock)prev, (IBasicBlock)init);
        prev = init;
        IConnectorNode beforeCheck = this.factory.createConnectorNode();
        this.addOutgoing((IBasicBlock)prev, (IBasicBlock)beforeCheck);
        CxxDecisionNode decision = this.factory.createDecisionNode((IASTNode)forNode.getInitializerClause());
        this.addOutgoing((IBasicBlock)beforeCheck, (IBasicBlock)decision);
        IConnectorNode nBreak = this.factory.createConnectorNode();
        decision.setMergeNode(nBreak);
        IBranchNode loopStart = this.factory.createBranchNode("then");
        this.addOutgoing((IBasicBlock)decision, (IBasicBlock)loopStart);
        IConnectorNode nContinue = this.factory.createConnectorNode();
        IConnectorNode savedContinue = this.outerContinue;
        IConnectorNode savedBreak = this.outerBreak;
        this.outerContinue = nContinue;
        this.outerBreak = nBreak;
        IBasicBlock endBody = this.createSubGraph((IBasicBlock)loopStart, forNode.getBody());
        this.outerContinue = savedContinue;
        this.outerBreak = savedBreak;
        IPlainNode inc = this.factory.createPlainNode();
        this.addOutgoing(endBody, (IBasicBlock)nContinue);
        this.addOutgoing((IBasicBlock)nContinue, (IBasicBlock)inc);
        this.addJump((IBasicBlock)inc, beforeCheck, true);
        IBranchNode loopEnd = this.factory.createBranchNode("else");
        this.addOutgoing((IBasicBlock)decision, (IBasicBlock)loopEnd);
        this.addJump((IBasicBlock)loopEnd, nBreak);
        this.fixConnector(nBreak);
        return nBreak;
    }

    protected IBasicBlock createWhile(IBasicBlock prev, IASTWhileStatement body) {
        IConnectorNode nContinue = this.factory.createConnectorNode();
        this.addOutgoing(prev, (IBasicBlock)nContinue);
        CxxDecisionNode decision = this.factory.createDecisionNode((IASTNode)body.getCondition());
        this.addOutgoing((IBasicBlock)nContinue, (IBasicBlock)decision);
        IConnectorNode nBreak = this.factory.createConnectorNode();
        decision.setMergeNode(nBreak);
        IBranchNode loopStart = this.factory.createBranchNode("then");
        this.addOutgoing((IBasicBlock)decision, (IBasicBlock)loopStart);
        IConnectorNode savedContinue = this.outerContinue;
        IConnectorNode savedBreak = this.outerBreak;
        this.outerContinue = nContinue;
        this.outerBreak = nBreak;
        CxxDecisionNode endBody = decision;
        try {
            endBody = this.createSubGraph((IBasicBlock)loopStart, body.getBody());
        }
        finally {
            this.outerContinue = savedContinue;
            this.outerBreak = savedBreak;
        }
        this.addJump((IBasicBlock)endBody, nContinue, true);
        IBranchNode loopEnd = this.factory.createBranchNode("else");
        this.addOutgoing((IBasicBlock)decision, (IBasicBlock)loopEnd);
        this.addJump((IBasicBlock)loopEnd, nBreak);
        this.fixConnector(nBreak);
        return nBreak;
    }

    protected IBasicBlock createDoWhile(IBasicBlock prev, IASTDoStatement body) {
        IConnectorNode loopStart = this.factory.createConnectorNode();
        this.addOutgoing(prev, (IBasicBlock)loopStart);
        IConnectorNode nContinue = this.factory.createConnectorNode();
        IConnectorNode nBreak = this.factory.createConnectorNode();
        IConnectorNode savedContinue = this.outerContinue;
        IConnectorNode savedBreak = this.outerBreak;
        this.outerContinue = nContinue;
        this.outerBreak = nBreak;
        IBasicBlock endBody = this.createSubGraph((IBasicBlock)loopStart, body.getBody());
        this.outerContinue = savedContinue;
        this.outerBreak = savedBreak;
        this.addOutgoing(endBody, (IBasicBlock)nContinue);
        CxxDecisionNode decision = this.factory.createDecisionNode((IASTNode)body.getCondition());
        this.addOutgoing((IBasicBlock)nContinue, (IBasicBlock)decision);
        IBranchNode thenNode = this.factory.createBranchNode("then");
        this.addOutgoing((IBasicBlock)decision, (IBasicBlock)thenNode);
        IJumpNode jumpToStart = this.factory.createJumpNode();
        this.addOutgoing((IBasicBlock)thenNode, (IBasicBlock)jumpToStart);
        ((JumpNode)jumpToStart).setBackward(true);
        this.addOutgoing((IBasicBlock)jumpToStart, (IBasicBlock)loopStart);
        IBranchNode loopEnd = this.factory.createBranchNode("else");
        this.addOutgoing((IBasicBlock)decision, (IBasicBlock)loopEnd);
        decision.setMergeNode(nBreak);
        this.addJump((IBasicBlock)loopEnd, nBreak);
        this.fixConnector(nBreak);
        return nBreak;
    }

    private IJumpNode addJump(IBasicBlock prev, IConnectorNode conn) {
        return this.addJump(prev, conn, false);
    }

    private IJumpNode addJump(IBasicBlock prev, IConnectorNode conn, boolean backward) {
        if (prev instanceof IJumpNode) {
            return (IJumpNode)prev;
        }
        if (prev instanceof IExitNode) {
            return null;
        }
        JumpNode jump = (JumpNode)this.factory.createJumpNode();
        this.addOutgoing(prev, (IBasicBlock)jump);
        jump.setJump(conn, backward);
        ((ConnectorNode)conn).addIncoming((IBasicBlock)jump);
        return jump;
    }

    private void addOutgoing(IBasicBlock prev, IBasicBlock node) {
        if (prev instanceof IExitNode || prev instanceof IJumpNode || prev == null) {
            this.dead.add(node);
            return;
        }
        if (prev instanceof IDecisionNode) {
            if (node instanceof IBranchNode) {
                IDecisionNode decisionNode = (IDecisionNode)prev;
                if (this.isConstant(decisionNode, 1L) && ((IBranchNode)node).getLabel().equals("else")) {
                    this.dead.add(node);
                    return;
                }
                if (this.isConstant(decisionNode, 0L) && ((IBranchNode)node).getLabel().equals("then")) {
                    this.dead.add(node);
                    return;
                }
            } else {
                this.dead.add(node);
                return;
            }
        }
        ((AbstractBasicBlock)prev).addOutgoing(node);
        if (!(node instanceof IStartNode)) {
            ((AbstractBasicBlock)node).addIncoming(prev);
        }
    }

    private boolean isConstant(IDecisionNode node, long testvalue) {
        Number numericalValue;
        IASTNode ast;
        if (node instanceof ICfgData && (ast = (IASTNode)((ICfgData)node).getData()) instanceof IASTExpression && (numericalValue = ValueFactory.getConstantNumericalValue((IASTExpression)((IASTExpression)ast))) != null) {
            return numericalValue.longValue() == testvalue;
        }
        return false;
    }
}

