/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.enablement;

import org.eclipse.cdt.managedbuilder.buildproperties.IBuildProperty;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IHoldsOptions;
import org.eclipse.cdt.managedbuilder.core.IManagedConfigElement;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.IOptionCategory;
import org.eclipse.cdt.managedbuilder.core.IResourceInfo;
import org.eclipse.cdt.managedbuilder.internal.enablement.IBooleanExpression;

public class CheckBuildPropertyExpression
implements IBooleanExpression {
    public static final String NAME = "checkBuildProperty";
    public static final String PROPERTY = "property";
    public static final String VALUE = "value";
    private String fPropertyId;
    private String fValueId;

    public CheckBuildPropertyExpression(IManagedConfigElement element) {
        this.fPropertyId = element.getAttribute(PROPERTY);
        if (this.fPropertyId == null) {
            this.fPropertyId = "";
        }
        this.fValueId = element.getAttribute(VALUE);
    }

    @Override
    public boolean evaluate(IResourceInfo rcInfo, IHoldsOptions holder, IOption option) {
        return this.evaluate(rcInfo);
    }

    @Override
    public boolean evaluate(IResourceInfo rcInfo, IHoldsOptions holder, IOptionCategory category) {
        return this.evaluate(rcInfo);
    }

    private boolean evaluate(IResourceInfo rcInfo) {
        IConfiguration cfg = rcInfo.getParent();
        IBuildProperty prop = CheckBuildPropertyExpression.getBuildProperty(cfg, this.fPropertyId);
        if (prop != null) {
            return this.fValueId != null ? this.fValueId.equals(prop.getValue().getId()) : true;
        }
        return false;
    }

    public static IBuildProperty getBuildProperty(IConfiguration cfg, String id) {
        IBuildProperty prop = cfg.getBuildProperties().getProperty(id);
        return prop;
    }

    public String getPropertyId() {
        return this.fPropertyId;
    }

    public String getValueId() {
        return this.fValueId;
    }
}

