/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTVisibilityLabel;
import org.eclipse.cdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTVisibilityLabel;
import org.eclipse.cdt.internal.ui.refactoring.Messages;
import org.eclipse.cdt.internal.ui.refactoring.ModificationCollector;
import org.eclipse.cdt.internal.ui.refactoring.utils.VisibilityEnum;
import org.eclipse.cdt.ui.PreferenceConstants;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.osgi.util.NLS;
import org.eclipse.text.edits.TextEditGroup;

public class ClassMemberInserter {
    private ClassMemberInserter() {
    }

    public static ASTRewrite createChange(ICPPASTCompositeTypeSpecifier classNode, VisibilityEnum visibility, IASTNode nodeToAdd, boolean isField, ModificationCollector collector) {
        List<ASTRewrite> addedNodesRewrites = ClassMemberInserter.createChange(classNode, visibility, Collections.singletonList(nodeToAdd), isField, collector);
        return addedNodesRewrites.get(0);
    }

    public static List<ASTRewrite> createChange(ICPPASTCompositeTypeSpecifier classNode, VisibilityEnum visibility, List<IASTNode> nodesToAdd, boolean isField, ModificationCollector collector) {
        InsertionInfo info = ClassMemberInserter.findInsertionPoint(classNode, visibility, isField);
        ASTRewrite rewrite = collector.rewriterForTranslationUnit(classNode.getTranslationUnit());
        if (info.getPrologue() != null) {
            rewrite.insertBefore(info.getParentNode(), info.getInsertBeforeNode(), (IASTNode)info.getPrologue(), ClassMemberInserter.createEditDescription(classNode));
        }
        ArrayList<ASTRewrite> addedNodeRewrites = new ArrayList<ASTRewrite>(nodesToAdd.size());
        for (IASTNode node : nodesToAdd) {
            addedNodeRewrites.add(rewrite.insertBefore(info.getParentNode(), info.getInsertBeforeNode(), node, ClassMemberInserter.createEditDescription(classNode)));
        }
        if (info.getEpilogue() != null) {
            rewrite.insertBefore(info.getParentNode(), info.getInsertBeforeNode(), (IASTNode)info.getEpilogue(), ClassMemberInserter.createEditDescription(classNode));
        }
        return addedNodeRewrites;
    }

    public static InsertionInfo findInsertionPoint(ICPPASTCompositeTypeSpecifier classNode, VisibilityEnum visibility, boolean isField) {
        int index;
        VisibilityEnum defaultVisibility;
        InsertionInfo info = new InsertionInfo((IASTNode)classNode);
        VisibilityEnum currentVisibility = defaultVisibility = classNode.getKey() == 1 ? VisibilityEnum.v_public : VisibilityEnum.v_private;
        boolean ascendingVisibilityOrder = ClassMemberInserter.isAscendingVisibilityOrder(classNode);
        int lastFunctionIndex = -1;
        int lastFieldIndex = -1;
        int lastMatchingVisibilityIndex = -1;
        int lastPrecedingVisibilityIndex = -1;
        IASTDeclaration[] members = classNode.getMembers();
        int i = 0;
        while (i < members.length) {
            IASTDeclaration declaration = members[i];
            if (declaration instanceof ICPPASTVisibilityLabel) {
                currentVisibility = VisibilityEnum.from((ICPPASTVisibilityLabel)declaration);
            }
            if (currentVisibility == visibility) {
                lastMatchingVisibilityIndex = i;
                if (declaration instanceof IASTSimpleDeclaration) {
                    IASTDeclarator[] declarators = ((IASTSimpleDeclaration)declaration).getDeclarators();
                    if (declarators.length > 0 && declarators[0] != null) {
                        if (declarators[0] instanceof IASTFunctionDeclarator) {
                            lastFunctionIndex = i;
                        } else {
                            lastFieldIndex = i;
                        }
                    }
                } else if (declaration instanceof ICPPASTFunctionDefinition) {
                    lastFunctionIndex = i;
                }
            } else if (currentVisibility.compareTo(visibility) < 0 == ascendingVisibilityOrder) {
                lastPrecedingVisibilityIndex = i;
            }
            ++i;
        }
        int n = index = isField && lastFieldIndex >= 0 || !isField && lastFunctionIndex < 0 ? lastFieldIndex : lastFunctionIndex;
        if (index < 0) {
            index = lastMatchingVisibilityIndex;
        }
        if (index < 0) {
            index = lastPrecedingVisibilityIndex;
        }
        if (++index < members.length) {
            info.insertBeforeNode = (IASTNode)members[index];
        }
        if (lastMatchingVisibilityIndex < 0 && (index != 0 || classNode.getKey() != 1 || visibility != defaultVisibility)) {
            info.prologue = (ICPPASTVisibilityLabel)new CPPASTVisibilityLabel(visibility.getVisibilityLabelValue());
            if (index == 0 && info.insertBeforeNode != null && !(info.insertBeforeNode instanceof ICPPASTVisibilityLabel)) {
                info.epilogue = (ICPPASTVisibilityLabel)new CPPASTVisibilityLabel(defaultVisibility.getVisibilityLabelValue());
            }
        }
        return info;
    }

    private static TextEditGroup createEditDescription(ICPPASTCompositeTypeSpecifier classNode) {
        return new TextEditGroup(NLS.bind((String)Messages.AddDeclarationNodeToClassChange_AddDeclaration, (Object)classNode.getName()));
    }

    private static boolean isAscendingVisibilityOrder(ICPPASTCompositeTypeSpecifier classNode) {
        IPreferencesService preferences = Platform.getPreferencesService();
        IASTTranslationUnit ast = classNode.getTranslationUnit();
        ITranslationUnit tu = ast.getOriginatingTranslationUnit();
        IProject project = tu != null ? tu.getCProject().getProject() : null;
        return preferences.getBoolean("org.eclipse.cdt.ui", "class_member_ascending_visibility_order", false, PreferenceConstants.getPreferenceScopes(project));
    }

    public static class InsertionInfo {
        private final IASTNode parentNode;
        private IASTNode insertBeforeNode;
        private ICPPASTVisibilityLabel prologue;
        private ICPPASTVisibilityLabel epilogue;

        public InsertionInfo(IASTNode parentNode, IASTNode insertBeforeNode) {
            this.parentNode = parentNode;
            this.insertBeforeNode = insertBeforeNode;
        }

        public InsertionInfo(IASTNode parentNode) {
            this(parentNode, null);
        }

        public IASTNode getParentNode() {
            return this.parentNode;
        }

        public IASTNode getInsertBeforeNode() {
            return this.insertBeforeNode;
        }

        public ICPPASTVisibilityLabel getPrologue() {
            return this.prologue;
        }

        public ICPPASTVisibilityLabel getEpilogue() {
            return this.epilogue;
        }
    }
}

