/**
 * Copyright (c) 2015 Codetrails GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 */
package org.eclipse.epp.logging.aeri.core.filters;

import static org.apache.commons.lang3.ArrayUtils.isEmpty;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.epp.logging.aeri.core.util.Statuses;

import com.google.common.base.Predicate;

public class AcceptFreezeFilter implements Predicate<IStatus> {

    private boolean acceptUIFreezes;

    public AcceptFreezeFilter(boolean acceptUIFreezes) {
        this.acceptUIFreezes = acceptUIFreezes;
    }

    @Override
    public boolean apply(IStatus input) {
        boolean freeze = Statuses.isUiFreeze(input);
        if (!freeze) {
            return true;
        }
        boolean valid = !isEmpty(input.getChildren());
        // no matter if we accept freezes or not: invalid freezes should never go on
        return acceptUIFreezes && valid;
    }
}
