/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.logging.aeri.ide;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.di.extensions.EventTopic;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.emf.common.util.EList;
import org.eclipse.epp.internal.logging.aeri.ide.IIdeFactory;
import org.eclipse.epp.internal.logging.aeri.ide.ILogEvent;
import org.eclipse.epp.internal.logging.aeri.ide.ILogEventGroup;
import org.eclipse.epp.internal.logging.aeri.ide.ILogEventsQueue;
import org.eclipse.epp.internal.logging.aeri.ide.IProcessorDescriptor;
import org.eclipse.epp.internal.logging.aeri.ide.IServerDescriptor;
import org.eclipse.epp.internal.logging.aeri.ide.l10n.LogMessages;
import org.eclipse.epp.internal.logging.aeri.ide.l10n.Messages;
import org.eclipse.epp.internal.logging.aeri.ide.notifications.MylynNotificationsSupport;
import org.eclipse.epp.internal.logging.aeri.ide.processors.Processors;
import org.eclipse.epp.internal.logging.aeri.ide.processors.ReportProcessorSafeWrapper;
import org.eclipse.epp.internal.logging.aeri.ide.processors.WiringErrorAnalyzerProcessor;
import org.eclipse.epp.internal.logging.aeri.ide.utils.Formats;
import org.eclipse.epp.internal.logging.aeri.ide.utils.Servers;
import org.eclipse.epp.internal.logging.aeri.ide.utils.UploadReportsScheduler;
import org.eclipse.epp.logging.aeri.core.IModelFactory;
import org.eclipse.epp.logging.aeri.core.IProblemState;
import org.eclipse.epp.logging.aeri.core.ISendOptions;
import org.eclipse.epp.logging.aeri.core.ISystemSettings;
import org.eclipse.epp.logging.aeri.core.ProblemStatus;
import org.eclipse.epp.logging.aeri.core.SendMode;
import org.eclipse.epp.logging.aeri.core.util.Logs;
import org.osgi.service.event.Event;

public class IDEWorkflow {
    public static final String CTX_LOG_EVENT_LAST = "org.eclipse.epp.logging.aeri.ide.di.event.last";
    public static final String CTX_LOG_EVENT_LAST_NOTIFIED = "org.eclipse.epp.logging.aeri.ide.di.event.last-notified";
    public static final String CTX_LOG_EVENT_LAST_DELAYED = "org.eclipse.epp.logging.aeri.ide.di.event.last-delayed";
    public static final String CTX_SERVERS = "org.eclipse.epp.logging.aeri.ide.servers";
    public static final String CTX_REPORT_PROCESSORS = "org.eclipse.epp.logging.aeri.ide.processors";
    public static final String CTX_BUNDLE_STATE_LOCATION = "org.eclipse.epp.logging.aeri.ide.stateLocation";
    public static final String TOPIC_BASE = "org/eclipse/epp/internal/logging/aeri/ui";
    public static final String TOPIC_NEW_STATUS_LOGGED = "org/eclipse/epp/internal/logging/aeri/ui/status/new";
    public static final String TOPIC_NEW_EVENT_LOGGED = "org/eclipse/epp/internal/logging/aeri/ui/event/new";
    public static final String TOPIC_RESCHEDULE_NOTIFCATION_LAST_LOG_EVENT = "org/eclipse/epp/internal/logging/aeri/ui/event/reschedule";
    public static final String TOPIC_USER_REQUESTS_DISABLE_NEW_SERVERS = "org/eclipse/epp/internal/logging/aeri/ui/servers/disabled";
    public static final String TOPIC_USER_REQUESTS_CLEAR_QUEUE = "org/eclipse/epp/internal/logging/aeri/ui/events/clear";
    public static final String TOPIC_NEW_SERVER_RESPONSES = "org/eclipse/epp/internal/logging/aeri/ui/events/responses";
    public static final String TOPIC_USER_REQUESTS_SEND_ONE_GROUP = "org/eclipse/epp/internal/logging/aeri/ui/event/send/group";
    public static final String TOPIC_USER_REQUESTS_SEND_ALL_GROUPS = "org/eclipse/epp/internal/logging/aeri/ui/event/send/groups";
    private final List<IServerDescriptor> servers;
    private final ILogEventsQueue queue;
    private final ISystemSettings settings;
    private final IEventBroker broker;
    private final MylynNotificationsSupport notificationSupport;
    private final UploadReportsScheduler uploadService;
    private final IEclipseContext context;
    private final List<IProcessorDescriptor> descriptors;
    private boolean systemStateSetupInProgress;
    private boolean systemStateReviewInProgress;
    private boolean systemStateNotificationInProgress;
    private long setupTimeout;

    @Inject
    public IDEWorkflow(@Named(value="org.eclipse.epp.logging.aeri.ide.servers") List<IServerDescriptor> endpoints, ILogEventsQueue queue, ISystemSettings settings, IEventBroker broker, MylynNotificationsSupport notificationSupport, UploadReportsScheduler uploadService, IEclipseContext context, @Named(value="org.eclipse.epp.logging.aeri.ide.processors") List<IProcessorDescriptor> descriptors) {
        this.servers = endpoints;
        this.queue = queue;
        this.settings = settings;
        this.broker = broker;
        this.notificationSupport = notificationSupport;
        this.uploadService = uploadService;
        this.context = context;
        this.descriptors = descriptors;
    }

    @Inject
    @Optional
    protected void onNewStatusLogged(@EventTopic(value="org/eclipse/epp/internal/logging/aeri/ui/status/new") IStatus status) {
        try {
            this.doNewStatusLogged(status);
        }
        catch (Exception e) {
            Logs.log((Logs.ILogMessage)LogMessages.WARN_REPORTING_ERROR, (Throwable)e);
        }
    }

    private void doNewStatusLogged(IStatus status) {
        LinkedList events = Lists.newLinkedList();
        for (IServerDescriptor server : Servers.viewOfEnabled(this.servers)) {
            ISendOptions options = IModelFactory.eINSTANCE.createSendOptions();
            Servers.copyServerDefaultsIfUnset(server, options);
            Servers.copySystemDefaultsIfUnset(this.settings, options);
            IEclipseContext eventContext = this.context.createChild("Log event context for '" + server.getId() + "'");
            eventContext.set(IStatus.class, (Object)status);
            eventContext.set(IServerDescriptor.class, (Object)server);
            eventContext.declareModifiable(ISendOptions.class);
            eventContext.set(ISendOptions.class, (Object)options);
            IProblemState interest = this.getServerInterest(server, status, eventContext);
            if (!this.isInterested(interest)) continue;
            ILogEvent event = IIdeFactory.eINSTANCE.createLogEvent();
            event.setStatus(status);
            event.setContext(eventContext);
            event.setServer(server);
            event.setInterest(interest);
            event.setOptions(options);
            event.setLabel(status.getMessage());
            events.add(event);
        }
        if (!events.isEmpty()) {
            ILogEventGroup group = IIdeFactory.eINSTANCE.createLogEventGroup();
            group.setStatus(status);
            group.getEvents().addAll((Collection)events);
            this.broker.post(TOPIC_NEW_EVENT_LOGGED, (Object)group);
        }
    }

    @Inject
    @Optional
    protected synchronized void onNewEventLogged(@EventTopic(value="org/eclipse/epp/internal/logging/aeri/ui/event/new") ILogEventGroup group) {
        try {
            this.doNewEventLogged(group);
        }
        catch (Exception e) {
            Logs.log((Logs.ILogMessage)LogMessages.WARN_REPORTING_ERROR, (Throwable)e);
        }
    }

    private void doNewEventLogged(ILogEventGroup group) {
        this.context.modify(CTX_LOG_EVENT_LAST, (Object)group);
        EList<ILogEventGroup> groups = this.queue.getGroups();
        groups.add((Object)group);
        if (!this.settings.isConfigured()) {
            if (this.isAfterWelcomeTimeout()) {
                this.setupTimeout = this.in(15, TimeUnit.MINUTES);
                this.notificationSupport.showConfigureSystemNotification();
            }
            this.context.modify(CTX_LOG_EVENT_LAST_DELAYED, (Object)group);
            return;
        }
        LinkedList unconfiguredServers = Lists.newLinkedList();
        for (ILogEvent event : group.getEvents()) {
            IServerDescriptor server = event.getServer();
            if (server.isConfigured()) continue;
            unconfiguredServers.add(server);
        }
        if (!unconfiguredServers.isEmpty()) {
            if (this.canShowNotification()) {
                this.notificationSupport.showConfigureNewServersNotification(unconfiguredServers);
            }
            this.context.modify(CTX_LOG_EVENT_LAST_DELAYED, (Object)group);
            return;
        }
        for (ILogEvent event : group.getEvents()) {
            this.checkAutomaticProcessors(event);
        }
        if (this.settings.getSendMode() == SendMode.BACKGROUND) {
            groups.remove((Object)group);
            this.broker.post(TOPIC_USER_REQUESTS_SEND_ONE_GROUP, (Object)group);
        } else if (this.canShowNotification()) {
            this.context.modify(CTX_LOG_EVENT_LAST_NOTIFIED, (Object)group);
            this.notificationSupport.showNewEventLoggedNotification(group);
        }
    }

    private void checkAutomaticProcessors(ILogEvent event) {
        for (IProcessorDescriptor descriptor : this.descriptors) {
            ReportProcessorSafeWrapper processor;
            EList enabledProcessors;
            if (!descriptor.isAutomatic() || !Processors.shouldProcess(descriptor, event) || descriptor.getProcessor().getWrapped() instanceof WiringErrorAnalyzerProcessor && this.settings.isDisableAutomaticWiringAnalysis() || (enabledProcessors = event.getOptions().getEnabledProcessors()).contains((Object)(processor = descriptor.getProcessor()))) continue;
            enabledProcessors.add((Object)processor);
        }
    }

    @Inject
    @Optional
    protected void onRescheduleDelayedLogEvent(@EventTopic(value="org/eclipse/epp/internal/logging/aeri/ui/event/reschedule") Event busEvent) {
        for (ILogEventGroup group : this.queue.getGroups()) {
            LinkedHashSet remove = Sets.newLinkedHashSet();
            for (ILogEvent event : group.getEvents()) {
                if (!event.getServer().isActive()) {
                    remove.add(event);
                    continue;
                }
                ISendOptions options = IModelFactory.eINSTANCE.createSendOptions();
                Servers.copyServerDefaultsIfUnset(event.getServer(), options);
                Servers.copySystemDefaultsIfUnset(this.settings, options);
                event.setOptions(options);
                event.getContext().set(ISendOptions.class, (Object)options);
                this.checkAutomaticProcessors(event);
            }
            group.getEvents().removeAll((Collection)remove);
        }
        if (this.settings.getSendMode() == SendMode.BACKGROUND) {
            this.broker.post(TOPIC_USER_REQUESTS_SEND_ALL_GROUPS, (Object)this.queue);
            return;
        }
        ILogEventGroup delayed = (ILogEventGroup)this.context.get(CTX_LOG_EVENT_LAST);
        if (!this.canShowNotification() || delayed == null) {
            return;
        }
        this.context.modify(CTX_LOG_EVENT_LAST_NOTIFIED, (Object)delayed);
        this.notificationSupport.showNewEventLoggedNotification(delayed);
        this.context.remove(CTX_LOG_EVENT_LAST_DELAYED);
    }

    @Inject
    @Optional
    protected void onUserDisablesNewEndpoints(@EventTopic(value="org/eclipse/epp/internal/logging/aeri/ui/servers/disabled") Event busEvent) {
        try {
            this.doUserDisablesNewEndpoints();
        }
        catch (Exception e) {
            Logs.log((Logs.ILogMessage)LogMessages.WARN_REPORTING_ERROR, (Throwable)e);
        }
    }

    private void doUserDisablesNewEndpoints() {
        for (IServerDescriptor server : Servers.viewOfUnconfigured(this.servers)) {
            server.setEnabled(false);
            server.setConfigured(true);
        }
    }

    private IProblemState getServerInterest(IServerDescriptor server, IStatus status, IEclipseContext eventContext) {
        IProblemState res;
        try {
            res = server.getConnection().interested(status, eventContext, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (Exception e) {
            Logs.log((Logs.ILogMessage)LogMessages.WARN_SERVER_FAILURE, (Throwable)e, (Object[])new Object[]{server.getId(), e.getMessage()});
            res = IModelFactory.eINSTANCE.createProblemState();
            res.setStatus(ProblemStatus.FAILURE);
            res.setMessage(Formats.format(Messages.NOTIFY_INTEREST_MESSAGE_ENPOINT_FAILED, e.getMessage()));
        }
        eventContext.set(IProblemState.class, (Object)res);
        return res;
    }

    private boolean isInterested(IProblemState predictedState) {
        ProblemStatus status = predictedState.getStatus();
        return !ImmutableSet.of((Object)ProblemStatus.IGNORED, (Object)ProblemStatus.INVALID).contains((Object)status);
    }

    private boolean canShowNotification() {
        return !this.systemStateSetupInProgress && !this.systemStateReviewInProgress && !this.systemStateNotificationInProgress;
    }

    private boolean isAfterWelcomeTimeout() {
        return System.currentTimeMillis() > this.setupTimeout;
    }

    private long in(int i, TimeUnit minutes) {
        return System.currentTimeMillis() + minutes.toMillis(i);
    }

    @Inject
    @Optional
    protected void onSendLogEventGroup(@EventTopic(value="org/eclipse/epp/internal/logging/aeri/ui/event/send/group") ILogEventGroup logEventGroup) {
        this.uploadService.schedule(logEventGroup);
        this.queue.getGroups().remove((Object)logEventGroup);
    }

    @Inject
    @Optional
    void onSendLogEventQueue(@EventTopic(value="org/eclipse/epp/internal/logging/aeri/ui/event/send/groups") Event busEvent) {
        EList<ILogEventGroup> groups = this.queue.getGroups();
        this.uploadService.schedule((Iterable<ILogEventGroup>)this.queue.getGroups());
        groups.clear();
    }

    @Inject
    @Optional
    void onClearEventQueue(@EventTopic(value="org/eclipse/epp/internal/logging/aeri/ui/events/clear") Event busEvent) {
        try {
            this.doClearEventQueue();
        }
        catch (Exception e) {
            Logs.log((Logs.ILogMessage)LogMessages.WARN_REPORTING_ERROR, (Throwable)e);
        }
    }

    private void doClearEventQueue() {
        EList<ILogEventGroup> events = this.queue.getGroups();
        ImmutableList copy = ImmutableList.copyOf(events);
        events.clear();
        for (ILogEventGroup group : copy) {
            for (ILogEvent logEvent : group.getEvents()) {
                IServerDescriptor server = logEvent.getServer();
                server.getConnection().discarded(logEvent.getStatus(), logEvent.getContext());
            }
        }
    }

    @Inject
    @Optional
    protected void onServerResponsesCompleted(@EventTopic(value="org/eclipse/epp/internal/logging/aeri/ui/events/responses") ILogEventGroup group) {
        if (this.canShowNotification()) {
            this.notificationSupport.showServerResponsesNotification(group);
        }
    }

    @Inject
    protected void setConfigureInProgress(@Named(value="org.eclipse.epp.logging.aeri.ide.di.configure-in-progress") boolean newState) {
        this.systemStateSetupInProgress = newState;
    }

    @Inject
    protected void setReviewInProgress(@Named(value="org.eclipse.epp.logging.aeri.ide.di.review-in-progress") boolean newState) {
        this.systemStateReviewInProgress = newState;
    }

    @Inject
    protected void setNotificationInProgress(@Named(value="org.eclipse.epp.logging.aeri.ide.di.notification-in-progress") boolean newState) {
        this.systemStateSetupInProgress = newState;
    }
}

