/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.logging.aeri.ide.notifications;

import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.epp.internal.logging.aeri.ide.ILogEvent;
import org.eclipse.epp.internal.logging.aeri.ide.ILogEventGroup;
import org.eclipse.epp.internal.logging.aeri.ide.IServerDescriptor;
import org.eclipse.epp.internal.logging.aeri.ide.dialogs.UIUtils;
import org.eclipse.epp.internal.logging.aeri.ide.l10n.Messages;
import org.eclipse.epp.internal.logging.aeri.ide.notifications.Notification;
import org.eclipse.epp.internal.logging.aeri.ide.notifications.NotificationAction;
import org.eclipse.epp.internal.logging.aeri.ide.utils.Browsers;
import org.eclipse.epp.internal.logging.aeri.ide.utils.Formats;
import org.eclipse.epp.logging.aeri.core.IProblemState;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.mylyn.commons.ui.compatibility.CommonColors;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;

public class ServerResponsesNotification
extends Notification {
    private ILogEventGroup group;
    private ImageRegistry registry;

    @Inject
    public ServerResponsesNotification(ILogEventGroup group, ImageRegistry registry, IEventBroker broker) {
        super("org.eclipse.epp.logging.aeri.notifications.event.responses", broker);
        this.group = group;
        this.registry = registry;
    }

    public Control createControl(Composite parent) {
        GridDataFactory asis = GridDataFactory.fillDefaults().align(4, 128);
        GridDataFactory w400 = GridDataFactory.fillDefaults().hint(400, -1).grab(false, false).align(4, 128);
        GridDataFactory w360 = GridDataFactory.fillDefaults().hint(370, -1).grab(false, false).align(4, 128);
        Composite container = new Composite(parent, 524288);
        GridLayoutFactory.fillDefaults().extendedMargins(0, 0, 0, 0).applyTo(container);
        w400.applyTo((Control)container);
        String labelText = this.getLabel();
        if (StringUtils.isNotBlank((CharSequence)labelText)) {
            Link label = new Link(container, 524352);
            label.setText(labelText);
            label.setForeground(CommonColors.TEXT_QUOTED);
            w400.applyTo((Control)label);
        }
        Link description = new Link(container, 524352);
        description.setText(this.getDescription());
        w400.applyTo((Control)description);
        Composite serverSections = new Composite(container, 524288);
        GridLayoutFactory.fillDefaults().numColumns(2).equalWidth(false).applyTo(serverSections);
        for (ILogEvent event : this.group.getEvents()) {
            IServerDescriptor server = event.getServer();
            IProblemState response = event.getResponse();
            Label icon = new Label(serverSections, 524288);
            Image image = UIUtils.decorate(server, response.getStatus(), this.registry);
            icon.setImage(image);
            asis.applyTo((Control)icon);
            Link message = new Link(serverSections, 524352);
            w360.applyTo((Control)message);
            message.setText(StringUtils.defaultString((String)response.getMessage()));
            message.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Browsers.openInExternalBrowser(e.text);
                }
            });
        }
        return container;
    }

    @Override
    public String getTitle() {
        return Formats.format(Messages.NOTIFICATION_TITLE_SERVER_RESPONSES, this.group.getEvents().size());
    }

    public String getLabel() {
        return "";
    }

    public String getDescription() {
        return Formats.format(Messages.NOTIFICATION_DESCRIPTION_SERVER_RESPONSES, StringUtils.abbreviate((String)this.group.getStatus().getMessage(), (int)80), this.group.getEvents().size());
    }

    @Override
    public List<NotificationAction> getActions() {
        return Collections.emptyList();
    }
}

