/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.logging.aeri.ide.server;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.util.concurrent.AbstractIdleService;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.commons.lang3.StringUtils;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.core.KeywordAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.SearcherManager;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.LockObtainFailedException;
import org.apache.lucene.util.IOUtils;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.epp.internal.logging.aeri.ide.l10n.LogMessages;
import org.eclipse.epp.internal.logging.aeri.ide.l10n.Messages;
import org.eclipse.epp.logging.aeri.core.SystemControl;
import org.eclipse.epp.logging.aeri.core.util.Logs;
import org.eclipse.epp.logging.aeri.core.util.Statuses;

public class LocalReportsHistory
extends AbstractIdleService {
    private static final String F_VERSION = "version";
    private static final String VERSION = "0.6";
    private static final String F_IDENTITY = "identity";
    private File stateLocation;
    private Directory index;
    private IndexWriter writer;
    private SearcherManager manager;

    public LocalReportsHistory(File stateLocation) {
        this.stateLocation = stateLocation;
    }

    @PostConstruct
    private void e4Start() {
        this.startAsync();
    }

    protected void startUp() throws Exception {
        this.index = this.createIndexDirectory();
        this.createWriter();
        this.createSearchManager();
    }

    public boolean seen(IStatus status) {
        Preconditions.checkNotNull((Object)status);
        Preconditions.checkState((boolean)this.isRunning());
        String fingerprint = LocalReportsHistory.computeHistoryFingerprint(status);
        boolean seen = this.seen(fingerprint);
        return seen;
    }

    private boolean seen(String fingerprint) {
        TermQuery query = new TermQuery(new Term(F_IDENTITY, fingerprint));
        IndexSearcher searcher = null;
        try {
            boolean foundIdenticalReport;
            searcher = (IndexSearcher)this.manager.acquire();
            TopDocs results = searcher.search((Query)query, 1);
            boolean bl = foundIdenticalReport = results.totalHits > 0L;
            return bl;
        }
        catch (Exception e) {
            Logs.log((Logs.ILogMessage)LogMessages.WARN_HISTORY_NOT_AVAILABLE, (Throwable)e);
            return false;
        }
        finally {
            try {
                if (searcher != null) {
                    this.manager.release((Object)searcher);
                    searcher = null;
                }
            }
            catch (IOException e) {
                Logs.log((Logs.ILogMessage)LogMessages.WARN_HISTORY_NOT_AVAILABLE, (Throwable)e);
            }
        }
    }

    private static String computeHistoryFingerprint(IStatus status) {
        IStatus relevant = Statuses.findRelevantStatus((IStatus)status);
        Throwable exception = (Throwable)Preconditions.checkNotNull((Object)relevant.getException());
        StackTraceElement[] normalizes = Statuses.normalize((Throwable)exception);
        StackTraceElement[] truncated = Statuses.truncate((StackTraceElement[])normalizes);
        String fingerprint = Statuses.newFingerprint((StackTraceElement[])truncated, (boolean)false);
        return fingerprint;
    }

    public void remember(IStatus status) {
        Preconditions.checkNotNull((Object)status);
        Preconditions.checkState((boolean)this.isRunning());
        this.doRemember(status);
        this.reopen();
    }

    private void doRemember(IStatus status) {
        String fingerprint = LocalReportsHistory.computeHistoryFingerprint(status);
        if (this.seen(fingerprint)) {
            return;
        }
        Document doc = new Document();
        StringField field = new StringField(F_IDENTITY, fingerprint, Field.Store.NO);
        doc.add((IndexableField)field);
        try {
            this.writer.addDocument((Iterable)doc);
            this.writer.commit();
        }
        catch (Exception e) {
            Logs.log((Logs.ILogMessage)LogMessages.WARN_HISTORY_NOT_AVAILABLE, (Throwable)e);
        }
        if (SystemControl.isDebug()) {
            Logs.log((Logs.ILogMessage)LogMessages.DEBUG_HISTORY_REMEMBER_STATUS, (Object[])new Object[]{StringUtils.abbreviateMiddle((String)status.getMessage(), (String)Messages.LOG_HISTORY_ABBREVIATION, (int)60), fingerprint, StringUtils.abbreviateMiddle((String)this.stateLocation.toString(), (String)Messages.LOG_HISTORY_ABBREVIATION, (int)60)});
        }
    }

    private void reopen() {
        try {
            this.manager.maybeRefresh();
        }
        catch (IOException e) {
            Logs.log((Logs.ILogMessage)LogMessages.WARN_HISTORY_NOT_AVAILABLE, (Throwable)e);
        }
    }

    @VisibleForTesting
    protected Directory createIndexDirectory() throws IOException {
        this.stateLocation.mkdirs();
        this.index = FSDirectory.open((Path)this.stateLocation.toPath());
        return this.index;
    }

    private void createWriter() throws CorruptIndexException, LockObtainFailedException, IOException {
        IndexWriterConfig conf = new IndexWriterConfig((Analyzer)new KeywordAnalyzer());
        conf.setOpenMode(IndexWriterConfig.OpenMode.CREATE_OR_APPEND);
        this.writer = new IndexWriter(this.index, conf);
        if (this.writer.numDocs() == 0) {
            this.buildInitialIndex();
        }
    }

    private void buildInitialIndex() throws CorruptIndexException, IOException {
        Document meta = new Document();
        meta.add((IndexableField)new StoredField(F_VERSION, VERSION));
        this.writer.addDocument((Iterable)meta);
        this.writer.commit();
    }

    private void createSearchManager() throws IOException {
        this.manager = new SearcherManager(this.index, null);
    }

    @PreDestroy
    private void e4Stop() {
        try {
            this.stopAsync().awaitTerminated(2L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            Logs.log((Logs.ILogMessage)LogMessages.WARN_HISTORY_STOP_FAILED, (Throwable)e);
        }
    }

    protected void shutDown() throws Exception {
        IOUtils.close((Closeable[])new Closeable[]{this.writer, this.index});
        this.manager.close();
    }

    public static class LocalHistorySeenFilter
    implements Predicate<IStatus> {
        private LocalReportsHistory history;

        public LocalHistorySeenFilter(LocalReportsHistory history) {
            this.history = history;
        }

        public boolean apply(IStatus input) {
            if (SystemControl.isDebug()) {
                return true;
            }
            if (!this.history.isRunning()) {
                return false;
            }
            return !this.history.seen(input);
        }
    }
}

