/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.mpc.ui.wizards;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.epp.internal.mpc.ui.catalog.FavoriteListCatalogItem;
import org.eclipse.epp.internal.mpc.ui.catalog.FavoritesDiscoveryStrategy;
import org.eclipse.epp.internal.mpc.ui.catalog.MarketplaceNodeCatalogItem;
import org.eclipse.epp.internal.mpc.ui.catalog.UserActionCatalogItem;
import org.eclipse.epp.internal.mpc.ui.css.StyleHelper;
import org.eclipse.epp.internal.mpc.ui.wizards.AbstractMarketplaceDiscoveryItem;
import org.eclipse.epp.internal.mpc.ui.wizards.DiscoverFavoritesUserActionItem;
import org.eclipse.epp.internal.mpc.ui.wizards.FavoriteListDiscoveryItem;
import org.eclipse.epp.internal.mpc.ui.wizards.FavoritesDiscoveryItem;
import org.eclipse.epp.internal.mpc.ui.wizards.ImportFavoritesPage;
import org.eclipse.epp.internal.mpc.ui.wizards.MarketplaceDiscoveryResources;
import org.eclipse.epp.internal.mpc.ui.wizards.MarketplaceViewer;
import org.eclipse.epp.internal.mpc.ui.wizards.Messages;
import org.eclipse.equinox.internal.p2.discovery.AbstractDiscoveryStrategy;
import org.eclipse.equinox.internal.p2.discovery.Catalog;
import org.eclipse.equinox.internal.p2.discovery.model.CatalogCategory;
import org.eclipse.equinox.internal.p2.discovery.model.CatalogItem;
import org.eclipse.equinox.internal.p2.ui.discovery.util.ControlListItem;
import org.eclipse.equinox.internal.p2.ui.discovery.wizards.CatalogConfiguration;
import org.eclipse.equinox.internal.p2.ui.discovery.wizards.CatalogViewer;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class FavoritesViewer
extends CatalogViewer {
    private MarketplaceDiscoveryResources discoveryResources;
    private Button installSelectedCheckbox;
    private PixelConverter pixelConverter;
    private boolean installSelected;
    private Button selectAllButton;
    private Button deselectAllButton;

    public FavoritesViewer(Catalog catalog, ImportFavoritesPage page, CatalogConfiguration configuration) {
        super(catalog, (IShellProvider)page, (IRunnableContext)page.getWizard().getContainer(), configuration);
        this.setAutomaticFind(false);
        this.setRefreshJobDelay(50L);
    }

    public void setFilterText(String newFilter) {
        super.setFilterText(newFilter);
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.createViewerButtonBar((Composite)this.getControl());
    }

    protected void createViewerButtonBar(Composite parent) {
        Composite buttonBar = new Composite(parent, 0);
        buttonBar.setFont(parent.getFont());
        this.pixelConverter = new PixelConverter((Control)parent);
        GridLayoutFactory layoutFactory = GridLayoutFactory.swtDefaults().numColumns(2).equalWidth(false).margins(this.pixelConverter.convertHorizontalDLUsToPixels(7), 0).spacing(this.pixelConverter.convertHorizontalDLUsToPixels(4), 0);
        layoutFactory.applyTo(buttonBar);
        GridDataFactory.swtDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)buttonBar);
        this.createInstallCheckbox(buttonBar);
        Composite buttonContainer = new Composite(buttonBar, 0);
        buttonContainer.setFont(parent.getFont());
        layoutFactory.margins(0, 0).equalWidth(true).numColumns(0).applyTo(buttonContainer);
        GridDataFactory.swtDefaults().align(0x1000008, 4).grab(true, false).applyTo((Control)buttonContainer);
        this.createButtonsForViewerButtonBar(buttonContainer);
        this.updateButtonState(this.getSelection());
    }

    private void createButtonsForViewerButtonBar(Composite buttonContainer) {
        this.selectAllButton = this.createButton(buttonContainer, 18, Messages.FavoritesViewer_SelectAll);
        this.deselectAllButton = this.createButton(buttonContainer, 19, Messages.FavoritesViewer_DeselectAll);
        this.addSelectionChangedListener(event -> {
            IStructuredSelection selection = event.getStructuredSelection();
            this.updateButtonState(selection);
        });
    }

    private void updateButtonState(IStructuredSelection selection) {
        List<MarketplaceNodeCatalogItem> items = FavoritesViewer.filterSelectableItems(this.getCatalog().getItems().iterator());
        List<MarketplaceNodeCatalogItem> selectedItems = FavoritesViewer.filterSelectableItems(selection == null ? null : selection.iterator());
        this.installSelectedCheckbox.setEnabled(!items.isEmpty());
        if (items.isEmpty()) {
            this.selectAllButton.setEnabled(false);
            this.deselectAllButton.setEnabled(false);
        } else if (selectedItems.isEmpty()) {
            this.selectAllButton.setEnabled(true);
            this.deselectAllButton.setEnabled(false);
        } else {
            this.deselectAllButton.setEnabled(true);
            if (selectedItems.size() == items.size()) {
                this.selectAllButton.setEnabled(false);
            } else {
                this.selectAllButton.setEnabled(true);
            }
        }
    }

    private static List<MarketplaceNodeCatalogItem> filterSelectableItems(Iterator<?> items) {
        if (items == null || !items.hasNext()) {
            return Collections.emptyList();
        }
        ArrayList<MarketplaceNodeCatalogItem> selectableItems = null;
        while (items.hasNext()) {
            Object element = items.next();
            if (!(element instanceof MarketplaceNodeCatalogItem)) continue;
            if (selectableItems == null) {
                selectableItems = new ArrayList<MarketplaceNodeCatalogItem>();
            }
            selectableItems.add((MarketplaceNodeCatalogItem)((Object)element));
        }
        return selectableItems == null ? Collections.emptyList() : selectableItems;
    }

    protected Button createButton(Composite parent, int id, String label) {
        ++((GridLayout)parent.getLayout()).numColumns;
        Button button = new Button(parent, 8);
        button.setText(label);
        button.setFont(JFaceResources.getDialogFont());
        button.setData((Object)id);
        button.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                FavoritesViewer.this.buttonPressed((Integer)e.widget.getData());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.setButtonLayoutData(button);
        return button;
    }

    private void setButtonLayoutData(Button button) {
        AbstractMarketplaceDiscoveryItem.createButtonLayoutData(button, this.pixelConverter).applyTo((Control)button);
    }

    protected void buttonPressed(int id) {
        if (id == 18) {
            this.selectAll();
        } else if (id == 19) {
            this.deselectAll();
        }
    }

    private void deselectAll() {
        this.setSelection((IStructuredSelection)StructuredSelection.EMPTY);
    }

    private void selectAll() {
        StructuredSelection all = new StructuredSelection(this.getCatalog().getItems());
        this.setSelection((IStructuredSelection)all);
    }

    protected void createInstallCheckbox(Composite buttonContainer) {
        this.installSelectedCheckbox = new Button(buttonContainer, 32);
        this.installSelectedCheckbox.setText(Messages.FavoritesViewer_SelectForInstallation);
        this.installSelectedCheckbox.setToolTipText(Messages.FavoritesViewer_SelectForInstallationTooltip);
        GridDataFactory.defaultsFor((Control)this.installSelectedCheckbox).applyTo((Control)this.installSelectedCheckbox);
        this.installSelectedCheckbox.setSelection(this.installSelected);
        this.installSelectedCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FavoritesViewer.this.installSelected = ((Button)e.widget).getSelection();
            }
        });
    }

    private void updateInstallSelectedCheckbox() {
        if (this.installSelectedCheckbox != null && !this.installSelectedCheckbox.isDisposed()) {
            this.installSelectedCheckbox.setSelection(this.installSelected);
        }
    }

    protected StructuredViewer doCreateViewer(Composite container) {
        StructuredViewer viewer = super.doCreateViewer(container);
        this.discoveryResources = new MarketplaceDiscoveryResources(container.getDisplay());
        viewer.getControl().addDisposeListener(e -> {
            this.discoveryResources.dispose();
            this.discoveryResources = null;
        });
        super.getResources().dispose();
        viewer.setComparator(null);
        new StyleHelper().on((Widget)viewer.getControl()).setClass("FavoritesViewer");
        return viewer;
    }

    private static <T extends Widget> T findControl(Composite container, Class<T> type) {
        Control[] children;
        Control[] controlArray = children = container.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            T childMatch;
            Control control = controlArray[n2];
            if (type.isInstance(control)) {
                return (T)((Widget)type.cast(control));
            }
            if (control instanceof Composite && (childMatch = FavoritesViewer.findControl((Composite)control, type)) != null) {
                return childMatch;
            }
            ++n2;
        }
        return null;
    }

    protected void doCreateHeaderControls(Composite parent) {
        Label searchLabel = FavoritesViewer.findControl(parent, Label.class);
        Text searchField = FavoritesViewer.findControl(parent, Text.class);
        if (searchLabel != null) {
            searchLabel.setText(Messages.FavoritesViewer_searchLabel);
        }
        if (searchField != null) {
            searchField.setMessage(Messages.FavoritesViewer_searchInputDescription);
            searchField.addVerifyListener(e -> {
                if (e.keyCode == 0 && e.start == 0 && e.end == searchField.getText().length() && e.text.length() > 0) {
                    this.filterTextChanged();
                }
            });
        }
        MarketplaceViewer.fixFindControlsLayout(parent);
    }

    protected void modifySelection(CatalogItem connector, boolean selected) {
        if (selected && connector != null) {
            List checkedItems = this.getCheckedItems();
            boolean alreadyChecked = checkedItems.contains(connector);
            if (!(!alreadyChecked || connector.isSelected() && this.getSelection().toList().contains(connector))) {
                super.modifySelection(connector, false);
                super.modifySelection(connector, true);
            }
        } else {
            super.modifySelection(connector, selected);
        }
    }

    public void setSelection(IStructuredSelection selection) {
        if (selection.isEmpty() || this.getSelection().isEmpty() && this.getCheckedItems().isEmpty()) {
            super.setSelection(selection);
        } else {
            super.setSelection((IStructuredSelection)StructuredSelection.EMPTY);
            super.setSelection(selection);
        }
    }

    public void updateCatalog() {
        this.setSelection((IStructuredSelection)StructuredSelection.EMPTY);
        super.updateCatalog();
        this.updateButtonState(this.getSelection());
    }

    protected MarketplaceDiscoveryResources getResources() {
        return this.discoveryResources;
    }

    protected CatalogViewer.CatalogContentProvider doCreateContentProvider() {
        return new MarketplaceViewer.MarketplaceCatalogContentProvider();
    }

    protected ControlListItem<?> doCreateViewerItem(Composite parent, Object element) {
        AbstractMarketplaceDiscoveryItem item;
        boolean isCategory = false;
        if (element instanceof MarketplaceNodeCatalogItem) {
            item = this.createDiscoveryItem(parent, (MarketplaceNodeCatalogItem)((Object)element));
        } else if (element instanceof UserActionCatalogItem) {
            item = new DiscoverFavoritesUserActionItem(parent, this.getResources(), (UserActionCatalogItem)((Object)element), this);
        } else if (element instanceof FavoriteListCatalogItem) {
            item = new FavoriteListDiscoveryItem(parent, this.discoveryResources, (FavoriteListCatalogItem)((Object)element), this);
        } else {
            item = super.doCreateViewerItem(parent, element);
            isCategory = element instanceof CatalogCategory;
        }
        new StyleHelper().on((Widget)item).addClasses(new String[]{isCategory ? "MarketplaceCategory" : "MarketplaceItem", "FavoriteItem"});
        return item;
    }

    private FavoritesDiscoveryItem createDiscoveryItem(Composite parent, MarketplaceNodeCatalogItem catalogItem) {
        return new FavoritesDiscoveryItem(parent, 0, this.getResources(), catalogItem, this);
    }

    protected Set<String> getInstalledFeatures(IProgressMonitor monitor) {
        return Collections.emptySet();
    }

    protected void doFind(String text) {
        FavoritesDiscoveryStrategy favoritesStrategy = this.findFavoritesStrategy();
        if (favoritesStrategy != null) {
            favoritesStrategy.setFavoritesReference(text);
        }
        this.updateCatalog();
    }

    private FavoritesDiscoveryStrategy findFavoritesStrategy() {
        FavoritesDiscoveryStrategy favoritesStrategy = null;
        List discoveryStrategies = this.getCatalog().getDiscoveryStrategies();
        for (AbstractDiscoveryStrategy strategy : discoveryStrategies) {
            if (!(strategy instanceof FavoritesDiscoveryStrategy)) continue;
            favoritesStrategy = (FavoritesDiscoveryStrategy)strategy;
            break;
        }
        return favoritesStrategy;
    }

    protected void catalogUpdated(boolean wasCancelled, boolean wasError) {
        List items = this.getCatalog().getItems();
        LinkedHashSet<CatalogItem> selectedItems = new LinkedHashSet<CatalogItem>();
        for (CatalogItem catalogItem : items) {
            if (!catalogItem.isSelected()) continue;
            selectedItems.add(catalogItem);
        }
        this.setSelection((IStructuredSelection)StructuredSelection.EMPTY);
        super.catalogUpdated(wasCancelled, wasError);
        this.setSelection((IStructuredSelection)new StructuredSelection(new ArrayList(selectedItems)));
    }

    public void setInstallSelected(boolean install) {
        this.installSelected = install;
        this.updateInstallSelectedCheckbox();
    }

    public boolean isInstallSelected() {
        return this.installSelected;
    }

    public void setFavoritesUrl(String url) {
        this.setFilterText(url);
        this.filterTextChanged();
    }
}

