/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.dot.internal.ui.language.folding;

import com.google.inject.Inject;
import com.google.inject.Injector;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.dot.internal.language.dot.Attribute;
import org.eclipse.gef.dot.internal.language.dot.DotPackage;
import org.eclipse.gef.dot.internal.language.terminals.ID;
import org.eclipse.gef.dot.internal.ui.language.editor.DotEditorUtils;
import org.eclipse.gef.dot.internal.ui.language.internal.DotActivator;
import org.eclipse.gef.dot.internal.ui.language.internal.DotActivatorEx;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.parser.IParseResult;
import org.eclipse.xtext.resource.ILocationInFileProvider;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.folding.DefaultFoldingRegionProvider;
import org.eclipse.xtext.ui.editor.folding.FoldedPosition;
import org.eclipse.xtext.ui.editor.folding.IFoldingRegionAcceptor;
import org.eclipse.xtext.ui.editor.folding.IFoldingRegionProvider;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.util.ITextRegion;
import org.eclipse.xtext.util.ITextRegionWithLineInformation;

public class DotFoldingRegionProvider
extends DefaultFoldingRegionProvider {
    @Inject
    private ILocationInFileProvider locationInFileProvider;
    private List<ITextRegionWithLineInformation> acceptedRegions = new LinkedList<ITextRegionWithLineInformation>();

    protected void computeObjectFolding(XtextResource xtextResource, IFoldingRegionAcceptor<ITextRegion> foldingRegionAcceptor) {
        EObject rootASTElement;
        this.acceptedRegions.clear();
        IParseResult parseResult = xtextResource.getParseResult();
        if (parseResult != null && (rootASTElement = parseResult.getRootASTElement()) != null) {
            TreeIterator allContents = rootASTElement.eAllContents();
            while (allContents.hasNext()) {
                EObject eObject = (EObject)allContents.next();
                if (this.isHandled(eObject)) {
                    this.computeObjectFolding(eObject, foldingRegionAcceptor);
                }
                if (eObject instanceof Attribute) {
                    this.computeDotAttributeValueFolding((Attribute)eObject, foldingRegionAcceptor);
                }
                if (this.shouldProcessContent(eObject)) continue;
                allContents.prune();
            }
        }
    }

    protected void computeObjectFolding(EObject eObject, IFoldingRegionAcceptor<ITextRegion> foldingRegionAcceptor) {
        ITextRegion region = this.locationInFileProvider.getFullTextRegion(eObject);
        ITextRegionWithLineInformation regionWithLineInformation = (ITextRegionWithLineInformation)region;
        if (region != null) {
            ITextRegion significant = this.locationInFileProvider.getSignificantTextRegion(eObject);
            if (significant == null) {
                throw new NullPointerException("significant region may not be null");
            }
            if (!this.isAlreadyAccepted(regionWithLineInformation)) {
                foldingRegionAcceptor.accept(region.getOffset(), region.getLength(), (Object)significant);
                this.acceptedRegions.add(regionWithLineInformation);
            }
        }
    }

    private boolean isAlreadyAccepted(ITextRegionWithLineInformation regionWithLineInformation) {
        for (ITextRegionWithLineInformation acceptedRegion : this.acceptedRegions) {
            if (!this.equals(regionWithLineInformation, acceptedRegion)) continue;
            return true;
        }
        return false;
    }

    private boolean equals(ITextRegionWithLineInformation region1, ITextRegionWithLineInformation region2) {
        return region1.getLineNumber() == region2.getLineNumber() && region1.getEndLineNumber() == region2.getEndLineNumber();
    }

    private void computeDotAttributeValueFolding(Attribute attribute, IFoldingRegionAcceptor<ITextRegion> foldingRegionAcceptor) {
        if (attribute.getValue() != null && attribute.getValue().getType() == ID.Type.HTML_STRING) {
            String htmlLabelValue = attribute.getValue().toValue();
            Injector injector = DotActivator.getInstance().getInjector("org.eclipse.gef.dot.internal.language.DotHtmlLabel");
            IFoldingRegionProvider htmlLabelFoldingRegionProvider = (IFoldingRegionProvider)injector.getInstance(IFoldingRegionProvider.class);
            IXtextDocument xtextDocument = null;
            try {
                xtextDocument = DotEditorUtils.getDocument(injector, htmlLabelValue);
            }
            catch (Exception e) {
                DotActivatorEx.logError(e);
            }
            if (xtextDocument != null) {
                Collection htmlLabelFoldingRegions = htmlLabelFoldingRegionProvider.getFoldingRegions(xtextDocument);
                for (FoldedPosition htmlFoldedPosition : htmlLabelFoldingRegions) {
                    int attributeValueStartOffset = this.getAttributeValueStartOffset(attribute);
                    foldingRegionAcceptor.accept(attributeValueStartOffset + htmlFoldedPosition.getOffset(), htmlFoldedPosition.getLength() - 1);
                }
            }
        }
    }

    private int getAttributeValueStartOffset(Attribute attribute) {
        ID attributeValue = attribute.getValue();
        List nodes = NodeModelUtils.findNodesForFeature((EObject)attribute, (EStructuralFeature)DotPackage.Literals.ATTRIBUTE__VALUE);
        if (nodes.size() != 1) {
            System.err.println("Exact 1 node is expected for the attribute value: " + attributeValue + ", but got " + nodes.size());
            return 0;
        }
        INode node = (INode)nodes.get(0);
        int attributeValueStartOffset = node.getOffset();
        if (attributeValue.getType() == ID.Type.HTML_STRING || attributeValue.getType() == ID.Type.QUOTED_STRING) {
            ++attributeValueStartOffset;
        }
        return attributeValueStartOffset;
    }
}

