/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.features.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IMoveShapeContext;
import org.eclipse.graphiti.features.impl.AbstractMoveShapeFeature;
import org.eclipse.graphiti.mm.algorithms.styles.Point;
import org.eclipse.graphiti.mm.pictograms.Anchor;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.FreeFormConnection;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;

public class DefaultMoveShapeFeature
extends AbstractMoveShapeFeature {
    public DefaultMoveShapeFeature(IFeatureProvider fp) {
        super(fp);
    }

    protected boolean avoidNegativeCoordinates() {
        return false;
    }

    @Override
    public boolean canMoveShape(IMoveShapeContext context) {
        return context.getSourceContainer() != null && context.getSourceContainer().equals(context.getTargetContainer());
    }

    @Override
    public void moveShape(IMoveShapeContext context) {
        this.preMoveShape(context);
        this.moveAllBendpoints(context);
        this.internalMove(context);
        this.postMoveShape(context);
    }

    protected void moveAllBendpoints(IMoveShapeContext context) {
        Shape shapeToMove = context.getShape();
        int x = context.getX();
        int y = context.getY();
        int deltaX = x - shapeToMove.getGraphicsAlgorithm().getX();
        int deltaY = y - shapeToMove.getGraphicsAlgorithm().getY();
        if (deltaX != 0 || deltaY != 0) {
            ArrayList<FreeFormConnection> connectionList = new ArrayList<FreeFormConnection>();
            FreeFormConnection[] containerConnections = this.calculateContainerConnections(context);
            int i = 0;
            while (i < containerConnections.length) {
                FreeFormConnection cc = containerConnections[i];
                if (!connectionList.contains(cc)) {
                    connectionList.add(cc);
                }
                ++i;
            }
            FreeFormConnection[] connectedConnections = this.calculateConnectedConnections(context);
            int i2 = 0;
            while (i2 < connectedConnections.length) {
                FreeFormConnection cc = connectedConnections[i2];
                if (!connectionList.contains(cc)) {
                    connectionList.add(cc);
                }
                ++i2;
            }
            for (FreeFormConnection conn : connectionList) {
                this.moveAllBendpointsOnFFConnection(conn, deltaX, deltaY);
            }
        }
    }

    protected void postMoveShape(IMoveShapeContext context) {
    }

    protected void preMoveShape(IMoveShapeContext context) {
    }

    protected void internalMove(IMoveShapeContext context) {
        if (!this.getUserDecision()) {
            return;
        }
        Shape shapeToMove = context.getShape();
        ContainerShape oldContainerShape = context.getSourceContainer();
        ContainerShape newContainerShape = context.getTargetContainer();
        int x = context.getX();
        int y = context.getY();
        if (oldContainerShape != newContainerShape) {
            EList children;
            PictogramElement[] currentSelection = this.getDiagramBehavior().getDiagramContainer().getSelectedPictogramElements();
            if (oldContainerShape != null && (children = oldContainerShape.getChildren()) != null) {
                children.remove(shapeToMove);
            }
            shapeToMove.setContainer(newContainerShape);
            if (shapeToMove.getGraphicsAlgorithm() != null) {
                Graphiti.getGaService().setLocation(shapeToMove.getGraphicsAlgorithm(), x, y, this.avoidNegativeCoordinates());
            }
            this.getDiagramBehavior().getDiagramContainer().setPictogramElementsForSelection(currentSelection);
        } else if (shapeToMove.getGraphicsAlgorithm() != null) {
            Graphiti.getGaService().setLocation(shapeToMove.getGraphicsAlgorithm(), x, y, this.avoidNegativeCoordinates());
        }
    }

    private FreeFormConnection[] calculateContainerConnections(IMoveShapeContext context) {
        FreeFormConnection[] ret = new FreeFormConnection[]{};
        if (!(context.getShape() instanceof ContainerShape)) {
            return ret;
        }
        ArrayList<FreeFormConnection> retList = new ArrayList<FreeFormConnection>();
        Shape shapeToMove = context.getShape();
        int x = context.getX();
        int y = context.getY();
        int deltaX = x - shapeToMove.getGraphicsAlgorithm().getX();
        int deltaY = y - shapeToMove.getGraphicsAlgorithm().getY();
        if (deltaX != 0 || deltaY != 0) {
            List<Anchor> anchorsFrom = this.getAnchors(shapeToMove);
            ArrayList<Anchor> anchorsTo = new ArrayList<Anchor>(anchorsFrom);
            for (Anchor anchorFrom : anchorsFrom) {
                EList outgoingConnections = anchorFrom.getOutgoingConnections();
                for (Connection connection : outgoingConnections) {
                    for (Anchor anchorTo : anchorsTo) {
                        EList incomingConnections = anchorTo.getIncomingConnections();
                        if (!incomingConnections.contains(connection) || !(connection instanceof FreeFormConnection)) continue;
                        retList.add((FreeFormConnection)connection);
                    }
                }
            }
        }
        return retList.toArray(ret);
    }

    private FreeFormConnection[] calculateConnectedConnections(IMoveShapeContext context) {
        ArrayList<FreeFormConnection> retList = new ArrayList<FreeFormConnection>();
        Shape shapeToMove = context.getShape();
        int x = context.getX();
        int y = context.getY();
        int deltaX = x - shapeToMove.getGraphicsAlgorithm().getX();
        int deltaY = y - shapeToMove.getGraphicsAlgorithm().getY();
        if (deltaX != 0 || deltaY != 0) {
            List<Anchor> anchors = this.getAnchors(shapeToMove);
            PictogramElement[] selectedPictogramElements = this.getDiagramBehavior().getDiagramContainer().getSelectedPictogramElements();
            if (selectedPictogramElements != null) {
                int i = 0;
                while (i < selectedPictogramElements.length) {
                    PictogramElement selPe = selectedPictogramElements[i];
                    if (selPe instanceof Shape) {
                        Shape selShape = (Shape)selPe;
                        for (Anchor toAnchor : this.getAnchors(selShape)) {
                            EList incomingConnections = toAnchor.getIncomingConnections();
                            for (Connection inConn : incomingConnections) {
                                Anchor startAnchor;
                                if (!(inConn instanceof FreeFormConnection) || !anchors.contains(startAnchor = inConn.getStart())) continue;
                                retList.add((FreeFormConnection)inConn);
                            }
                        }
                    }
                    ++i;
                }
            }
        }
        return retList.toArray(new FreeFormConnection[0]);
    }

    private void moveAllBendpointsOnFFConnection(FreeFormConnection connection, int deltaX, int deltaY) {
        EList points = connection.getBendpoints();
        int i = 0;
        while (i < points.size()) {
            Point point = (Point)points.get(i);
            int oldX = point.getX();
            int oldY = point.getY();
            points.set(i, Graphiti.getGaCreateService().createPoint(oldX + deltaX, oldY + deltaY));
            ++i;
        }
    }

    private List<Anchor> getAnchors(Shape theShape) {
        ArrayList<Anchor> ret = new ArrayList<Anchor>();
        ret.addAll((Collection<Anchor>)theShape.getAnchors());
        if (theShape instanceof ContainerShape) {
            ContainerShape containerShape = (ContainerShape)theShape;
            EList children = containerShape.getChildren();
            for (Shape shape : children) {
                if (shape instanceof ContainerShape) {
                    ret.addAll(this.getAnchors((Shape)((ContainerShape)shape)));
                    continue;
                }
                ret.addAll((Collection<Anchor>)shape.getAnchors());
            }
        }
        return ret;
    }
}

