/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.proxy.core;

import java.lang.reflect.InvocationTargetException;
import java.util.logging.Level;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ProgressMonitorWrapper;
import org.eclipse.jem.internal.proxy.core.IUIRunner;
import org.eclipse.jem.internal.proxy.core.ProxyLaunchSupport;
import org.eclipse.jem.internal.proxy.core.ProxyPlugin;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

class UIRunner
implements IUIRunner {
    UIRunner() {
    }

    public void handleBuild(final IProgressMonitor pm) throws CoreException {
        if (!PlatformUI.isWorkbenchRunning() || Display.getCurrent() == null) {
            ProxyLaunchSupport.runBuild(pm);
        } else {
            pm.beginTask("", 100);
            try {
                PlatformUI.getWorkbench().getProgressService().busyCursorWhile(new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        UIRunnerProgressMonitor uipm = new UIRunnerProgressMonitor(pm, monitor);
                        try {
                            ProxyLaunchSupport.runBuild((IProgressMonitor)uipm);
                        }
                        catch (CoreException e) {
                            throw new InvocationTargetException(e);
                        }
                        if (uipm.isCanceled()) {
                            pm.setCanceled(true);
                            throw new InterruptedException();
                        }
                    }
                });
            }
            catch (InvocationTargetException e) {
                if (e.getCause() instanceof CoreException) {
                    throw (CoreException)e.getCause();
                }
                ProxyPlugin.getPlugin().getLogger().log(e.getCause(), Level.WARNING);
            }
            catch (InterruptedException interruptedException) {}
            pm.done();
        }
    }

    private static class UIRunnerProgressMonitor
    extends ProgressMonitorWrapper {
        private IProgressMonitor pmcancel;

        public UIRunnerProgressMonitor(IProgressMonitor pmcancel, IProgressMonitor pmmain) {
            super(pmmain);
            this.pmcancel = pmcancel;
        }

        public boolean isCanceled() {
            return this.pmcancel.isCanceled() || super.isCanceled();
        }

        public void setCanceled(boolean value) {
            super.setCanceled(value);
            this.pmcancel.setCanceled(value);
        }
    }
}

