/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.proxy.remote;

import org.eclipse.jem.internal.proxy.common.remote.Commands;
import org.eclipse.jem.internal.proxy.core.IBeanProxy;
import org.eclipse.jem.internal.proxy.core.IBeanTypeProxy;
import org.eclipse.jem.internal.proxy.core.IIntegerBeanProxy;
import org.eclipse.jem.internal.proxy.remote.REMConstantBeanProxy;
import org.eclipse.jem.internal.proxy.remote.REMProxyFactoryRegistry;
import org.eclipse.jem.internal.proxy.remote.REMStandardBeanTypeProxyFactory;

class REMIntegerTypeBeanProxy
extends REMConstantBeanProxy
implements IIntegerBeanProxy {
    private final int fInt;

    REMIntegerTypeBeanProxy(REMProxyFactoryRegistry aRegistry, int anInt) {
        super(aRegistry);
        this.fInt = anInt;
    }

    public boolean equals(Object anObject) {
        if (this == anObject) {
            return true;
        }
        if (anObject instanceof REMIntegerTypeBeanProxy) {
            return this.fInt == ((REMIntegerTypeBeanProxy)anObject).intValue();
        }
        if (anObject instanceof Integer) {
            return this.fInt == (Integer)anObject;
        }
        return false;
    }

    public boolean sameAs(IBeanProxy aBeanProxy) {
        if (this == aBeanProxy) {
            return true;
        }
        if (aBeanProxy instanceof REMIntegerTypeBeanProxy) {
            return this.fInt == ((REMIntegerTypeBeanProxy)aBeanProxy).intValue();
        }
        return false;
    }

    public byte byteValue() {
        return (byte)this.fInt;
    }

    public double doubleValue() {
        return this.fInt;
    }

    public float floatValue() {
        return this.fInt;
    }

    public int intValue() {
        return this.fInt;
    }

    public long longValue() {
        return this.fInt;
    }

    public Number numberValue() {
        return new Integer(this.fInt);
    }

    public short shortValue() {
        return (short)this.fInt;
    }

    public String toBeanString() {
        return String.valueOf(this.fInt);
    }

    public IBeanTypeProxy getTypeProxy() {
        return ((REMStandardBeanTypeProxyFactory)this.fFactory.getBeanTypeProxyFactory()).intType;
    }

    public void renderBean(Commands.ValueObject value) {
        value.set(this.fInt);
    }
}

