/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.ui.internal.wizards.schemagen;

import java.util.Iterator;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.JavaElementComparator;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jdt.ui.ProblemsLabelDecorator;
import org.eclipse.jdt.ui.StandardJavaElementContentProvider;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jpt.common.ui.internal.WorkbenchTools;
import org.eclipse.jpt.common.utility.internal.ArrayTools;
import org.eclipse.jpt.jaxb.core.internal.gen.SchemaGenerator;
import org.eclipse.jpt.jaxb.ui.JptJaxbUiMessages;
import org.eclipse.jpt.jaxb.ui.internal.filters.ContainerFilter;
import org.eclipse.jpt.jaxb.ui.internal.filters.EmptyInnerPackageFilter;
import org.eclipse.jpt.jaxb.ui.internal.filters.NonArchiveOrExternalElementFilter;
import org.eclipse.jpt.jaxb.ui.internal.filters.NonContainerFilter;
import org.eclipse.jpt.jaxb.ui.internal.filters.NonJavaElementFilter;
import org.eclipse.jpt.jaxb.ui.internal.wizards.schemagen.AbstractJarDestinationWizardPage;
import org.eclipse.jpt.jaxb.ui.internal.wizards.schemagen.CheckboxTreeAndListGroup;
import org.eclipse.jpt.jaxb.ui.internal.wizards.schemagen.SchemaGeneratorWizard;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.osgi.framework.Bundle;

public class SchemaGeneratorWizardPage
extends AbstractJarDestinationWizardPage {
    private IJavaProject targetProject;
    private SettingsGroup settingsGroup;
    private NonContainerFilter projectFilter;
    private Button usesMoxyCheckBox;
    private boolean usesMoxy;
    public static String JPT_ECLIPSELINK_UI_PLUGIN_ID = "org.eclipse.jpt.jpa.eclipselink.ui";
    private static final int SIZING_SELECTION_WIDGET_WIDTH = 480;
    private static final int SIZING_SELECTION_WIDGET_HEIGHT = 150;
    public static final String HELP_CONTEXT_ID = "org.eclipse.jpt.jaxb.ui.wizard_jaxbschema_classes";

    public SchemaGeneratorWizardPage(IStructuredSelection selection) {
        super("JAXB Schema Generator", selection, null);
        this.setUsesMoxy(false);
        this.setTitle(JptJaxbUiMessages.SCHEMA_GENERATOR_WIZARD_PAGE_TITLE);
        this.setDescription(JptJaxbUiMessages.SCHEMA_GENERATOR_WIZARD_PAGE_DESC);
    }

    public void createControl(Composite parent) {
        this.setPageComplete(false);
        this.setControl(this.buildTopLevelControl(parent));
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.updateTargetProject();
            this.updateInputGroupTreeFilter();
            this.updateUsesMoxy(this.jptEclipseLinkBundleExists() && this.moxyIsOnClasspath());
            this.usesMoxyCheckBox.setVisible(this.jptEclipseLinkBundleExists() && !this.moxyIsOnClasspath());
            this.validateProjectClasspath();
        }
    }

    public boolean isPageComplete() {
        boolean complete = this.validateSourceGroup();
        if (complete) {
            this.validateProjectClasspath();
        }
        return complete;
    }

    public void setPreviousPage(IWizardPage page) {
        super.setPreviousPage(page);
        if (this.getControl() != null) {
            this.updatePageCompletion();
        }
    }

    protected Object[] getAllCheckedItems() {
        return ArrayTools.array((Iterator)this.getInputGroup().getAllCheckedListItems());
    }

    protected boolean usesMoxy() {
        return this.usesMoxy;
    }

    protected void updatePageCompletion() {
        super.updatePageCompletion();
    }

    protected boolean validateDestinationGroup() {
        return true;
    }

    protected boolean validateSourceGroup() {
        if (this.getAllCheckedItems().length == 0) {
            if (this.getErrorMessage() == null) {
                this.setErrorMessage(JptJaxbUiMessages.SCHEMA_GENERATOR_WIZARD_PAGE_ERROR_NO_PACKAGE);
            }
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }

    private void validateProjectClasspath() {
        if (this.targetProject == null) {
            return;
        }
        this.setMessage(null);
        if (!this.genericJaxbIsOnClasspath()) {
            this.displayWarning(JptJaxbUiMessages.SCHEMA_GENERATOR_WIZARD_PAGE_JAXB_LIBRARIES_NOT_AVAILABLE);
        } else if (this.usesMoxy() && !this.moxyIsOnClasspath()) {
            this.displayWarning(JptJaxbUiMessages.SCHEMA_GENERATOR_WIZARD_PAGE_MOXY_LIBRARIES_NOT_AVAILABLE);
        }
    }

    private boolean genericJaxbIsOnClasspath() {
        try {
            String className = SchemaGenerator.JAXB_GENERIC_SCHEMA_GEN_CLASS;
            IType genClass = this.targetProject.findType(className);
            return genClass != null;
        }
        catch (JavaModelException e) {
            throw new RuntimeException(e);
        }
    }

    private Control buildTopLevelControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        WorkbenchTools.setHelp((Control)composite, (String)HELP_CONTEXT_ID);
        this.settingsGroup = new SettingsGroup(composite);
        this.usesMoxyCheckBox = this.buildUsesMoxyCheckBox(composite);
        Dialog.applyDialogFont((Control)parent);
        return composite;
    }

    private void updateTargetProject() {
        this.targetProject = ((SchemaGeneratorWizard)this.getWizard()).getJavaProject();
    }

    private void updateInputGroupTreeFilter() {
        this.getInputGroup().setAllSelections(false);
        if (this.projectFilter != null) {
            this.getInputGroup().removeTreeFilter(this.projectFilter);
        }
        this.projectFilter = new NonContainerFilter(this.targetProject.getProject().getName());
        this.getInputGroup().addTreeFilter(this.projectFilter);
    }

    private boolean jptEclipseLinkBundleExists() {
        return this.getJptEclipseLinkBundle() != null;
    }

    private Bundle getJptEclipseLinkBundle() {
        return Platform.getBundle((String)JPT_ECLIPSELINK_UI_PLUGIN_ID);
    }

    private void setUsesMoxy(boolean usesMoxy) {
        this.usesMoxy = usesMoxy;
    }

    private void updateUsesMoxy(boolean usesMoxy) {
        this.setUsesMoxy(usesMoxy);
        this.usesMoxyCheckBox.setSelection(this.usesMoxy());
        this.validateProjectClasspath();
    }

    private boolean moxyIsOnClasspath() {
        try {
            String className = SchemaGenerator.JAXB_ECLIPSELINK_SCHEMA_GEN_CLASS;
            IType genClass = this.targetProject.findType(className);
            return genClass != null;
        }
        catch (JavaModelException e) {
            throw new RuntimeException(e);
        }
    }

    private void displayWarning(String message) {
        this.setMessage(message, 2);
    }

    private CheckboxTreeAndListGroup getInputGroup() {
        return this.settingsGroup.inputGroup;
    }

    protected Iterator<?> getSelectedResourcesIterator() {
        return this.getInputGroup().getAllCheckedListItems();
    }

    protected void update() {
        this.updatePageCompletion();
    }

    public final void saveWidgetValues() {
    }

    protected void internalSaveWidgetValues() {
    }

    protected void restoreWidgetValues() {
    }

    protected void initializeJarPackage() {
    }

    protected void giveFocusToDestination() {
    }

    private Button buildUsesMoxyCheckBox(Composite parent) {
        Button checkBox = new Button(parent, 32);
        GridData gridData = new GridData();
        gridData.verticalIndent = 10;
        checkBox.setLayoutData((Object)gridData);
        checkBox.setText(JptJaxbUiMessages.CLASSES_GENERATOR_WIZARD_PAGE_USES_MOXY_IMPLEMENTATION);
        checkBox.setSelection(this.usesMoxy());
        checkBox.addSelectionListener(this.buildUsesMoxySelectionListener());
        return checkBox;
    }

    private SelectionListener buildUsesMoxySelectionListener() {
        return new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
                this.widgetSelected(event);
            }

            public void widgetSelected(SelectionEvent event) {
                SchemaGeneratorWizardPage.this.updateUsesMoxy(SchemaGeneratorWizardPage.this.usesMoxyCheckBox.getSelection());
                SchemaGeneratorWizardPage.this.validateProjectClasspath();
            }
        };
    }

    private class SettingsGroup {
        private CheckboxTreeAndListGroup inputGroup;

        private SettingsGroup(Composite parent) {
            SchemaGeneratorWizardPage.this.initializeDialogUnits((Control)parent);
            Composite composite = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            composite.setLayout((Layout)layout);
            composite.setLayoutData((Object)new GridData(768));
            this.buildSchemaComposite(composite);
            SchemaGeneratorWizardPage.this.createPlainLabel(composite, JptJaxbUiMessages.SCHEMA_GENERATOR_WIZARD_PAGE_PACKAGES);
            this.inputGroup = this.createInputGroup(composite);
        }

        protected void buildSchemaComposite(Composite parent) {
            Composite composite = new Composite(parent, 0);
            GridLayout layout = new GridLayout(3, false);
            layout.marginWidth = 0;
            layout.marginTop = 0;
            layout.marginBottom = 10;
            composite.setLayout((Layout)layout);
            composite.setLayoutData((Object)new GridData(768));
        }

        protected CheckboxTreeAndListGroup createInputGroup(Composite parent) {
            int labelFlags = 272;
            StandardJavaElementContentProvider treeContentProvider = new StandardJavaElementContentProvider(){

                public boolean hasChildren(Object element) {
                    return !(element instanceof IPackageFragment) && super.hasChildren(element);
                }
            };
            DecoratingLabelProvider provider = new DecoratingLabelProvider((ILabelProvider)new JavaElementLabelProvider(labelFlags), (ILabelDecorator)new ProblemsLabelDecorator(null));
            CheckboxTreeAndListGroup checkboxTreeGroup = new CheckboxTreeAndListGroup(parent, JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot()), (ITreeContentProvider)treeContentProvider, (ILabelProvider)provider, (IStructuredContentProvider)new StandardJavaElementContentProvider(), (ILabelProvider)provider, 0, 480, 150);
            checkboxTreeGroup.addTreeFilter(new EmptyInnerPackageFilter());
            checkboxTreeGroup.setTreeComparator((ViewerComparator)new JavaElementComparator());
            checkboxTreeGroup.setListComparator((ViewerComparator)new JavaElementComparator());
            checkboxTreeGroup.addTreeFilter(new NonJavaElementFilter());
            checkboxTreeGroup.addTreeFilter(new NonArchiveOrExternalElementFilter());
            checkboxTreeGroup.addListFilter(new ContainerFilter());
            checkboxTreeGroup.addListFilter(new NonJavaElementFilter());
            checkboxTreeGroup.getTree().addListener(4, (Listener)SchemaGeneratorWizardPage.this);
            checkboxTreeGroup.getTable().addListener(4, (Listener)SchemaGeneratorWizardPage.this);
            ICheckStateListener listener = new ICheckStateListener(){

                public void checkStateChanged(CheckStateChangedEvent event) {
                    SchemaGeneratorWizardPage.this.update();
                }
            };
            checkboxTreeGroup.addCheckStateListener(listener);
            return checkboxTreeGroup;
        }
    }
}

