/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jpt.common.core.AnnotationProvider;
import org.eclipse.jpt.common.core.JptResourceType;
import org.eclipse.jpt.common.core.utility.jdt.AnnotationEditFormatter;
import org.eclipse.jpt.common.utility.internal.predicate.PredicateAdapter;
import org.eclipse.jpt.common.utility.predicate.Predicate;
import org.eclipse.jpt.jpa.core.JpaEntityGeneratorDatabaseAnnotationNameBuilder;
import org.eclipse.jpt.jpa.core.JpaFactory;
import org.eclipse.jpt.jpa.core.JpaFile;
import org.eclipse.jpt.jpa.core.JpaPlatformVariation;
import org.eclipse.jpt.jpa.core.JpaProject;
import org.eclipse.jpt.jpa.core.JpaResourceDefinition;
import org.eclipse.jpt.jpa.core.context.java.DefaultJavaAttributeMappingDefinition;
import org.eclipse.jpt.jpa.core.context.java.JavaAttributeMappingDefinition;
import org.eclipse.jpt.jpa.core.context.java.JavaManagedTypeDefinition;
import org.eclipse.jpt.jpa.core.context.java.JavaTypeMappingDefinition;
import org.eclipse.jpt.jpa.core.platform.JpaPlatformManager;
import org.eclipse.jpt.jpa.db.ConnectionProfileFactory;
import org.eclipse.persistence.jpa.jpql.parser.JPQLGrammar;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;

public interface JpaPlatform
extends IAdaptable {
    public String getId();

    public Config getConfig();

    public Version getJpaVersion();

    public JpaFactory getJpaFactory();

    public JpaFile buildJpaFile(JpaProject var1, IFile var2);

    public IContentType getContentType(IFile var1);

    public Iterable<JavaManagedTypeDefinition> getJavaManagedTypeDefinitions();

    public AnnotationProvider getAnnotationProvider();

    public AnnotationEditFormatter getAnnotationEditFormatter();

    public Iterable<JavaTypeMappingDefinition> getJavaTypeMappingDefinitions();

    public Iterable<JavaAttributeMappingDefinition> getSpecifiedJavaAttributeMappingDefinitions();

    public Iterable<DefaultJavaAttributeMappingDefinition> getDefaultJavaAttributeMappingDefinitions();

    public boolean supportsResourceType(JptResourceType var1);

    public JpaResourceDefinition getResourceDefinition(JptResourceType var1);

    public JptResourceType getMostRecentSupportedResourceType(IContentType var1);

    public ConnectionProfileFactory getConnectionProfileFactory();

    public JpaEntityGeneratorDatabaseAnnotationNameBuilder getEntityGeneratorDatabaseAnnotationNameBuilder();

    public JpaPlatformVariation getJpaVariation();

    public JPQLGrammar getJpqlGrammar();

    public static interface Config {
        public static final Predicate<Config> IS_DEFAULT = new IsDefault();

        public JpaPlatformManager getJpaPlatformManager();

        public String getId();

        public String getLabel();

        public IProjectFacetVersion getJpaFacetVersion();

        public boolean supportsJpaFacetVersion(IProjectFacetVersion var1);

        public boolean isDefault();

        public GroupConfig getGroupConfig();

        public String getPluginId();

        public JpaPlatform getJpaPlatform();

        public static class IsDefault
        extends PredicateAdapter<Config> {
            public boolean evaluate(Config config) {
                return config.isDefault();
            }
        }
    }

    public static interface GroupConfig {
        public JpaPlatformManager getJpaPlatformManager();

        public String getId();

        public String getLabel();

        public Iterable<Config> getJpaPlatformConfigs();

        public String getPluginId();
    }

    public static interface Version {
        public String getVersion();

        public String getJpaVersion();

        public boolean isCompatibleWithJpaVersion(String var1);
    }
}

