/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.context.orm;

import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jpt.common.core.internal.utility.JavaProjectTools;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.iterable.EmptyIterable;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.internal.iterable.SingleElementIterable;
import org.eclipse.jpt.common.utility.transformer.Transformer;
import org.eclipse.jpt.jpa.core.context.AttributeMapping;
import org.eclipse.jpt.jpa.core.context.Entity;
import org.eclipse.jpt.jpa.core.context.FetchType;
import org.eclipse.jpt.jpa.core.context.PersistentAttribute;
import org.eclipse.jpt.jpa.core.context.PersistentType;
import org.eclipse.jpt.jpa.core.context.RelationshipMapping;
import org.eclipse.jpt.jpa.core.context.SpecifiedPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.TypeMapping;
import org.eclipse.jpt.jpa.core.context.orm.OrmMappingRelationship;
import org.eclipse.jpt.jpa.core.context.orm.OrmRelationshipMapping;
import org.eclipse.jpt.jpa.core.context.orm.OrmSpecifiedPersistentAttribute;
import org.eclipse.jpt.jpa.core.internal.context.orm.AbstractOrmAttributeMapping;
import org.eclipse.jpt.jpa.core.internal.jpa1.context.orm.GenericOrmCascade;
import org.eclipse.jpt.jpa.core.jpa2.context.MetamodelField2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.PersistentType2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.RelationshipMapping2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.orm.OrmCascade2_0;
import org.eclipse.jpt.jpa.core.resource.orm.AbstractXmlRelationshipMapping;
import org.eclipse.jpt.jpa.core.validation.JptJpaCoreValidationMessages;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

public abstract class AbstractOrmRelationshipMapping<X extends AbstractXmlRelationshipMapping>
extends AbstractOrmAttributeMapping<X>
implements OrmRelationshipMapping,
RelationshipMapping2_0 {
    protected String specifiedTargetEntity;
    protected String defaultTargetEntity;
    protected String fullyQualifiedTargetEntity;
    protected final OrmMappingRelationship relationship;
    protected final OrmCascade2_0 cascade;
    protected FetchType specifiedFetch;
    protected FetchType defaultFetch;

    protected AbstractOrmRelationshipMapping(OrmSpecifiedPersistentAttribute parent, X xmlMapping) {
        super(parent, xmlMapping);
        this.specifiedTargetEntity = ((AbstractXmlRelationshipMapping)xmlMapping).getTargetEntity();
        this.relationship = this.buildRelationship();
        this.cascade = this.buildCascade();
        this.specifiedFetch = this.buildSpecifiedFetch();
    }

    @Override
    public void synchronizeWithResourceModel(IProgressMonitor monitor) {
        super.synchronizeWithResourceModel(monitor);
        this.setSpecifiedTargetEntity_(((AbstractXmlRelationshipMapping)this.xmlAttributeMapping).getTargetEntity());
        this.relationship.synchronizeWithResourceModel(monitor);
        this.cascade.synchronizeWithResourceModel(monitor);
        this.setSpecifiedFetch_(this.buildSpecifiedFetch());
    }

    @Override
    public void update(IProgressMonitor monitor) {
        super.update(monitor);
        this.setDefaultTargetEntity(this.buildDefaultTargetEntity());
        this.setFullyQualifiedTargetEntity(this.buildFullyQualifiedTargetEntity());
        this.relationship.update(monitor);
        this.cascade.update(monitor);
        this.setDefaultFetch(this.buildDefaultFetch());
    }

    @Override
    public String getFullyQualifiedTargetEntity() {
        return this.fullyQualifiedTargetEntity;
    }

    protected void setFullyQualifiedTargetEntity(String entity) {
        String old = this.fullyQualifiedTargetEntity;
        this.fullyQualifiedTargetEntity = entity;
        this.firePropertyChanged("fullyQualifiedTargetEntity", old, entity);
    }

    protected String buildFullyQualifiedTargetEntity() {
        return this.specifiedTargetEntity == null ? this.defaultTargetEntity : this.getEntityMappings().qualify(this.specifiedTargetEntity);
    }

    @Override
    public String getTargetEntity() {
        return this.specifiedTargetEntity != null ? this.specifiedTargetEntity : this.defaultTargetEntity;
    }

    @Override
    public String getSpecifiedTargetEntity() {
        return this.specifiedTargetEntity;
    }

    @Override
    public void setSpecifiedTargetEntity(String entity) {
        this.setSpecifiedTargetEntity_(entity);
        ((AbstractXmlRelationshipMapping)this.xmlAttributeMapping).setTargetEntity(entity);
    }

    protected void setSpecifiedTargetEntity_(String entity) {
        String old = this.specifiedTargetEntity;
        this.specifiedTargetEntity = entity;
        this.firePropertyChanged("specifiedTargetEntity", old, entity);
    }

    @Override
    public String getDefaultTargetEntity() {
        return this.defaultTargetEntity;
    }

    protected void setDefaultTargetEntity(String entity) {
        String old = this.defaultTargetEntity;
        this.defaultTargetEntity = entity;
        this.firePropertyChanged("defaultTargetEntity", old, entity);
    }

    protected String buildDefaultTargetEntity() {
        return this.getJavaPersistentAttribute() == null ? null : this.getJavaTargetType();
    }

    protected abstract String getJavaTargetType();

    @Override
    public Entity getResolvedTargetEntity() {
        TypeMapping typeMapping = this.getResolvedTargetTypeMapping();
        return typeMapping instanceof Entity ? (Entity)typeMapping : null;
    }

    protected TypeMapping getResolvedTargetTypeMapping() {
        PersistentType targetType = this.getResolvedTargetType();
        return targetType == null ? null : targetType.getMapping();
    }

    public PersistentType getResolvedTargetType() {
        return this.fullyQualifiedTargetEntity == null ? null : this.getPersistenceUnit().getPersistentType(this.fullyQualifiedTargetEntity);
    }

    protected PersistentType2_0 getResolvedTargetType2_0() {
        return (PersistentType2_0)this.getResolvedTargetType();
    }

    @Override
    public char getTargetEntityEnclosingTypeSeparator() {
        return '$';
    }

    @Override
    public OrmMappingRelationship getRelationship() {
        return this.relationship;
    }

    protected abstract OrmMappingRelationship buildRelationship();

    @Override
    public OrmCascade2_0 getCascade() {
        return this.cascade;
    }

    protected OrmCascade2_0 buildCascade() {
        return new GenericOrmCascade(this);
    }

    @Override
    public FetchType getFetch() {
        return this.specifiedFetch != null ? this.specifiedFetch : this.defaultFetch;
    }

    @Override
    public FetchType getSpecifiedFetch() {
        return this.specifiedFetch;
    }

    @Override
    public void setSpecifiedFetch(FetchType fetch) {
        this.setSpecifiedFetch_(fetch);
        ((AbstractXmlRelationshipMapping)this.xmlAttributeMapping).setFetch(FetchType.toOrmResourceModel(fetch));
    }

    protected void setSpecifiedFetch_(FetchType fetch) {
        FetchType old = this.specifiedFetch;
        this.specifiedFetch = fetch;
        this.firePropertyChanged("specifiedFetch", (Object)old, (Object)fetch);
    }

    protected FetchType buildSpecifiedFetch() {
        return FetchType.fromOrmResourceModel(((AbstractXmlRelationshipMapping)this.xmlAttributeMapping).getFetch());
    }

    @Override
    public FetchType getDefaultFetch() {
        return this.defaultFetch;
    }

    protected void setDefaultFetch(FetchType fetch) {
        FetchType old = this.defaultFetch;
        this.defaultFetch = fetch;
        this.firePropertyChanged("defaultFetch", (Object)old, (Object)fetch);
    }

    protected abstract FetchType buildDefaultFetch();

    @Override
    public boolean isRelationshipOwner() {
        return this.relationship.isOwner();
    }

    @Override
    public boolean isOwnedBy(AttributeMapping mapping) {
        return mapping.isRelationshipOwner() && this.relationship.isOwnedBy((RelationshipMapping)mapping);
    }

    @Override
    public RelationshipMapping getRelationshipOwner() {
        Entity entity = this.getResolvedTargetEntity();
        if (entity == null) {
            return null;
        }
        for (PersistentAttribute attribute : entity.getPersistentType().getAllAttributes()) {
            AttributeMapping mapping = attribute.getMapping();
            if (!this.isOwnedBy(mapping)) continue;
            return (RelationshipMapping)mapping;
        }
        return null;
    }

    @Override
    public boolean isOverridableAssociationMapping() {
        return this.relationship.isOverridable();
    }

    @Override
    protected void initializeFromOrmRelationshipMapping(OrmRelationshipMapping oldMapping) {
        super.initializeFromOrmRelationshipMapping(oldMapping);
        this.setSpecifiedTargetEntity(oldMapping.getSpecifiedTargetEntity());
        this.setSpecifiedFetch(oldMapping.getSpecifiedFetch());
        this.relationship.initializeFrom(oldMapping.getRelationship());
        this.cascade.initializeFrom(oldMapping.getCascade());
    }

    @Override
    public Iterable<String> getAllTargetEntityAttributeNames() {
        return IterableTools.children(this.getAllTargetEntityAttributeMappings(), (Transformer)ALL_MAPPING_NAMES_TRANSFORMER);
    }

    protected Iterable<AttributeMapping> getAllTargetEntityAttributeMappings() {
        Entity entity = this.getResolvedTargetEntity();
        return entity != null ? entity.getAllAttributeMappings() : EmptyIterable.instance();
    }

    @Override
    public Iterable<String> getTargetEntityNonTransientAttributeNames() {
        return IterableTools.children(this.getNonTransientTargetEntityAttributeMappings(), (Transformer)ALL_MAPPING_NAMES_TRANSFORMER);
    }

    protected Iterable<AttributeMapping> getNonTransientTargetEntityAttributeMappings() {
        Entity entity = this.getResolvedTargetEntity();
        return entity != null ? entity.getNonTransientAttributeMappings() : EmptyIterable.instance();
    }

    protected String getTargetEntityIdAttributeName() {
        SpecifiedPersistentAttribute attribute = this.getTargetEntityIdAttribute();
        return attribute == null ? null : attribute.getName();
    }

    protected SpecifiedPersistentAttribute getTargetEntityIdAttribute() {
        Entity entity = this.getResolvedTargetEntity();
        return entity == null ? null : entity.getIdAttribute();
    }

    @Override
    public Iterable<ReplaceEdit> createRenameTypeEdits(IType originalType, String newName) {
        return IterableTools.concatenate((Iterable[])new Iterable[]{super.createRenameTypeEdits(originalType, newName), this.createTargetEntityRenameTypeEdits(originalType, newName)});
    }

    protected Iterable<ReplaceEdit> createTargetEntityRenameTypeEdits(IType originalType, String newName) {
        PersistentType targetType;
        if (this.specifiedTargetEntity != null && (targetType = this.getResolvedTargetType()) != null && targetType.isFor(originalType.getFullyQualifiedName('.'))) {
            return new SingleElementIterable((Object)this.createTargetEntityRenameTypeEdit(originalType, newName));
        }
        return EmptyIterable.instance();
    }

    protected ReplaceEdit createTargetEntityRenameTypeEdit(IType originalType, String newName) {
        return ((AbstractXmlRelationshipMapping)this.xmlAttributeMapping).createRenameTargetEntityEdit(originalType, newName);
    }

    @Override
    public Iterable<ReplaceEdit> createMoveTypeEdits(IType originalType, IPackageFragment newPackage) {
        return IterableTools.concatenate((Iterable[])new Iterable[]{super.createMoveTypeEdits(originalType, newPackage), this.createTargetEntityMoveTypeEdits(originalType, newPackage)});
    }

    protected Iterable<ReplaceEdit> createTargetEntityMoveTypeEdits(IType originalType, IPackageFragment newPackage) {
        PersistentType targetType;
        if (this.specifiedTargetEntity != null && (targetType = this.getResolvedTargetType()) != null && targetType.isFor(originalType.getFullyQualifiedName('.'))) {
            return new SingleElementIterable((Object)this.createTargetEntityRenamePackageEdit(newPackage.getElementName()));
        }
        return EmptyIterable.instance();
    }

    @Override
    public Iterable<ReplaceEdit> createRenamePackageEdits(IPackageFragment originalPackage, String newName) {
        return IterableTools.concatenate((Iterable[])new Iterable[]{super.createRenamePackageEdits(originalPackage, newName), this.createTargetEntityRenamePackageEdits(originalPackage, newName)});
    }

    protected Iterable<ReplaceEdit> createTargetEntityRenamePackageEdits(IPackageFragment originalPackage, String newName) {
        PersistentType targetType;
        if (this.specifiedTargetEntity != null && (targetType = this.getResolvedTargetType()) != null && targetType.isIn(originalPackage)) {
            return new SingleElementIterable((Object)this.createTargetEntityRenamePackageEdit(newName));
        }
        return EmptyIterable.instance();
    }

    protected ReplaceEdit createTargetEntityRenamePackageEdit(String newName) {
        return ((AbstractXmlRelationshipMapping)this.xmlAttributeMapping).createRenameTargetEntityPackageEdit(newName);
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        this.validateTargetEntity(messages);
        this.relationship.validate(messages, reporter);
    }

    protected void validateTargetEntity(List<IMessage> messages) {
        if (StringTools.isBlank((String)this.getTargetEntity())) {
            messages.add(this.buildValidationMessage(this.getTargetEntityTextRange(), JptJpaCoreValidationMessages.TARGET_ENTITY_NOT_DEFINED));
            return;
        }
        if (this.getResolvedTargetType() == null) {
            IType jdtType = JavaProjectTools.findType((IJavaProject)this.getJavaProject(), (String)this.getFullyQualifiedTargetEntity());
            if (jdtType == null) {
                messages.add(this.buildValidationMessage(this.getTargetEntityTextRange(), JptJpaCoreValidationMessages.TARGET_ENTITY_NOT_EXIST, this.getFullyQualifiedTargetEntity()));
            }
            return;
        }
        if (this.getResolvedTargetEntity() == null) {
            messages.add(this.buildValidationMessage(this.getTargetEntityTextRange(), JptJpaCoreValidationMessages.TARGET_ENTITY_IS_NOT_AN_ENTITY, this.getFullyQualifiedTargetEntity()));
        }
    }

    protected TextRange getTargetEntityTextRange() {
        return this.getValidationTextRange(((AbstractXmlRelationshipMapping)this.xmlAttributeMapping).getTargetEntityTextRange());
    }

    @Override
    public String getMetamodelTypeName() {
        PersistentType2_0 targetType = this.getResolvedTargetType2_0();
        if (targetType == null) {
            return MetamodelField2_0.DEFAULT_TYPE_NAME;
        }
        return (targetType = targetType.getMetamodelType()) != null ? targetType.getName() : MetamodelField2_0.DEFAULT_TYPE_NAME;
    }

    @Override
    public Iterable<String> getCompletionProposals(int pos) {
        Iterable<String> result = super.getCompletionProposals(pos);
        if (result != null) {
            return result;
        }
        result = this.relationship.getCompletionProposals(pos);
        if (result != null) {
            return result;
        }
        if (this.targetEntityTouches(pos)) {
            return this.getCandidateTargetEntityClassNames();
        }
        return null;
    }

    protected boolean targetEntityTouches(int pos) {
        return ((AbstractXmlRelationshipMapping)this.xmlAttributeMapping).targetEntityTouches(pos);
    }

    protected Iterable<String> getCandidateTargetEntityClassNames() {
        return JavaProjectTools.getJavaClassNames((IJavaProject)this.getJavaProject());
    }
}

