/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpadiagrameditor.ui.internal.relations;

import org.eclipse.jpt.jpa.core.context.PersistentAttribute;
import org.eclipse.jpt.jpa.core.context.PersistentType;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.propertypage.JPADiagramPropertyPage;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.provider.IJPAEditorFeatureProvider;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.relations.IBidirectionalRelation;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.relations.IRelation;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.relations.ManyToManyRelation;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.JPAEditorUtil;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.JpaArtifactFactory;

public class ManyToManyBiDirRelation
extends ManyToManyRelation
implements IBidirectionalRelation {
    public ManyToManyBiDirRelation(IJPAEditorFeatureProvider fp, PersistentType owner, PersistentType inverse, String ownerAttributeName, String inverseAttributeName, boolean createAttribs, PersistentType embeddingEntity) {
        super(owner, inverse);
        this.ownerAttributeName = ownerAttributeName;
        this.inverseAttributeName = inverseAttributeName;
        if (createAttribs) {
            this.createRelation(fp, embeddingEntity);
        }
    }

    @Override
    public PersistentAttribute getOwnerAnnotatedAttribute() {
        return this.ownerAnnotatedAttribute;
    }

    @Override
    public void setOwnerAnnotatedAttribute(PersistentAttribute ownerAnnotatedAttribute) {
        this.ownerAnnotatedAttribute = ownerAnnotatedAttribute;
    }

    @Override
    public PersistentAttribute getInverseAnnotatedAttribute() {
        return this.inverseAnnotatedAttribute;
    }

    @Override
    public void setInverseAnnotatedAttribute(PersistentAttribute inverseAnnotatedAttribute) {
        this.inverseAnnotatedAttribute = inverseAnnotatedAttribute;
    }

    private void createRelation(IJPAEditorFeatureProvider fp, PersistentType embeddingEntity) {
        boolean isMap = JPADiagramPropertyPage.isMapType(this.owner.getJpaProject().getProject());
        String mapKeyType = this.getMapKeyType(isMap, this.inverse, embeddingEntity);
        this.ownerAnnotatedAttribute = JPAEditorUtil.addAnnotatedAttribute(this.owner, this.inverse, true, mapKeyType);
        mapKeyType = this.getMapKeyType(isMap, this.owner, embeddingEntity);
        this.inverseAnnotatedAttribute = JpaArtifactFactory.instance().isEmbeddable(this.owner) ? JPAEditorUtil.addAnnotatedAttribute(this.inverse, embeddingEntity, true, mapKeyType) : JPAEditorUtil.addAnnotatedAttribute(this.inverse, this.owner, true, mapKeyType);
        JpaArtifactFactory.instance().addManyToManyBidirectionalRelation(fp, this.owner, this.ownerAnnotatedAttribute, this.inverse, this.inverseAnnotatedAttribute, isMap);
    }

    @Override
    public IRelation.RelDir getRelDir() {
        return IRelation.RelDir.BI;
    }

    private String getMapKeyType(boolean isMap, PersistentType jpt, PersistentType embeddingEntity) {
        if (JpaArtifactFactory.instance().isEmbeddable(jpt) && embeddingEntity != null) {
            return isMap ? JpaArtifactFactory.instance().getIdType(embeddingEntity) : null;
        }
        return isMap ? JpaArtifactFactory.instance().getIdType(jpt) : null;
    }
}

