/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jee.ejb.validation.internal;

import java.text.MessageFormat;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jst.j2ee.model.ModelProviderManager;
import org.eclipse.jst.j2ee.project.JavaEEProjectUtilities;
import org.eclipse.jst.javaee.ejb.EJBJar;
import org.eclipse.jst.javaee.ejb.EnterpriseBeans;
import org.eclipse.jst.jee.ejb.Activator;
import org.eclipse.jst.jee.ejb.validation.internal.Messages;
import org.eclipse.wst.validation.AbstractValidator;
import org.eclipse.wst.validation.ValidationEvent;
import org.eclipse.wst.validation.ValidationResult;
import org.eclipse.wst.validation.ValidationState;
import org.eclipse.wst.validation.Validator;
import org.eclipse.wst.validation.ValidatorMessage;
import org.eclipse.wst.validation.internal.MarkerManager;
import org.eclipse.wst.validation.internal.ValManager;
import org.eclipse.wst.validation.internal.ValOperation;

public class UIEJB3Validator
extends AbstractValidator {
    private static final String NO_BEANS_MESSAGE = "org.eclipse.jst.jee.ejb3.nobeansmessage";
    public static String ID = "org.eclipse.jst.jee.ejb3.validator";
    public static String MARKER_ID_NO_BEANS = "org.eclipse.jst.jee.ejb3.nobeans";

    public void validationStarting(IProject project, ValidationState state, IProgressMonitor monitor) {
        Validator v = ValManager.getDefault().getValidator(ID, project);
        if (project != null) {
            ValManager.getDefault().validate(v, new ValOperation(), (IResource)project, 0, (IProgressMonitor)new NullProgressMonitor(), null);
        }
    }

    public ValidationResult validate(IResource resource, int kind, ValidationState state, IProgressMonitor monitor) {
        if (resource == null || !IProject.class.isInstance(resource)) {
            return null;
        }
        IProject proj = (IProject)resource;
        try {
            MarkerManager.getDefault().clearMarker((IResource)proj, (Validator)this.getParent());
        }
        catch (CoreException e) {
            Activator.logError(e);
        }
        if (!JavaEEProjectUtilities.isEJBProject((IProject)proj)) {
            return null;
        }
        EJBJar ejbJar = (EJBJar)ModelProviderManager.getModelProvider((IProject)proj).getModelObject();
        EnterpriseBeans ebs = ejbJar.getEnterpriseBeans();
        if (ebs == null || ebs.getSessionBeans().size() + ebs.getMessageDrivenBeans().size() + ebs.getEntityBeans().size() == 0) {
            ValidationResult vRes = new ValidationResult();
            ValidatorMessage vMsg = UIEJB3Validator.createValidatorMessage(Messages.NO_BEANS_ERROR, (IResource)proj, this.getParent().getMessage(NO_BEANS_MESSAGE).getCurrent().getMarkerSeverity(), 2);
            vRes.add(vMsg);
            return vRes;
        }
        return null;
    }

    public ValidationResult validate(ValidationEvent event, ValidationState state, IProgressMonitor monitor) {
        IResource res = event.getResource();
        return this.validate(res, 0, state, monitor);
    }

    private static ValidatorMessage createValidatorMessage(String txt, IResource res, int severity, int priority) {
        ValidatorMessage msg = ValidatorMessage.create((String)txt, (IResource)res);
        msg.setAttribute("severity", severity);
        msg.setAttribute("priority", priority);
        msg.setAttribute("location", (Object)MessageFormat.format(Messages.NO_BEANS_ERROR_LOCATION, res.getName()));
        msg.setType(MARKER_ID_NO_BEANS);
        return msg;
    }
}

