/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.common.metadata.internal;

import org.eclipse.jst.jsf.common.metadata.Model;
import org.eclipse.jst.jsf.common.metadata.internal.IDomainLoadingStrategy;
import org.eclipse.jst.jsf.common.metadata.internal.IMetaDataModelContext;
import org.eclipse.jst.jsf.common.metadata.internal.ModelKeyDescriptor;
import org.eclipse.jst.jsf.common.metadata.internal.ModelNotSetException;
import org.eclipse.jst.jsf.common.metadata.internal.StandardModelFactory;

public class MetaDataModel {
    private Object root;
    private IMetaDataModelContext modelContext;
    private ModelKeyDescriptor modelKeyDescriptor;
    private IDomainLoadingStrategy strategy;
    private boolean refresh;

    public MetaDataModel(IMetaDataModelContext context, IDomainLoadingStrategy strategy) {
        this.modelContext = context;
        this.strategy = strategy;
    }

    public Object getRoot() {
        return this.root;
    }

    public void setRoot(Object root) {
        this.root = root;
        if (root != null) {
            Model m = (Model)root;
            m.setCurrentModelContext(this.getModelKey());
        }
    }

    private ModelKeyDescriptor getModelKey() {
        if (this.modelKeyDescriptor == null) {
            this.modelKeyDescriptor = (ModelKeyDescriptor)this.modelContext.getAdapter(ModelKeyDescriptor.class);
        }
        return this.modelKeyDescriptor;
    }

    public IMetaDataModelContext getModelContext() {
        return this.modelContext;
    }

    public boolean isEmpty() {
        return this.root == null || !(this.root instanceof Model);
    }

    public synchronized void load() {
        StandardModelFactory.debug("> Begin Loading: " + this.modelContext.toString(), StandardModelFactory.DEBUG_MD_LOAD);
        this.strategy.load(this);
        StandardModelFactory.debug("> End Loading: " + this.modelContext.toString(), StandardModelFactory.DEBUG_MD_LOAD);
    }

    public void reload() throws ModelNotSetException {
        this.setRoot(null);
        this.refresh = false;
        this.strategy.reload();
    }

    public boolean needsRefresh() {
        return this.refresh;
    }

    public void setNeedsRefresh() {
        this.refresh = true;
    }

    public void cleanup() {
        if (this.strategy != null) {
            this.strategy.cleanup();
        }
        this.strategy = null;
        this.root = null;
        this.modelContext = null;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("MetaDataModel: ");
        buf.append(this.modelContext.toString());
        return buf.toString();
    }
}

