/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.businessprocess.treeoperations;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.jubula.client.core.businessprocess.CompNameManager;
import org.eclipse.jubula.client.core.businessprocess.MapCounter;
import org.eclipse.jubula.client.core.model.ICapPO;
import org.eclipse.jubula.client.core.model.ICompNamesPairPO;
import org.eclipse.jubula.client.core.model.IExecTestCasePO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.ISpecTestCasePO;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.core.utils.AbstractNonPostOperatingTreeNodeOperation;
import org.eclipse.jubula.client.core.utils.ITreeTraverserContext;

public class CountCompNameUsage
extends AbstractNonPostOperatingTreeNodeOperation<INodePO> {
    private MapCounter m_usageByGuid;
    private Long m_id = GeneralStorage.getInstance().getProject().getId();
    private CompNameManager m_man = CompNameManager.getInstance();

    public CountCompNameUsage(MapCounter usageMap) {
        this.m_usageByGuid = usageMap;
    }

    @Override
    public boolean operate(ITreeTraverserContext<INodePO> ctx, INodePO parent, INodePO node, boolean alreadyVisited) {
        if (alreadyVisited) {
            return false;
        }
        if (node instanceof ICapPO) {
            ICapPO cap = (ICapPO)node;
            this.addOne(cap.getComponentName());
        } else if (node instanceof IExecTestCasePO && this.m_id.equals(node.getParentProjectId())) {
            IExecTestCasePO execTc = (IExecTestCasePO)node;
            HashSet<String> collectedFirst = new HashSet<String>();
            for (ICompNamesPairPO pair : execTc.getCompNamesPairs()) {
                this.addOne(pair.getSecondName());
                this.addOne(pair.getFirstName());
                collectedFirst.add(pair.getFirstName());
            }
            ISpecTestCasePO spec = execTc.getSpecTestCase();
            if (spec == null) {
                return false;
            }
            this.collectSpecialFirstRefs(spec, collectedFirst);
            return false;
        }
        return true;
    }

    private void collectSpecialFirstRefs(ISpecTestCasePO spec, Set<String> alreadyCollected) {
        Iterator<INodePO> it = spec.getAllNodeIter();
        while (it.hasNext()) {
            INodePO next = it.next();
            String guid = null;
            if (next instanceof ICapPO) {
                guid = ((ICapPO)next).getComponentName();
                if (alreadyCollected.contains(guid)) continue;
                this.addOne(guid);
                this.addOne(guid);
                alreadyCollected.add(guid);
                continue;
            }
            if (!(next instanceof IExecTestCasePO)) continue;
            for (ICompNamesPairPO pair : ((IExecTestCasePO)next).getCompNamesPairs()) {
                if (!pair.isPropagated() || alreadyCollected.contains(pair.getSecondName())) continue;
                this.addOne(pair.getSecondName());
                this.addOne(pair.getSecondName());
                alreadyCollected.add(pair.getSecondName());
            }
        }
    }

    private void addOne(String guid) {
        if (guid != null) {
            this.m_usageByGuid.add(this.m_man.resolveGuid(guid), 1);
        }
    }
}

