/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.errorhandling;

import org.apache.commons.lang.Validate;
import org.eclipse.jubula.client.core.errorhandling.IErrorMessagePresenter;
import org.eclipse.jubula.client.core.errorhandling.NoopErrorMessagePresenter;
import org.eclipse.jubula.client.core.i18n.Messages;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ErrorMessagePresenter {
    private static final Logger LOG = LoggerFactory.getLogger(ErrorMessagePresenter.class);
    private static IErrorMessagePresenter presenter = new NoopErrorMessagePresenter();

    private ErrorMessagePresenter() {
    }

    public static IErrorMessagePresenter getPresenter() {
        return presenter;
    }

    public static void setPresenter(IErrorMessagePresenter errorMessagePresenter) {
        Validate.notNull((Object)errorMessagePresenter);
        if (!(presenter instanceof NoopErrorMessagePresenter)) {
            StringBuilder msg = new StringBuilder();
            msg.append(Messages.ErrorMessagePresenter);
            msg.append(" ");
            msg.append("[");
            msg.append(presenter);
            msg.append("]");
            msg.append(" ");
            msg.append(Messages.IsBeingReplacedWith);
            msg.append(" ");
            msg.append("[");
            msg.append(errorMessagePresenter);
            msg.append("]");
            LOG.warn(msg.toString());
        }
        presenter = errorMessagePresenter;
    }
}

