/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.OrderColumn;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;
import javax.persistence.Version;
import org.eclipse.jubula.client.core.model.ALMReportingRulePO;
import org.eclipse.jubula.client.core.model.CheckConfContPO;
import org.eclipse.jubula.client.core.model.IALMReportingRulePO;
import org.eclipse.jubula.client.core.model.ICheckConfContPO;
import org.eclipse.jubula.client.core.model.IProjectPropertiesPO;
import org.eclipse.jubula.client.core.model.IReusedProjectPO;
import org.eclipse.jubula.client.core.model.ReusedProjectPO;
import org.eclipse.jubula.client.core.utils.TrackingUnit;
import org.eclipse.persistence.annotations.Index;
import org.eclipse.persistence.internal.descriptors.PersistenceEntity;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.jpa.rs.metadata.model.ItemLinks;
import org.eclipse.persistence.internal.jpa.rs.metadata.model.Link;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;
import org.eclipse.persistence.internal.weaving.PersistenceWeavedRest;

@Entity
@Table(name="PROJECT_PROPERTIES", uniqueConstraints={@UniqueConstraint(columnNames={"GUID", "MAJOR_NUMBER", "MINOR_NUMBER", "MICRO_NUMBER", "VERSION_QUALIFIER"})})
class ProjectPropertiesPO
implements IProjectPropertiesPO,
Cloneable,
PersistenceWeaved,
PersistenceEntity,
PersistenceObject,
PersistenceWeavedRest {
    private transient Long m_id = null;
    private Long m_parentProjectId = null;
    private transient Integer m_version = null;
    private Set<IReusedProjectPO> m_usedProjects = new HashSet<IReusedProjectPO>();
    private ICheckConfContPO m_checkConfCont;
    private transient boolean m_isModified = true;
    private String m_toolkit = null;
    private Integer m_majorNumber = null;
    private Integer m_minorNumber = null;
    private Integer m_microNumber = null;
    private String m_versionQualifier = null;
    private boolean m_isReusable = false;
    private boolean m_isTrackingActivated = false;
    private String m_trackChangesSignature = null;
    private TrackingUnit m_trackChangesUnit = null;
    private Integer m_trackChangesSpan = null;
    private String m_markupLanguage = null;
    private boolean m_isProtected = false;
    private Integer m_testResultCleanupInterval = 5;
    private boolean m_reportOnFailure = false;
    private boolean m_reportOnSuccess = false;
    private String m_almRepositoryName = null;
    private String m_dashboardURL = null;
    private List<IALMReportingRulePO> m_reportingRules = new ArrayList<IALMReportingRulePO>();
    private String m_guid;
    static final long serialVersionUID = 4404945449699166046L;
    protected transient Object _persistence_primaryKey;
    protected transient CacheKey _persistence_cacheKey;
    protected transient List _persistence_relationshipInfo;
    protected transient Link _persistence_href;
    protected transient ItemLinks _persistence_links;

    ProjectPropertiesPO() {
        this(null, 1, 0, 0, null);
    }

    ProjectPropertiesPO(String guid, Integer majorNumber, Integer minorNumber, Integer microNumber, String version) {
        this.setGuid(guid);
        this.setMajorNumber(majorNumber);
        this.setMinorNumber(minorNumber);
        this.setMicroNumber(microNumber);
        this.setVersionQualifier(version);
    }

    @Override
    @Id
    @GeneratedValue
    public Long getId() {
        return this.m_id;
    }

    void setId(Long id) {
        this.m_id = id;
    }

    @Override
    @Version
    public Integer getVersion() {
        return this.m_version;
    }

    private void setVersion(Integer version) {
        this.m_version = version;
    }

    @Override
    @Transient
    public String getName() {
        return "Project properties";
    }

    @Override
    @Transient
    public Long getParentProjectId() {
        return this.m_parentProjectId;
    }

    @Override
    public void setParentProjectId(Long projectId) {
        this.m_parentProjectId = projectId;
        for (IReusedProjectPO reusedProj : this.getHbmUsedProjects()) {
            reusedProj.setParentProjectId(projectId);
        }
        if (this.getCheckConfCont() != null) {
            this.getCheckConfCont().setParentProjectId(projectId);
        }
        for (IALMReportingRulePO rule : this.getALMReportingRules()) {
            rule.setParentProjectId(projectId);
        }
    }

    @Override
    @Basic
    @Column(name="GUID")
    @Index(name="PI_NODE_GUID")
    public String getGuid() {
        return this.m_guid;
    }

    private void setGuid(String guid) {
        this.m_guid = guid;
    }

    @Transient
    public boolean isModified() {
        return this.m_isModified;
    }

    public void setModified(boolean isModified) {
        this.m_isModified = isModified;
    }

    @Override
    public void addUsedProject(IReusedProjectPO reusedProject) {
        reusedProject.setParentProjectId(this.getParentProjectId());
        this.getHbmUsedProjects().add(reusedProject);
    }

    @Override
    public void removeUsedProject(IReusedProjectPO project) {
        this.getHbmUsedProjects().remove(project);
    }

    @Override
    @Basic
    @Column(name="IS_REUSABLE")
    public boolean getIsReusable() {
        return this.m_isReusable;
    }

    @Override
    @Basic
    @Column(name="IS_TRACKING_CHANGES")
    public boolean getIsTrackingActivated() {
        return this.m_isTrackingActivated;
    }

    @Override
    @Basic
    @Column(name="IS_PROTECTED")
    public boolean getIsProtected() {
        return this.m_isProtected;
    }

    @Override
    @Transient
    public String getToolkit() {
        return this.getHbmToolkit();
    }

    @Override
    @OneToMany(fetch=FetchType.EAGER, cascade={CascadeType.ALL}, orphanRemoval=true, targetEntity=ALMReportingRulePO.class)
    @JoinColumn(name="FK_PROJECT_PROP", nullable=true)
    @OrderColumn(name="IDX_PROJECT_PROP")
    public List<IALMReportingRulePO> getALMReportingRules() {
        return this.m_reportingRules;
    }

    @Override
    public void setALMReportingRules(List<IALMReportingRulePO> reportingRules) {
        this.m_reportingRules = reportingRules;
    }

    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, targetEntity=ReusedProjectPO.class, fetch=FetchType.EAGER)
    @JoinColumn(name="FK_PROJ_PROPERTIES")
    private Set<IReusedProjectPO> getHbmUsedProjects() {
        return this.m_usedProjects;
    }

    private void setHbmUsedProjects(Set<IReusedProjectPO> reusedProjects) {
        this.m_usedProjects = reusedProjects;
    }

    @Override
    @Transient
    public Set<IReusedProjectPO> getUsedProjects() {
        return Collections.unmodifiableSet(this.getHbmUsedProjects());
    }

    @Override
    public void setIsReusable(boolean isReusable) {
        this.m_isReusable = isReusable;
    }

    @Override
    public void setIsTrackingActivated(boolean isTrackingActivated) {
        this.m_isTrackingActivated = isTrackingActivated;
    }

    @Override
    public void setIsProtected(boolean isProtected) {
        this.m_isProtected = isProtected;
    }

    @Override
    public void setToolkit(String toolkit) {
        this.setHbmToolkit(toolkit);
    }

    @Basic
    @Column(name="TOOLKIT")
    private String getHbmToolkit() {
        return this.m_toolkit;
    }

    private void setHbmToolkit(String toolkit) {
        this.m_toolkit = toolkit;
    }

    @Override
    @Basic
    @Column(name="MAJOR_NUMBER")
    public Integer getMajorNumber() {
        return this.m_majorNumber;
    }

    @Override
    @Basic
    @Column(name="MINOR_NUMBER")
    public Integer getMinorNumber() {
        return this.m_minorNumber;
    }

    @Override
    @Basic
    @Column(name="MICRO_NUMBER")
    public Integer getMicroNumber() {
        return this.m_microNumber;
    }

    @Override
    @Basic
    @Column(name="VERSION_QUALIFIER")
    public String getVersionQualifier() {
        return this.m_versionQualifier;
    }

    private void setMajorNumber(Integer majorNumber) {
        this.m_majorNumber = majorNumber;
    }

    private void setMinorNumber(Integer minorNumber) {
        this.m_minorNumber = minorNumber;
    }

    private void setMicroNumber(Integer microNumber) {
        this.m_microNumber = microNumber;
    }

    private void setVersionQualifier(String versionQualifier) {
        this.m_versionQualifier = versionQualifier;
    }

    @Override
    public void clearUsedProjects() {
        this.getHbmUsedProjects().clear();
    }

    @Override
    @Basic
    @Column(name="TRD_CLEANUP_INTERVAL")
    public Integer getTestResultCleanupInterval() {
        return this.m_testResultCleanupInterval;
    }

    @Override
    public void setTestResultCleanupInterval(Integer noOfDays) {
        this.m_testResultCleanupInterval = noOfDays;
    }

    @Override
    @OneToOne(cascade={CascadeType.ALL}, fetch=FetchType.EAGER, targetEntity=CheckConfContPO.class)
    @JoinColumn(name="CHECK_CONF_CONT", unique=true)
    public ICheckConfContPO getCheckConfCont() {
        return this.m_checkConfCont;
    }

    public void setCheckConfCont(ICheckConfContPO checkConfCont) {
        this.m_checkConfCont = checkConfCont;
    }

    @Override
    @Basic
    @Column(name="DASHBOARD_URL", length=4000)
    public String getDashboardURL() {
        return this.m_dashboardURL;
    }

    @Override
    public void setDashboardURL(String dashboardURL) {
        this.m_dashboardURL = dashboardURL;
    }

    @Override
    @Basic
    @Column(name="ALM_REPOSITORY_NAME", length=4000)
    public String getALMRepositoryName() {
        return this.m_almRepositoryName;
    }

    @Override
    public void setALMRepositoryName(String almRepositoryName) {
        this.m_almRepositoryName = almRepositoryName;
    }

    @Override
    @Basic
    @Column(name="IS_REPORT_ON_SUCCESS")
    public boolean getIsReportOnSuccess() {
        return this.m_reportOnSuccess;
    }

    @Override
    public void setIsReportOnSuccess(boolean isReportOnSuccess) {
        this.m_reportOnSuccess = isReportOnSuccess;
    }

    @Override
    @Basic
    @Column(name="IS_REPORT_ON_FAILURE")
    public boolean getIsReportOnFailure() {
        return this.m_reportOnFailure;
    }

    @Override
    public void setIsReportOnFailure(boolean isReportOnFailure) {
        this.m_reportOnFailure = isReportOnFailure;
    }

    @Override
    @Basic
    @Column(name="TRACK_CHANGES_SIGNATURE")
    public String getTrackChangesSignature() {
        return this.m_trackChangesSignature;
    }

    @Override
    public void setTrackChangesSignature(String signature) {
        this.m_trackChangesSignature = signature;
    }

    @Override
    @Basic
    @Column(name="TRACK_CHANGES_UNIT")
    public TrackingUnit getTrackChangesUnit() {
        return this.m_trackChangesUnit;
    }

    @Override
    public void setTrackChangesUnit(TrackingUnit unit) {
        this.m_trackChangesUnit = unit;
    }

    @Override
    @Basic
    @Column(name="TRACK_CHANGES_SPAN")
    public Integer getTrackChangesSpan() {
        return this.m_trackChangesSpan;
    }

    @Override
    public void setTrackChangesSpan(Integer span) {
        this.m_trackChangesSpan = span;
    }

    @Override
    public void setMarkupLanguage(String markupLanguage) {
        this.m_markupLanguage = markupLanguage;
    }

    @Override
    @Basic
    @Column(name="MARKUP_LANGUAGE")
    public String getMarkupLanguage() {
        return this.m_markupLanguage;
    }

    public Object _persistence_post_clone() {
        this._persistence_primaryKey = null;
        return this;
    }

    public Object _persistence_shallow_clone() {
        return super.clone();
    }

    public Object _persistence_getId() {
        return this._persistence_primaryKey;
    }

    public void _persistence_setId(Object object) {
        this._persistence_primaryKey = object;
    }

    public CacheKey _persistence_getCacheKey() {
        return this._persistence_cacheKey;
    }

    public void _persistence_setCacheKey(CacheKey cacheKey) {
        this._persistence_cacheKey = cacheKey;
    }

    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new ProjectPropertiesPO();
    }

    public Object _persistence_get(String string) {
        if (string == "microNumber") {
            return this.microNumber;
        }
        if (string == "trackChangesSignature") {
            return this.trackChangesSignature;
        }
        if (string == "dashboardURL") {
            return this.dashboardURL;
        }
        if (string == "ALMReportingRules") {
            return this.ALMReportingRules;
        }
        if (string == "versionQualifier") {
            return this.versionQualifier;
        }
        if (string == "isReportOnFailure") {
            return this.isReportOnFailure;
        }
        if (string == "isTrackingActivated") {
            return this.isTrackingActivated;
        }
        if (string == "trackChangesUnit") {
            return this.trackChangesUnit;
        }
        if (string == "isReportOnSuccess") {
            return this.isReportOnSuccess;
        }
        if (string == "hbmToolkit") {
            return this.hbmToolkit;
        }
        if (string == "isReusable") {
            return this.isReusable;
        }
        if (string == "testResultCleanupInterval") {
            return this.testResultCleanupInterval;
        }
        if (string == "version") {
            return this.version;
        }
        if (string == "majorNumber") {
            return this.majorNumber;
        }
        if (string == "minorNumber") {
            return this.minorNumber;
        }
        if (string == "isProtected") {
            return this.isProtected;
        }
        if (string == "markupLanguage") {
            return this.markupLanguage;
        }
        if (string == "trackChangesSpan") {
            return this.trackChangesSpan;
        }
        if (string == "guid") {
            return this.guid;
        }
        if (string == "ALMRepositoryName") {
            return this.ALMRepositoryName;
        }
        if (string == "checkConfCont") {
            return this.checkConfCont;
        }
        if (string == "id") {
            return this.id;
        }
        if (string == "hbmUsedProjects") {
            return this.hbmUsedProjects;
        }
        return null;
    }

    public void _persistence_set(String string, Object object) {
        if (string == "microNumber") {
            this.microNumber = (Integer)object;
            return;
        }
        if (string == "trackChangesSignature") {
            this.trackChangesSignature = (String)object;
            return;
        }
        if (string == "dashboardURL") {
            this.dashboardURL = (String)object;
            return;
        }
        if (string == "ALMReportingRules") {
            this.ALMReportingRules = (List)object;
            return;
        }
        if (string == "versionQualifier") {
            this.versionQualifier = (String)object;
            return;
        }
        if (string == "isReportOnFailure") {
            this.isReportOnFailure = (Boolean)object;
            return;
        }
        if (string == "isTrackingActivated") {
            this.isTrackingActivated = (Boolean)object;
            return;
        }
        if (string == "trackChangesUnit") {
            this.trackChangesUnit = (TrackingUnit)((Object)object);
            return;
        }
        if (string == "isReportOnSuccess") {
            this.isReportOnSuccess = (Boolean)object;
            return;
        }
        if (string == "hbmToolkit") {
            this.hbmToolkit = (String)object;
            return;
        }
        if (string == "isReusable") {
            this.isReusable = (Boolean)object;
            return;
        }
        if (string == "testResultCleanupInterval") {
            this.testResultCleanupInterval = (Integer)object;
            return;
        }
        if (string == "version") {
            this.version = (Integer)object;
            return;
        }
        if (string == "majorNumber") {
            this.majorNumber = (Integer)object;
            return;
        }
        if (string == "minorNumber") {
            this.minorNumber = (Integer)object;
            return;
        }
        if (string == "isProtected") {
            this.isProtected = (Boolean)object;
            return;
        }
        if (string == "markupLanguage") {
            this.markupLanguage = (String)object;
            return;
        }
        if (string == "trackChangesSpan") {
            this.trackChangesSpan = (Integer)object;
            return;
        }
        if (string == "guid") {
            this.guid = (String)object;
            return;
        }
        if (string == "ALMRepositoryName") {
            this.ALMRepositoryName = (String)object;
            return;
        }
        if (string == "checkConfCont") {
            this.checkConfCont = (ICheckConfContPO)object;
            return;
        }
        if (string == "id") {
            this.id = (Long)object;
            return;
        }
        if (string == "hbmUsedProjects") {
            this.hbmUsedProjects = (Set)object;
            return;
        }
    }

    public List _persistence_getRelationships() {
        return this._persistence_relationshipInfo;
    }

    public void _persistence_setRelationships(List list) {
        this._persistence_relationshipInfo = list;
    }

    public Link _persistence_getHref() {
        return this._persistence_href;
    }

    public void _persistence_setHref(Link link) {
        this._persistence_href = link;
    }

    public ItemLinks _persistence_getLinks() {
        return this._persistence_links;
    }

    public void _persistence_setLinks(ItemLinks itemLinks) {
        this._persistence_links = itemLinks;
    }
}

