/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.teststyle.checks.contexts;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jubula.client.core.businessprocess.db.TestJobBP;
import org.eclipse.jubula.client.core.businessprocess.db.TestSuiteBP;
import org.eclipse.jubula.client.core.model.ICommentPO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.teststyle.checks.contexts.BaseContext;
import org.eclipse.jubula.client.teststyle.i18n.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommentContext
extends BaseContext {
    public CommentContext() {
        super(ICommentPO.class);
    }

    @Override
    public String getName() {
        return Messages.ContextCommentName;
    }

    @Override
    public String getDescription() {
        return Messages.ContextCommentDescription;
    }

    @Override
    public List<? extends Object> getAll() {
        ArrayList<Object> tmp = new ArrayList<Object>();
        IProjectPO project = GeneralStorage.getInstance().getProject();
        for (INodePO p : project.getUnmodSpecList()) {
            tmp.addAll(this.getComments(p));
        }
        for (INodePO p : TestSuiteBP.getListOfTestSuites((IProjectPO)project)) {
            tmp.addAll(this.getComments(p));
        }
        for (INodePO p : TestJobBP.getListOfTestJobs((IProjectPO)project)) {
            tmp.addAll(this.getComments(p));
        }
        return tmp;
    }

    private List<Object> getComments(Object root) {
        ArrayList<Object> tmp = new ArrayList<Object>();
        if (root instanceof ICommentPO) {
            tmp.add(root);
        } else if (root instanceof INodePO) {
            INodePO node = (INodePO)root;
            for (Object o : node.getUnmodifiableNodeList()) {
                tmp.addAll(this.getComments(o));
            }
        }
        return tmp;
    }
}

