/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.handlers;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractHandler
extends org.eclipse.core.commands.AbstractHandler {
    static final Logger LOG = LoggerFactory.getLogger(AbstractHandler.class);
    private Shell m_activeShell;

    private void setActiveShell(Shell shell) {
        this.m_activeShell = shell;
    }

    protected Shell getActiveShell() {
        return this.m_activeShell;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        this.setActiveShell(HandlerUtil.getActiveShell((ExecutionEvent)event));
        if (LOG.isDebugEnabled()) {
            StringBuilder str = new StringBuilder();
            str.append("\nCommand executed: ");
            str.append(event.getCommand().getId());
            str.append("\n");
            str.append("Parameters: ");
            str.append(event.getParameters().toString());
            str.append("\n");
            str.append("Handler class: ");
            str.append(((Object)((Object)this)).getClass().getName());
            str.append("\n");
            ISelection sel = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
            if (sel != null && sel instanceof IStructuredSelection && !sel.isEmpty()) {
                IStructuredSelection struct = (IStructuredSelection)sel;
                str.append("The current selection is: ");
                str.append(struct.toString());
                str.append("\n");
            }
            str.append("Active part: ");
            str.append(HandlerUtil.getActivePartId((ExecutionEvent)event));
            str.append("\n");
            LOG.debug(str.toString());
        }
        return this.executeImpl(event);
    }

    protected abstract Object executeImpl(ExecutionEvent var1) throws ExecutionException;
}

