/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.handlers;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jubula.client.ui.controllers.TreeViewContainerGUIController;
import org.eclipse.jubula.client.ui.i18n.Messages;
import org.eclipse.jubula.client.ui.views.IMultiTreeViewerContainer;
import org.eclipse.jubula.client.ui.views.ITreeViewerContainer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpandBranchHandler
extends AbstractHandler {
    private static Logger log = LoggerFactory.getLogger(ExpandBranchHandler.class);

    public Object execute(ExecutionEvent event) {
        try {
            PlatformUI.getWorkbench().getProgressService().run(true, false, (IRunnableWithProgress)new ExpandBranchRunnable(event));
        }
        catch (InvocationTargetException e) {
            log.error("Error during expanding tree", (Throwable)e);
        }
        catch (InterruptedException e) {
            log.error("Error during expanding tree", (Throwable)e);
        }
        return null;
    }

    private class ExpandBranchRunnable
    implements IRunnableWithProgress {
        private ExecutionEvent m_execEvent;

        public ExpandBranchRunnable(ExecutionEvent event) {
            this.m_execEvent = event;
        }

        public void run(IProgressMonitor monitor) {
            monitor.beginTask(Messages.ExpandBranchMessage, -1);
            IWorkbenchPart part = HandlerUtil.getActivePart((ExecutionEvent)this.m_execEvent);
            TreeViewer activeTreeViewer = null;
            if (part instanceof IMultiTreeViewerContainer) {
                activeTreeViewer = ((IMultiTreeViewerContainer)part).getActiveTreeViewer();
            } else if (part instanceof ITreeViewerContainer) {
                activeTreeViewer = ((ITreeViewerContainer)part).getTreeViewer();
            }
            this.expandTree(activeTreeViewer);
        }

        private void expandTree(final TreeViewer activeTreeViewer) {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    TreeViewContainerGUIController.expandBranch(activeTreeViewer);
                }
            });
        }
    }
}

