/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.tools.internal.utils.generator;

import java.text.MessageFormat;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ToolkitConfig {
    private String m_basedir;
    private String m_xmlPath;
    private String m_resourceBundlePath;
    private String m_resourceBundleFQN;
    private List<String> m_toolkitNames;
    private String m_outputdir;

    public ToolkitConfig(String basedir, String xmlPath, String resourceBundlePath, String resourceBundlefqn, String outputDir, List<String> toolkitNames) {
        this.m_basedir = basedir;
        this.m_xmlPath = xmlPath;
        this.m_resourceBundlePath = resourceBundlePath;
        this.m_resourceBundleFQN = resourceBundlefqn;
        this.m_outputdir = outputDir;
        this.m_toolkitNames = toolkitNames;
    }

    public List<String> getToolkitNames() {
        return this.m_toolkitNames;
    }

    public String getXMLPath(String toolkitName) {
        StringBuffer path = new StringBuffer();
        path.append(MessageFormat.format(this.m_basedir, toolkitName));
        path.append('/').append(this.m_xmlPath);
        String result = path.toString();
        return result;
    }

    public String getPluginXMLPath(String toolkitName) {
        StringBuffer path = new StringBuffer();
        path.append(MessageFormat.format(this.m_basedir, toolkitName));
        path.append("/plugin.xml");
        String filename = path.toString();
        return filename;
    }

    public String getResourceBundlePath(String toolkitName) {
        StringBuffer path = this.formatBasename(toolkitName);
        path.append('/');
        path.append(MessageFormat.format(this.m_resourceBundlePath, toolkitName.toLowerCase()));
        String filename = path.toString();
        return filename;
    }

    public String getResourceBundleFQN(String toolkitName) {
        String fqn = MessageFormat.format(this.m_resourceBundleFQN, toolkitName.toLowerCase());
        return fqn;
    }

    private StringBuffer formatBasename(String toolkitName) {
        StringBuffer name = new StringBuffer();
        name.append(MessageFormat.format(this.m_basedir, toolkitName));
        return name;
    }

    public String getOutputdir() {
        return this.m_outputdir;
    }
}

