/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jwt.meta.model.processes;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum OperationType implements Enumerator
{
    EQUALS_LITERAL(0, "Equals", "=="),
    LOWER_LITERAL(1, "Lower", "<"),
    LOWER_EQUALS_LITERAL(2, "LowerEquals", "<="),
    GREATER_LITERAL(3, "Greater", ">"),
    GREATE_EQUALS_LITERAL(4, "GreateEquals", ">="),
    UN_EQUALS_LITERAL(5, "UnEquals", "!=");

    public static final String copyright = "Copyright (c) 2005-2012  Eclipse Java Workflow Tooling (JWT) Project <www.eclipse.org/jwt>";
    public static final int EQUALS = 0;
    public static final int LOWER = 1;
    public static final int LOWER_EQUALS = 2;
    public static final int GREATER = 3;
    public static final int GREATE_EQUALS = 4;
    public static final int UN_EQUALS = 5;
    private static final OperationType[] VALUES_ARRAY;
    public static final List<OperationType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new OperationType[]{EQUALS_LITERAL, LOWER_LITERAL, LOWER_EQUALS_LITERAL, GREATER_LITERAL, GREATE_EQUALS_LITERAL, UN_EQUALS_LITERAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static OperationType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            OperationType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static OperationType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            OperationType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static OperationType get(int value) {
        switch (value) {
            case 0: {
                return EQUALS_LITERAL;
            }
            case 1: {
                return LOWER_LITERAL;
            }
            case 2: {
                return LOWER_EQUALS_LITERAL;
            }
            case 3: {
                return GREATER_LITERAL;
            }
            case 4: {
                return GREATE_EQUALS_LITERAL;
            }
            case 5: {
                return UN_EQUALS_LITERAL;
            }
        }
        return null;
    }

    private OperationType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

