/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.operations.documentLink;

import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.hyperlink.AbstractHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServerPlugin;
import org.eclipse.lsp4e.LanguageServiceAccessor;
import org.eclipse.lsp4j.DocumentLinkParams;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;

public class DocumentLinkDetector
extends AbstractHyperlinkDetector {
    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        IDocument document = textViewer.getDocument();
        URI uri = LSPEclipseUtils.toUri(document);
        if (uri == null) {
            return null;
        }
        DocumentLinkParams params = new DocumentLinkParams(new TextDocumentIdentifier(uri.toString()));
        try {
            return (IHyperlink[])((CompletableFuture)LanguageServiceAccessor.getLanguageServers(textViewer.getDocument(), capabilities -> capabilities.getDocumentLinkProvider() != null).thenApplyAsync(languageServers -> {
                IHyperlink[] res = (IHyperlink[])languageServers.stream().map(languageServer -> languageServer.getTextDocumentService().documentLink(params)).map(future -> {
                    try {
                        return (List)future.get(2L, TimeUnit.SECONDS);
                    }
                    catch (ExecutionException | TimeoutException e) {
                        LanguageServerPlugin.logError(e);
                        return null;
                    }
                    catch (InterruptedException e) {
                        LanguageServerPlugin.logError(e);
                        Thread.currentThread().interrupt();
                        return null;
                    }
                }).filter(Objects::nonNull).flatMap(Collection::stream).map(link -> {
                    try {
                        int start = LSPEclipseUtils.toOffset(link.getRange().getStart(), textViewer.getDocument());
                        int end = LSPEclipseUtils.toOffset(link.getRange().getEnd(), textViewer.getDocument());
                        Region linkRegion = new Region(start, end - start);
                        if (TextUtilities.overlaps((IRegion)region, (IRegion)linkRegion) && link.getTarget() != null) {
                            return new DocumentHyperlink(link.getTarget(), (IRegion)linkRegion);
                        }
                    }
                    catch (BadLocationException ex) {
                        LanguageServerPlugin.logError(ex);
                    }
                    return null;
                }).filter(Objects::nonNull).toArray(IHyperlink[]::new);
                if (res.length == 0) {
                    return null;
                }
                return res;
            })).get(2L, TimeUnit.SECONDS);
        }
        catch (ExecutionException | TimeoutException e) {
            LanguageServerPlugin.logError(e);
            return null;
        }
        catch (InterruptedException e) {
            LanguageServerPlugin.logError(e);
            Thread.currentThread().interrupt();
            return null;
        }
    }

    public static class DocumentHyperlink
    implements IHyperlink {
        private String uri;
        private IRegion highlightRegion;

        public DocumentHyperlink(String uri, IRegion highlightRegion) {
            this.uri = uri;
            this.highlightRegion = highlightRegion;
        }

        public IRegion getHyperlinkRegion() {
            return this.highlightRegion;
        }

        public String getTypeLabel() {
            return this.uri;
        }

        public String getHyperlinkText() {
            return this.uri;
        }

        public void open() {
            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            LSPEclipseUtils.open(this.uri, page, null);
        }
    }
}

