/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.operations.rename;

import java.util.concurrent.TimeUnit;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.text.IDocument;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.ui.Messages;
import org.eclipse.lsp4j.RenameParams;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.eclipse.lsp4j.jsonrpc.ResponseErrorException;
import org.eclipse.lsp4j.jsonrpc.messages.ResponseError;
import org.eclipse.lsp4j.services.LanguageServer;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RefactoringParticipant;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.ltk.core.refactoring.participants.SharableParticipants;

public class LSPRenameProcessor
extends RefactoringProcessor {
    private static final String ID = "org.eclipse.lsp4e.operations.rename";
    private final IDocument document;
    private final LanguageServer languageServer;
    private final int offset;
    private String newName;
    private WorkspaceEdit rename;

    public LSPRenameProcessor(@NonNull IDocument document, LanguageServer languageServer, int offset) {
        this.document = document;
        this.languageServer = languageServer;
        this.offset = offset;
    }

    public Object[] getElements() {
        return null;
    }

    public String getIdentifier() {
        return ID;
    }

    public String getProcessorName() {
        return Messages.rename_processor_name;
    }

    public boolean isApplicable() throws CoreException {
        return true;
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        return new RefactoringStatus();
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm, CheckConditionsContext context) throws CoreException, OperationCanceledException {
        RefactoringStatus status = new RefactoringStatus();
        try {
            RenameParams params = new RenameParams();
            params.setPosition(LSPEclipseUtils.toPosition(this.offset, this.document));
            TextDocumentIdentifier identifier = new TextDocumentIdentifier();
            identifier.setUri(LSPEclipseUtils.toUri(this.document).toString());
            params.setTextDocument(identifier);
            params.setNewName(this.newName);
            if (params.getNewName() != null) {
                this.rename = (WorkspaceEdit)this.languageServer.getTextDocumentService().rename(params).get(1000L, TimeUnit.MILLISECONDS);
                if (!status.hasError() && this.rename.getChanges().isEmpty()) {
                    status.addWarning(Messages.rename_empty_message);
                }
            }
        }
        catch (Exception e) {
            this.handleError(e, status);
        }
        return status;
    }

    private WorkspaceEdit handleError(Throwable e, RefactoringStatus status) {
        if (e.getCause() instanceof ResponseErrorException) {
            ResponseError responseError = ((ResponseErrorException)e.getCause()).getResponseError();
            String message = String.valueOf(responseError.getMessage()) + (responseError.getData() instanceof String ? ": " + responseError.getData() : "");
            status.addFatalError(message);
        } else {
            status.addFatalError(e.getMessage());
        }
        return null;
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        if (this.rename == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.lsp4e", Messages.rename_processor_required));
        }
        return LSPEclipseUtils.toCompositeChange(this.rename);
    }

    public RefactoringParticipant[] loadParticipants(RefactoringStatus status, SharableParticipants sharedParticipants) throws CoreException {
        return null;
    }

    public void setNewName(String newName) {
        Assert.isNotNull((Object)newName);
        this.newName = newName;
    }
}

