/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.emftvm.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.m2m.atl.emftvm.Module;
import org.eclipse.m2m.atl.emftvm.util.EMFTVMUtil;
import org.eclipse.m2m.atl.emftvm.util.ModuleNotFoundException;
import org.eclipse.m2m.atl.emftvm.util.ModuleResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultModuleResolver
implements ModuleResolver {
    public static final String FILE_EXT = ".emftvm";
    private final List<String> uriPrefixes = new ArrayList<String>();
    private final ResourceSet resourceSet;

    public DefaultModuleResolver(String uriPrefix, ResourceSet resourceSet) {
        if (uriPrefix == null) {
            throw new IllegalArgumentException("uriPrefix cannot be null");
        }
        if (resourceSet == null) {
            throw new IllegalArgumentException("resourceSet cannot be null");
        }
        this.uriPrefixes.add(uriPrefix);
        this.resourceSet = resourceSet;
    }

    @Override
    public Module resolveModule(String name) throws ModuleNotFoundException {
        Matcher m = EMFTVMUtil.DELIM_PATTERN.matcher(name);
        String path = m.replaceAll("/");
        ResourceSet rs = this.getResourceSet();
        for (String uriPrefix : this.getUriPrefixes()) {
            URI moduleURI = URI.createURI((String)(String.valueOf(uriPrefix) + path + FILE_EXT));
            try {
                Resource r = rs.getResource(moduleURI, true);
                if (r == null) continue;
                return this.findModule(r, name);
            }
            catch (WrappedException wrappedException) {
            }
            catch (ModuleNotFoundException moduleNotFoundException) {}
        }
        throw new ModuleNotFoundException(String.format("Module %s not found", name));
    }

    public List<String> getUriPrefixes() {
        return Collections.unmodifiableList(this.uriPrefixes);
    }

    public void addUriPrefix(String uriPrefix) {
        if (uriPrefix == null) {
            throw new IllegalArgumentException("uriPrefix cannot be null");
        }
        this.uriPrefixes.add(uriPrefix);
    }

    public ResourceSet getResourceSet() {
        return this.resourceSet;
    }

    private Module findModule(Resource r, String name) throws ModuleNotFoundException {
        for (EObject o : r.getContents()) {
            Module m;
            if (!(o instanceof Module) || !name.equals((m = (Module)o).getName())) continue;
            return m;
        }
        throw new ModuleNotFoundException(String.format("Resource %s does not contain a module %s", r, name));
    }
}

