/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.trac.ui.wizard;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.commons.workbench.forms.SectionComposite;
import org.eclipse.mylyn.internal.trac.core.TracRepositoryConnector;
import org.eclipse.mylyn.internal.trac.core.client.ITracClient;
import org.eclipse.mylyn.internal.trac.core.model.TracSearch;
import org.eclipse.mylyn.internal.trac.core.model.TracSearchFilter;
import org.eclipse.mylyn.internal.trac.core.util.TracUtil;
import org.eclipse.mylyn.internal.trac.ui.TracUiPlugin;
import org.eclipse.mylyn.internal.trac.ui.wizard.Messages;
import org.eclipse.mylyn.tasks.core.IRepositoryQuery;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.mylyn.tasks.ui.wizards.AbstractRepositoryQueryPage2;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class TracQueryPage
extends AbstractRepositoryQueryPage2 {
    private static final int HEIGHT_PRODUCT = 60;
    private static final int HEIGHT_STATUS = 40;
    private static final String PAGE_NAME = "TracSearchPage";
    private static final String SEARCH_URL_ID = "TracSearchPage.SEARCHURL";
    private ListSearchField componentField;
    private TextSearchField descriptionField;
    private TextSearchField keywordsField;
    private ListSearchField milestoneField;
    private ListSearchField priorityField;
    private ListSearchField resolutionField;
    private final Map<String, SearchField> searchFieldByName = new HashMap<String, SearchField>();
    private ListSearchField statusField;
    private TextSearchField summaryField;
    private ListSearchField typeField;
    private ListSearchField versionField;

    public TracQueryPage(TaskRepository repository) {
        this(repository, null);
    }

    public TracQueryPage(TaskRepository repository, IRepositoryQuery query) {
        super(PAGE_NAME, repository, query);
        this.setTitle(Messages.TracQueryPage_Enter_query_parameters);
        this.setDescription(Messages.TracQueryPage_If_attributes_are_blank_or_stale_press_the_Update_button);
        this.setNeedsClear(true);
    }

    public void applyTo(IRepositoryQuery query) {
        query.setUrl(this.getQueryUrl(this.getTaskRepository().getRepositoryUrl()));
        query.setSummary(this.getQueryTitle());
    }

    public boolean canFlipToNextPage() {
        return false;
    }

    public void doRefreshControls() {
        TracRepositoryConnector connector = (TracRepositoryConnector)TasksUi.getRepositoryManager().getRepositoryConnector("trac");
        ITracClient client = connector.getClientManager().getTracClient(this.getTaskRepository());
        this.statusField.setValues(client.getTicketStatus());
        this.resolutionField.setValues(client.getTicketResolutions());
        this.typeField.setValues(client.getTicketTypes());
        this.priorityField.setValues(client.getPriorities());
        this.componentField.setValues(client.getComponents());
        this.versionField.setValues(client.getVersions());
        this.milestoneField.setValues(client.getMilestones());
    }

    protected void doClearControls() {
        this.restoreWidgetValues(new TracSearch());
    }

    public IDialogSettings getDialogSettings() {
        IDialogSettings settings = TracUiPlugin.getDefault().getDialogSettings();
        IDialogSettings dialogSettings = settings.getSection(PAGE_NAME);
        if (dialogSettings == null) {
            dialogSettings = settings.addNewSection(PAGE_NAME);
        }
        return dialogSettings;
    }

    public String getQueryUrl(String repsitoryUrl) {
        TracSearch search = this.getTracSearch();
        StringBuilder sb = new StringBuilder();
        sb.append(repsitoryUrl);
        sb.append("/query?format=tab");
        sb.append(search.toUrl());
        return sb.toString();
    }

    public void saveState() {
        IDialogSettings settings = this.getDialogSettings();
        settings.put(this.getSavedStateSettingsKey(), this.getTracSearch().toUrl());
    }

    private String getSavedStateSettingsKey() {
        return "TracSearchPage.SEARCHURL." + this.getTaskRepository().getRepositoryUrl();
    }

    private TracSearch getTracSearch() {
        TracSearch search = new TracSearch();
        for (SearchField field : this.searchFieldByName.values()) {
            TracSearchFilter filter = field.getFilter();
            if (filter == null) continue;
            search.addFilter(filter);
        }
        return search;
    }

    private void restoreWidgetValues(TracSearch search) {
        HashSet<SearchField> allFields = new HashSet<SearchField>(this.searchFieldByName.values());
        List filters = search.getFilters();
        for (TracSearchFilter filter : filters) {
            SearchField field = this.searchFieldByName.get(filter.getFieldName());
            if (field != null) {
                field.setFilter(filter);
                allFields.remove(field);
                continue;
            }
            StatusHandler.log((IStatus)new Status(2, "org.eclipse.mylyn.trac.ui", "Ignoring invalid search filter: " + filter));
        }
        for (SearchField field : allFields) {
            field.clear();
        }
    }

    protected void createPageContent(SectionComposite composite) {
        Composite control = composite.getContent();
        GridLayout layout = new GridLayout(4, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        control.setLayout((Layout)layout);
        this.createDefaultGroup(control);
        this.createProductGroup(control);
        this.createTicketGroup(control);
        this.createUserGroup(control);
    }

    private void createDefaultGroup(Composite control) {
        this.summaryField = new TextSearchField("summary");
        this.summaryField.createControls(control, Messages.TracQueryPage_Summary);
        this.descriptionField = new TextSearchField("description");
        this.descriptionField.createControls(control, Messages.TracQueryPage_Description);
        this.keywordsField = new TextSearchField("keywords");
        this.keywordsField.createControls(control, Messages.TracQueryPage_Keywords);
    }

    protected Control createProductGroup(Composite control) {
        Composite group = new Composite(control, 0);
        GridDataFactory.fillDefaults().grab(true, true).align(4, 4).span(4, 1).applyTo((Control)group);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 3;
        group.setLayout((Layout)layout);
        Label label = new Label(group, 16384);
        label.setText(Messages.TracQueryPage_Component);
        label = new Label(group, 16384);
        label.setText(Messages.TracQueryPage_Version);
        label = new Label(group, 16384);
        label.setText(Messages.TracQueryPage_Milestone);
        this.componentField = new ListSearchField("component");
        this.componentField.createControls(group, 60);
        this.versionField = new ListSearchField("version");
        this.versionField.createControls(group, 60);
        this.milestoneField = new ListSearchField("milestone");
        this.milestoneField.createControls(group, 60);
        return group;
    }

    protected Control createTicketGroup(Composite control) {
        Composite group = new Composite(control, 0);
        GridDataFactory.fillDefaults().grab(true, true).align(4, 4).span(4, 1).applyTo((Control)group);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 4;
        group.setLayout((Layout)layout);
        Label label = new Label(group, 16384);
        label.setText(Messages.TracQueryPage_Status);
        label = new Label(group, 16384);
        label.setText(Messages.TracQueryPage_Resolution);
        label = new Label(group, 16384);
        label.setText(Messages.TracQueryPage_Type);
        label = new Label(group, 16384);
        label.setText(Messages.TracQueryPage_Priority);
        this.statusField = new ListSearchField("status");
        this.statusField.createControls(group, 40);
        this.resolutionField = new ListSearchField("resolution");
        this.resolutionField.createControls(group, 40);
        this.typeField = new ListSearchField("type");
        this.typeField.createControls(group, 40);
        this.priorityField = new ListSearchField("priority");
        this.priorityField.createControls(group, 40);
        return group;
    }

    protected void createUserGroup(Composite control) {
        UserSearchField userField = new UserSearchField();
        userField.createControls(control);
    }

    protected boolean hasRepositoryConfiguration() {
        TracRepositoryConnector connector = (TracRepositoryConnector)TasksUi.getRepositoryManager().getRepositoryConnector("trac");
        ITracClient client = connector.getClientManager().getTracClient(this.getTaskRepository());
        return client.hasAttributes();
    }

    protected boolean restoreState(IRepositoryQuery query) {
        TracSearch search = TracUtil.toTracSearch((IRepositoryQuery)query);
        if (search != null) {
            this.restoreWidgetValues(search);
            return true;
        }
        return false;
    }

    protected boolean restoreSavedState() {
        IDialogSettings settings = this.getDialogSettings();
        String searchUrl = settings.get(this.getSavedStateSettingsKey());
        if (searchUrl != null) {
            this.restoreWidgetValues(new TracSearch(searchUrl));
            return true;
        }
        return false;
    }

    private class ListSearchField
    extends SearchField {
        private org.eclipse.swt.widgets.List list;

        public ListSearchField(String fieldName) {
            super(fieldName);
        }

        public void createControls(Composite parent, int height) {
            this.list = new org.eclipse.swt.widgets.List(parent, 2562);
            GridData gd = new GridData(4, 4, true, true);
            gd.heightHint = height;
            this.list.setLayoutData((Object)gd);
        }

        @Override
        public TracSearchFilter getFilter() {
            int[] indicies = this.list.getSelectionIndices();
            if (indicies.length == 0) {
                return null;
            }
            TracSearchFilter newFilter = new TracSearchFilter(this.getFieldName());
            newFilter.setOperator(TracSearchFilter.CompareOperator.IS);
            int[] nArray = indicies;
            int n = indicies.length;
            int n2 = 0;
            while (n2 < n) {
                int i = nArray[n2];
                newFilter.addValue(this.list.getItem(i));
                ++n2;
            }
            return newFilter;
        }

        @Override
        public void setFilter(TracSearchFilter filter) {
            this.list.deselectAll();
            List values = filter.getValues();
            for (String item : values) {
                int i = this.list.indexOf(item);
                if (i != -1) {
                    this.list.select(i);
                    continue;
                }
                this.list.add(item, 0);
                this.list.select(0);
            }
        }

        public void setValues(Object[] items) {
            TracSearchFilter filter = this.getFilter();
            this.list.removeAll();
            if (items != null) {
                this.list.setEnabled(true);
                Object[] objectArray = items;
                int n = items.length;
                int n2 = 0;
                while (n2 < n) {
                    Object item = objectArray[n2];
                    this.list.add(item.toString());
                    ++n2;
                }
                if (filter != null) {
                    this.setFilter(filter);
                }
            } else {
                this.list.setEnabled(false);
            }
        }

        @Override
        public void clear() {
            this.list.deselectAll();
        }
    }

    private abstract class SearchField {
        protected String fieldName;

        public SearchField(String fieldName) {
            this.fieldName = fieldName;
            if (fieldName != null) {
                assert (!TracQueryPage.this.searchFieldByName.containsKey(fieldName));
                TracQueryPage.this.searchFieldByName.put(fieldName, this);
            }
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public abstract TracSearchFilter getFilter();

        public abstract void setFilter(TracSearchFilter var1);

        public abstract void clear();
    }

    private class TextSearchField
    extends SearchField {
        private final TracSearchFilter.CompareOperator[] compareOperators;
        private Combo conditionCombo;
        private Label label;
        protected Text searchText;

        public TextSearchField(String fieldName) {
            super(fieldName);
            this.compareOperators = new TracSearchFilter.CompareOperator[]{TracSearchFilter.CompareOperator.CONTAINS, TracSearchFilter.CompareOperator.CONTAINS_NOT, TracSearchFilter.CompareOperator.BEGINS_WITH, TracSearchFilter.CompareOperator.ENDS_WITH, TracSearchFilter.CompareOperator.IS, TracSearchFilter.CompareOperator.IS_NOT};
        }

        public void createControls(Composite parent, String labelText) {
            if (labelText != null) {
                this.label = new Label(parent, 16384);
                this.label.setText(labelText);
            }
            this.conditionCombo = new Combo(parent, 2060);
            TracSearchFilter.CompareOperator[] compareOperatorArray = this.compareOperators;
            int n = this.compareOperators.length;
            int n2 = 0;
            while (n2 < n) {
                TracSearchFilter.CompareOperator op = compareOperatorArray[n2];
                this.conditionCombo.add(op.toString());
                ++n2;
            }
            this.conditionCombo.setText(this.compareOperators[0].toString());
            this.searchText = new Text(parent, 2048);
            GridData gd = new GridData(4, 0x1000000, true, false);
            if (this.fieldName != null) {
                gd.horizontalSpan = 2;
            }
            this.searchText.setLayoutData((Object)gd);
        }

        public TracSearchFilter.CompareOperator getCondition() {
            return this.compareOperators[this.conditionCombo.getSelectionIndex()];
        }

        @Override
        public TracSearchFilter getFilter() {
            String text = this.getSearchText();
            if (text.length() == 0) {
                return null;
            }
            TracSearchFilter newFilter = new TracSearchFilter(this.getFieldName());
            newFilter.setOperator(this.getCondition());
            newFilter.addValue(this.getSearchText());
            return newFilter;
        }

        public String getSearchText() {
            return this.searchText.getText();
        }

        public boolean setCondition(TracSearchFilter.CompareOperator operator) {
            int i;
            if (this.conditionCombo != null && (i = this.conditionCombo.indexOf(operator.toString())) != -1) {
                this.conditionCombo.select(i);
                return true;
            }
            return false;
        }

        public void setFieldName(String fieldName) {
            this.fieldName = fieldName;
        }

        @Override
        public void setFilter(TracSearchFilter filter) {
            this.setCondition(filter.getOperator());
            List values = filter.getValues();
            this.setSearchText((String)values.get(0));
        }

        public void setSearchText(String text) {
            this.searchText.setText(text);
        }

        @Override
        public void clear() {
            this.searchText.setText("");
            this.conditionCombo.select(0);
        }
    }

    private class UserSearchField
    extends SearchField {
        private final TextSearchField textField;
        private Combo userCombo;

        public UserSearchField() {
            super(null);
            this.textField = new TextSearchField(null);
            new UserSelectionSearchField("owner", 0);
            new UserSelectionSearchField("reporter", 1);
            new UserSelectionSearchField("cc", 2);
        }

        public void createControls(Composite parent) {
            this.userCombo = new Combo(parent, 2060);
            this.userCombo.add(Messages.TracQueryPage_Owner);
            this.userCombo.add(Messages.TracQueryPage_Reporter);
            this.userCombo.add(Messages.TracQueryPage_CC);
            this.userCombo.select(0);
            this.textField.createControls(parent, null);
        }

        @Override
        public TracSearchFilter getFilter() {
            return null;
        }

        @Override
        public void setFilter(TracSearchFilter filter) {
        }

        private int getSelection() {
            return this.userCombo.getSelectionIndex();
        }

        private void setSelection(int index) {
            this.userCombo.select(index);
        }

        @Override
        public void clear() {
            this.textField.clear();
        }

        class UserSelectionSearchField
        extends SearchField {
            private final int index;

            public UserSelectionSearchField(String fieldName, int index) {
                super(fieldName);
                this.index = index;
            }

            @Override
            public TracSearchFilter getFilter() {
                if (this.index == UserSearchField.this.getSelection()) {
                    UserSearchField.this.textField.setFieldName(this.fieldName);
                    return UserSearchField.this.textField.getFilter();
                }
                return null;
            }

            @Override
            public void setFilter(TracSearchFilter filter) {
                UserSearchField.this.textField.setFieldName(this.fieldName);
                UserSearchField.this.textField.setFilter(filter);
                UserSearchField.this.setSelection(this.index);
            }

            @Override
            public void clear() {
                UserSearchField.this.textField.clear();
            }
        }
    }
}

