/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.internal.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.eclipse.net4j.db.BatchedStatement;
import org.eclipse.net4j.db.DBException;
import org.eclipse.net4j.db.jdbc.DelegatingPreparedStatement;

public final class BatchedStatementImpl
extends DelegatingPreparedStatement
implements BatchedStatement {
    private final int batchSize;
    private int batchCount;
    private int totalResult;

    public BatchedStatementImpl(PreparedStatement delegate, int batchSize) throws DBException {
        super(delegate, BatchedStatementImpl.getConnection(delegate));
        this.batchSize = batchSize;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public int getBatchCount() {
        return this.batchCount;
    }

    public int getTotalResult() {
        return this.totalResult;
    }

    public int executeUpdate() throws SQLException {
        PreparedStatement delegate = this.getDelegate();
        delegate.addBatch();
        if (++this.batchCount >= this.batchSize) {
            return this.doExecuteBatch();
        }
        return 0;
    }

    public void close() throws SQLException {
        if (this.batchCount != 0) {
            this.doExecuteBatch();
        }
        super.close();
    }

    public ResultSet getResultSet() throws SQLException {
        throw new UnsupportedOperationException("Only updates are supported");
    }

    public ResultSet executeQuery() throws SQLException {
        throw new UnsupportedOperationException("Only updates are supported");
    }

    @Deprecated
    public ResultSet executeQuery(String sql) throws SQLException {
        throw new UnsupportedOperationException("Only updates are supported");
    }

    private int doExecuteBatch() throws SQLException {
        int sum = 0;
        int[] results = this.getDelegate().executeBatch();
        int i = 0;
        while (i < results.length) {
            int result = results[i];
            if (result != -2) {
                if (result < 0) {
                    throw new DBException("Result " + i + " is not successful: " + result);
                }
                sum += result;
            }
            ++i;
        }
        this.totalResult += sum;
        return sum;
    }

    private static Connection getConnection(PreparedStatement delegate) throws DBException {
        try {
            return delegate.getConnection();
        }
        catch (SQLException ex) {
            throw new DBException(ex);
        }
    }
}

